/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings10;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEIndustrialBrewery
extends MTEExtendedPowerMultiBlockBase<MTEIndustrialBrewery>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEIndustrialBrewery> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"BBB", "BBB", "B~B", "BBB", "C C"}, {"BBB", "A A", "A A", "BBB", "   "}, {"BBB", "BAB", "BAB", "BBB", "C C"}}).addElement('B', GTStructureUtility.buildHatchAdder(MTEIndustrialBrewery.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Energy).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(15)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEIndustrialBrewery::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)15)))).addElement('A', Glasses.chainAllGlasses()).addElement('C', GTStructureUtility.ofFrame(Materials.Steel)).build();
    private int mCasingAmount;

    public MTEIndustrialBrewery(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialBrewery(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEIndustrialBrewery> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialBrewery(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 15)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_BREWERY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_BREWERY_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 15)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_BREWERY).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_BREWERY_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 15))};
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Brewery").addInfo("Controller Block for the Big Barrel Brewery").addInfo("50% faster than singleblock machines of the same voltage").addInfo("Gains 4 parallels per voltage tier").addInfo(GTValues.AuthorFourIsTheNumber).addSeparator().beginStructureBlock(3, 5, 3, true).addController("Front Center").addCasingInfoMin("Reinforced Wooden Casing", 14, false).addCasingInfoExactly("Any Glass", 6, false).addCasingInfoExactly("Steel Frame Box", 4, false).addInputBus("Any Wooden Casing", 1).addOutputBus("Any Wooden Casing", 1).addInputHatch("Any Wooden Casing", 1).addOutputHatch("Any Wooden Casing", 1).addEnergyHatch("Any Wooden Casing", 1).addMaintenanceHatch("Any Wooden Casing", 1).toolTipFinisher("GregTech");
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 2, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 2, 0, elementBudget, env, false, true);
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 2, 0) && this.mCasingAmount >= 14;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTUtility.roundUpVoltage(this.getMaxInputVoltage()));
        logic.setAvailableAmperage(1L);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)new ProcessingLogic().setSpeedBonus(0.6666666865348816)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    public int getMaxParallelRecipes() {
        return 4 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.brewingRecipes;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }
}

