/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.machines.basic.MTECharger;
import net.minecraft.item.ItemStack;

public class MTETurboCharger
extends MTECharger {
    public MTETurboCharger(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aDescription, aSlotCount);
    }

    public MTETurboCharger(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETurboCharger(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mInventory.length);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[2][17][];
        for (int b = -1; b < 16; b = (int)((byte)(b + 1))) {
            rTextures[0][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1]};
            rTextures[1][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_POWER[this.mTier]};
        }
        return rTextures;
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier] * 1536L * (long)this.mInventory.length;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 6144L * (long)this.mInventory.length;
    }

    @Override
    public long maxAmperesIn() {
        return 16L * (long)this.mInventory.length;
    }

    @Override
    public long maxAmperesOut() {
        return 4L * (long)this.mInventory.length;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            BaseMetaTileEntity mBaseMetaTileEntity;
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L || !aBaseMetaTileEntity.isAllowedToWork();
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L && aBaseMetaTileEntity.isAllowedToWork();
            this.mBatteryCount = 0;
            this.mChargeableCount = 0;
            for (ItemStack tStack : this.mInventory) {
                if (!GTModHandler.isElectricItem(tStack, this.mTier)) continue;
                if (GTModHandler.isChargerItem(tStack)) {
                    ++this.mBatteryCount;
                }
                ++this.mChargeableCount;
            }
            if (this.getBaseMetaTileEntity() instanceof BaseMetaTileEntity && (mBaseMetaTileEntity = (BaseMetaTileEntity)this.getBaseMetaTileEntity()).getMetaTileEntity() instanceof MetaTileEntity) {
                int i;
                MetaTileEntity mMetaTileEntity = (MetaTileEntity)mBaseMetaTileEntity.getMetaTileEntity();
                if (mMetaTileEntity.dechargerSlotCount() > 0 && mBaseMetaTileEntity.getStoredEU() < mBaseMetaTileEntity.getEUCapacity()) {
                    int k = mMetaTileEntity.dechargerSlotCount() + i;
                    for (i = mMetaTileEntity.dechargerSlotStartIndex(); i < k; ++i) {
                        if (mMetaTileEntity.mInventory[i] == null || mBaseMetaTileEntity.getStoredEU() >= mBaseMetaTileEntity.getEUCapacity()) continue;
                        mBaseMetaTileEntity.increaseStoredEnergyUnits(GTModHandler.dischargeElectricItem(mMetaTileEntity.mInventory[i], GTUtility.safeInt(Math.min(GTValues.V[this.mTier] * 120L, mBaseMetaTileEntity.getEUCapacity() - mBaseMetaTileEntity.getStoredEU())), (int)Math.min(Integer.MAX_VALUE, mMetaTileEntity.getInputTier()), true, false, false), true);
                        if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        mMetaTileEntity.mInventory[i] = null;
                    }
                }
                if (mMetaTileEntity.rechargerSlotCount() > 0 && mBaseMetaTileEntity.getStoredEU() > 0L) {
                    int k = mMetaTileEntity.rechargerSlotCount() + i;
                    for (i = mMetaTileEntity.rechargerSlotStartIndex(); i < k; ++i) {
                        if (mBaseMetaTileEntity.getStoredEU() <= 0L || mMetaTileEntity.mInventory[i] == null) continue;
                        mBaseMetaTileEntity.decreaseStoredEU(GTModHandler.chargeElectricItem(mMetaTileEntity.mInventory[i], GTUtility.safeInt(Math.min(GTValues.V[this.mTier] * 120L, mBaseMetaTileEntity.getStoredEU())), (int)Math.min(Integer.MAX_VALUE, mMetaTileEntity.getOutputTier()), true, false), true);
                        if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        mMetaTileEntity.mInventory[i] = null;
                    }
                }
            }
        }
    }
}

