/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import cpw.mods.fml.common.eventhandler.Event;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.items.behaviors.BehaviourNone;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;

public class BehaviourHoe
extends BehaviourNone {
    private final int mCosts;
    private final String mTooltip = GTLanguageManager.addStringLocalization("gt.behaviour.hoe", "Can till Dirt");

    public BehaviourHoe(int aCosts) {
        this.mCosts = aCosts;
    }

    @Override
    public boolean onItemUse(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ) {
        if (!aPlayer.func_82247_a(aX, aY, aZ, ordinalSide, aStack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(aPlayer, aStack, aWorld, aX, aY, aZ);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!aPlayer.field_71075_bZ.field_75098_d) {
                ((MetaGeneratedTool)aItem).doDamage(aStack, this.mCosts);
            }
            return true;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (ordinalSide != 0 && GTUtility.isBlockAir(aWorld, aX, aY + 1, aZ) && (aBlock == Blocks.field_150349_c || aBlock == Blocks.field_150346_d)) {
            new WorldSpawnedEventBuilder.SoundEventBuilder().setVolume((Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f).setPitch(Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f).setIdentifier(Blocks.field_150458_ak.field_149762_H.func_150498_e()).setPosition((float)aX + 0.5f, (float)aY + 0.5f, (float)aZ + 0.5f).setWorld(aWorld).run();
            if (aWorld.field_72995_K) {
                return true;
            }
            aWorld.func_147449_b(aX, aY, aZ, Blocks.field_150458_ak);
            if (!aPlayer.field_71075_bZ.field_75098_d) {
                ((MetaGeneratedTool)aItem).doDamage(aStack, this.mCosts);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }
}

