/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.world;

import gregtech.common.WorldgenGTOreLayer;
import gregtech.common.WorldgenGTOreSmallPieces;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;

public abstract class GTWorldgen {
    public final String mWorldGenName;
    public final boolean mEnabled;
    private final Map<String, Boolean> mDimensionMap = new ConcurrentHashMap<String, Boolean>();

    public GTWorldgen(String aName, List aList, boolean aDefault) {
        this.mWorldGenName = aName;
        this.mEnabled = aDefault;
        if (this.mEnabled) {
            aList.add(this);
        }
    }

    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        return false;
    }

    public int executeWorldgenChunkified(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, int seedX, int seedZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        return 4;
    }

    public boolean isGenerationAllowed(String aDimName, int aDimensionType, int aAllowedDimensionType) {
        if (aDimName.equalsIgnoreCase("Underdark")) {
            return false;
        }
        if (!(aDimName.equalsIgnoreCase("Overworld") || aDimName.equalsIgnoreCase("Nether") || aDimName.equalsIgnoreCase("The End") || aDimName.equalsIgnoreCase("Twilight Forest"))) {
            return false;
        }
        Boolean tAllowed = this.mDimensionMap.get(aDimName);
        if (tAllowed == null) {
            this.mDimensionMap.put(aDimName, aDimensionType == aAllowedDimensionType);
            return aDimensionType == aAllowedDimensionType;
        }
        return tAllowed;
    }

    public boolean isGenerationAllowed(World aWorld, int aAllowedDimensionType) {
        WorldServer allowedWorld = DimensionManager.getWorld((int)aAllowedDimensionType);
        if (allowedWorld != null && allowedWorld.field_73011_w != null) {
            return this.isGenerationAllowed(aWorld, allowedWorld.field_73011_w.getClass());
        }
        return aWorld.field_73011_w.field_76574_g == aAllowedDimensionType;
    }

    public boolean isGenerationAllowed(World aWorld, Class ... aAllowedDimensionTypes) {
        String aDimName = aWorld.field_73011_w.func_80007_l();
        if (aDimName.equalsIgnoreCase("Underdark")) {
            return false;
        }
        if (!(aDimName.equalsIgnoreCase("Overworld") || aDimName.equalsIgnoreCase("Nether") || aDimName.equalsIgnoreCase("The End") || aDimName.equalsIgnoreCase("Twilight Forest"))) {
            return false;
        }
        Boolean tAllowed = this.mDimensionMap.get(aDimName);
        if (tAllowed == null) {
            boolean value = false;
            for (int i = 0; i < aAllowedDimensionTypes.length; ++i) {
                if (!aAllowedDimensionTypes[i].isInstance(aWorld.field_73011_w)) continue;
                value = true;
            }
            GTWorldgen gTWorldgen = this;
            if (gTWorldgen instanceof WorldgenGTOreSmallPieces) {
                WorldgenGTOreSmallPieces ore = (WorldgenGTOreSmallPieces)gTWorldgen;
                if (ore.twilightForest && aWorld.field_73011_w.field_76574_g == 7) {
                    value = true;
                }
            }
            if ((gTWorldgen = this) instanceof WorldgenGTOreLayer) {
                WorldgenGTOreLayer ore = (WorldgenGTOreLayer)gTWorldgen;
                if (ore.twilightForest && aWorld.field_73011_w.field_76574_g == 7) {
                    value = true;
                }
            }
            this.mDimensionMap.put(aDimName, value);
            return value;
        }
        return tAllowed;
    }
}

