/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.FMLCommonHandler;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.objects.GTItemStack;
import gregtech.api.util.AssemblyLineServer;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.FluidStack;

public class AssemblyLineUtils {
    private static final HashMap<GTItemStack, GTRecipe.RecipeAssemblyLine> sRecipeCacheByOutput = new HashMap();
    private static final HashMap<String, GTRecipe.RecipeAssemblyLine> sRecipeCacheByRecipeHash = new HashMap();

    public static GTRecipe.RecipeAssemblyLine processDataStick(ItemStack aDataStick) {
        GTRecipe.RecipeAssemblyLine aIntendedRecipe;
        ItemStack aStickOutput;
        if (!AssemblyLineUtils.isItemDataStick(aDataStick)) {
            return null;
        }
        if (AssemblyLineUtils.doesDataStickNeedUpdate(aDataStick) && (aStickOutput = AssemblyLineUtils.getDataStickOutput(aDataStick)) != null && (aIntendedRecipe = AssemblyLineUtils.findAssemblyLineRecipeByOutput(aStickOutput)) != null && AssemblyLineUtils.setAssemblyLineRecipeOnDataStick(aDataStick, aIntendedRecipe)) {
            return aIntendedRecipe;
        }
        return null;
    }

    public static GTRecipe.RecipeAssemblyLine findAssemblyLineRecipeFromDataStick(ItemStack aDataStick) {
        return AssemblyLineUtils.findAssemblyLineRecipeFromDataStick(aDataStick, false).getRecipe();
    }

    @Nonnull
    public static LookupResult findAssemblyLineRecipeFromDataStick(ItemStack aDataStick, boolean aReturnBuiltRecipe) {
        int i;
        GTRecipe.RecipeAssemblyLine aRecipeFromCache;
        if (!AssemblyLineUtils.isItemDataStick(aDataStick) || !AssemblyLineUtils.doesDataStickHaveOutput(aDataStick)) {
            return LookupResultType.INVALID_STICK.getResult();
        }
        ArrayList<ItemStack> aInputs = new ArrayList<ItemStack>(16);
        ItemStack aOutput = AssemblyLineUtils.getDataStickOutput(aDataStick);
        ArrayList<List<ItemStack>> mOreDictAlt = new ArrayList<List<ItemStack>>(16);
        ArrayList<FluidStack> aFluidInputs = new ArrayList<FluidStack>(4);
        NBTTagCompound aTag = aDataStick.func_77978_p();
        if (aTag == null) {
            return LookupResultType.INVALID_STICK.getResult();
        }
        if (AssemblyLineUtils.doesDataStickHaveRecipeHash(aDataStick) && (aRecipeFromCache = sRecipeCacheByRecipeHash.get(AssemblyLineUtils.getHashFromDataStack(aDataStick))) != null && GTUtility.areStacksEqual(aOutput, aRecipeFromCache.mOutput)) {
            return LookupResultType.VALID_STACK_AND_VALID_HASH.getResult(aRecipeFromCache);
        }
        for (i = 0; i < 16; ++i) {
            int count = aTag.func_74762_e("a" + i);
            if (!aTag.func_74764_b("" + i) && count <= 0) continue;
            ArrayList<ItemStack> tAltCurrent = new ArrayList<ItemStack>();
            for (int j = 0; j < count; ++j) {
                ItemStack tLoaded = GTUtility.loadItem(aTag, "a" + i + ":" + j);
                if (tLoaded == null) continue;
                tAltCurrent.add(tLoaded);
                if (!GTValues.D1) continue;
                GTMod.GT_FML_LOGGER.info("Item Alt " + i + " : " + tLoaded.func_77977_a());
            }
            mOreDictAlt.add(tAltCurrent);
            ItemStack tLoaded = GTUtility.loadItem(aTag, "" + i);
            if (tLoaded == null) continue;
            aInputs.add(tLoaded);
            if (!GTValues.D1) continue;
            GTMod.GT_FML_LOGGER.info("Item " + i + " : " + tLoaded.func_77977_a());
        }
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("All Items done, start fluid check");
        }
        for (i = 0; i < 4; ++i) {
            FluidStack tLoaded;
            if (!aTag.func_74764_b("f" + i) || (tLoaded = GTUtility.loadFluid(aTag, "f" + i)) == null) continue;
            aFluidInputs.add(tLoaded);
            if (!GTValues.D1) continue;
            GTMod.GT_FML_LOGGER.info("Fluid " + i + " " + tLoaded.getUnlocalizedName());
        }
        if (!(aTag.func_74764_b("output") && aTag.func_74764_b("time") && aTag.func_74762_e("time") > 0 && aTag.func_74764_b("eu") && GTUtility.isStackValid(aOutput))) {
            return LookupResultType.INVALID_STICK.getResult();
        }
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Found Data Stick recipe");
        }
        int aTime = aTag.func_74762_e("time");
        int aEU = aTag.func_74762_e("eu");
        if (aReturnBuiltRecipe) {
            return LookupResultType.VALID_STACK_AND_VALID_HASH.getResult(new GTRecipe.RecipeAssemblyLine(null, 0, aInputs.toArray(new ItemStack[0]), aFluidInputs.toArray(new FluidStack[0]), aOutput, aTime, aEU));
        }
        for (GTRecipe.RecipeAssemblyLine aRecipe : GTRecipe.RecipeAssemblyLine.sAssemblylineRecipes) {
            String aStickHash;
            if (aRecipe.mEUt != aEU || aRecipe.mDuration != aTime || !GTUtility.areStacksEqual(aOutput, aRecipe.mOutput, true) || !GTUtility.areStackListsEqual(Arrays.asList(aRecipe.mInputs), aInputs, false, true) || !Objects.equals(Arrays.asList(aRecipe.mFluidInputs), aFluidInputs) || !AssemblyLineUtils.areStacksEqual(aRecipe.mOreDictAlt, mOreDictAlt)) continue;
            String aRecipeHash = AssemblyLineUtils.generateRecipeHash(aRecipe);
            sRecipeCacheByRecipeHash.put(aRecipeHash, aRecipe);
            sRecipeCacheByOutput.put(new GTItemStack(aRecipe.mOutput), aRecipe);
            if (AssemblyLineUtils.doesDataStickHaveRecipeHash(aDataStick) && aRecipeHash.equals(aStickHash = AssemblyLineUtils.getHashFromDataStack(aDataStick))) {
                return LookupResultType.VALID_STACK_AND_VALID_HASH.getResult(aRecipe);
            }
            return LookupResultType.VALID_STACK_AND_VALID_RECIPE.getResult(aRecipe);
        }
        return LookupResultType.VALID_STACK_BUT_INVALID_RECIPE.getResult();
    }

    private static boolean areStacksEqual(ItemStack[][] lhs, List<List<ItemStack>> rhs) {
        for (int i = 0; i < lhs.length; ++i) {
            if (AssemblyLineUtils.areStacksEqual(lhs[i], rhs.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areStacksEqual(ItemStack[] lhs, List<ItemStack> rhs) {
        return lhs == null ? rhs.isEmpty() : !rhs.isEmpty() && GTUtility.areStackListsEqual(Arrays.asList(lhs), rhs, false, true);
    }

    public static GTRecipe.RecipeAssemblyLine findAssemblyLineRecipeByOutput(ItemStack aOutput) {
        if (aOutput == null) {
            return null;
        }
        GTItemStack aCacheStack = new GTItemStack(aOutput);
        GTRecipe.RecipeAssemblyLine aRecipeFromCache = sRecipeCacheByOutput.get(aCacheStack);
        if (aRecipeFromCache != null) {
            return aRecipeFromCache;
        }
        for (GTRecipe.RecipeAssemblyLine aRecipe : GTRecipe.RecipeAssemblyLine.sAssemblylineRecipes) {
            ItemStack aRecipeOutput = aRecipe.mOutput;
            if (!GTUtility.areStacksEqual(aRecipeOutput, aOutput)) continue;
            sRecipeCacheByOutput.put(aCacheStack, aRecipe);
            sRecipeCacheByRecipeHash.put(AssemblyLineUtils.generateRecipeHash(aRecipe), aRecipe);
            return aRecipe;
        }
        return null;
    }

    public static String generateRecipeHash(GTRecipe.RecipeAssemblyLine aRecipe) {
        String aHash = "Invalid.Recipe.Hash";
        if (aRecipe != null) {
            aHash = "Hash." + aRecipe.getPersistentHash();
        }
        return aHash;
    }

    public static void addRecipeToCache(GTRecipe.RecipeAssemblyLine aRecipe) {
        if (aRecipe != null) {
            String aHash = "Hash." + aRecipe.getPersistentHash();
            GTRecipe.RecipeAssemblyLine existing = sRecipeCacheByOutput.put(new GTItemStack(aRecipe.mOutput), aRecipe);
            if (existing != null) {
                throw new IllegalArgumentException("Duplicate assline recipe for " + aRecipe.mOutput);
            }
            existing = sRecipeCacheByRecipeHash.put(aHash, aRecipe);
            if (existing != null && !existing.equals(aRecipe)) {
                throw new IllegalArgumentException("Recipe hash collision for " + aRecipe + " and " + existing);
            }
        }
    }

    public static boolean isValidHash(String aHash) {
        if (aHash != null && aHash.length() > 0) {
            return !aHash.equals("Invalid.Recipe.Hash") && !aHash.equals("Hash.0");
        }
        return false;
    }

    public static boolean isItemDataStick(ItemStack aStack) {
        return GTUtility.isStackValid(aStack) && ItemList.Tool_DataStick.isStackEqual(aStack, false, true);
    }

    public static boolean doesDataStickHaveOutput(ItemStack aDataStick) {
        return AssemblyLineUtils.isItemDataStick(aDataStick) && aDataStick.func_77942_o() && aDataStick.func_77978_p().func_74764_b("output");
    }

    public static boolean doesDataStickNeedUpdate(ItemStack aDataStick) {
        String aStickHash;
        if (AssemblyLineUtils.isItemDataStick(aDataStick) && AssemblyLineUtils.doesDataStickHaveRecipeHash(aDataStick) && AssemblyLineUtils.isValidHash(aStickHash = AssemblyLineUtils.getHashFromDataStack(aDataStick)) && AssemblyLineUtils.doesDataStickHaveOutput(aDataStick)) {
            ItemStack aStickOutput = AssemblyLineUtils.getDataStickOutput(aDataStick);
            GTRecipe.RecipeAssemblyLine aIntendedRecipe = AssemblyLineUtils.findAssemblyLineRecipeByOutput(aStickOutput);
            return !aStickHash.equals(AssemblyLineUtils.generateRecipeHash(aIntendedRecipe));
        }
        return true;
    }

    public static boolean doesDataStickHaveRecipeHash(ItemStack aDataStick) {
        if (AssemblyLineUtils.isItemDataStick(aDataStick) && aDataStick.func_77942_o()) {
            NBTTagCompound aNBT = aDataStick.func_77978_p();
            return aNBT.func_74764_b("Data.Recipe.Hash") && !aNBT.func_74779_i("Data.Recipe.Hash").equals("Hash.0");
        }
        return false;
    }

    public static ItemStack getDataStickOutput(ItemStack aDataStick) {
        if (AssemblyLineUtils.doesDataStickHaveOutput(aDataStick)) {
            return GTUtility.loadItem(aDataStick.func_77978_p(), "output");
        }
        return null;
    }

    public static String getHashFromDataStack(ItemStack aDataStick) {
        String hash;
        NBTTagCompound aNBT;
        if (AssemblyLineUtils.isItemDataStick(aDataStick) && aDataStick.func_77942_o() && (aNBT = aDataStick.func_77978_p()).func_150297_b("Data.Recipe.Hash", 8) && AssemblyLineUtils.isValidHash(hash = aNBT.func_74779_i("Data.Recipe.Hash"))) {
            return hash;
        }
        return "Invalid.Recipe.Hash";
    }

    public static boolean setRecipeHashOnDataStick(ItemStack aDataStick, String aRecipeHash) {
        if (AssemblyLineUtils.isItemDataStick(aDataStick) && aDataStick.func_77942_o()) {
            NBTTagCompound aNBT = aDataStick.func_77978_p();
            aNBT.func_74778_a("Data.Recipe.Hash", aRecipeHash);
            aDataStick.func_77982_d(aNBT);
            return true;
        }
        return false;
    }

    public static boolean setAssemblyLineRecipeOnDataStick(ItemStack aDataStick, GTRecipe.RecipeAssemblyLine aNewRecipe) {
        return AssemblyLineUtils.setAssemblyLineRecipeOnDataStick(aDataStick, aNewRecipe, true);
    }

    public static boolean setAssemblyLineRecipeOnDataStick(ItemStack aDataStick, GTRecipe.RecipeAssemblyLine aNewRecipe, boolean setUpdateTime) {
        if (AssemblyLineUtils.isItemDataStick(aDataStick) && aNewRecipe.mOutput != null) {
            int i;
            String s = aNewRecipe.mOutput.func_82833_r();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = AssemblyLineServer.lServerNames.get(aNewRecipe.mOutput.func_82833_r())) == null) {
                s = aNewRecipe.mOutput.func_82833_r();
            }
            String aHash = AssemblyLineUtils.generateRecipeHash(aNewRecipe);
            if (GTValues.D1) {
                GTRecipe.RecipeAssemblyLine aOldRecipe = AssemblyLineUtils.findAssemblyLineRecipeFromDataStick(aDataStick, true).recipe;
                GTMod.GT_FML_LOGGER.info("Updating data stick: " + aDataStick.func_82833_r() + " | Old Recipe Hash: " + AssemblyLineUtils.generateRecipeHash(aOldRecipe) + ", New Recipe Hash: " + aHash);
            }
            String author = "Assembling Line Recipe Generator";
            String displayName = null;
            if (aDataStick.func_77942_o()) {
                NBTTagCompound displayTag;
                NBTTagCompound tag = aDataStick.func_77978_p();
                if (tag.func_150297_b("author", 8)) {
                    author = tag.func_74779_i("author");
                }
                if (tag.func_150297_b("display", 10) && (displayTag = tag.func_74775_l("display")).func_150297_b("Name", 8)) {
                    displayName = displayTag.func_74779_i("Name");
                }
            }
            aDataStick.func_77982_d(new NBTTagCompound());
            if (displayName != null) {
                aDataStick.func_151001_c(displayName);
            }
            if (GTValues.D1) {
                GTUtility.ItemNBT.setBookTitle(aDataStick, s + " Construction Data (" + aHash + ")");
            } else {
                GTUtility.ItemNBT.setBookTitle(aDataStick, s + " Construction Data");
            }
            NBTTagCompound tNBT = aDataStick.func_77978_p();
            if (tNBT == null) {
                tNBT = new NBTTagCompound();
            }
            tNBT.func_74782_a("output", (NBTBase)aNewRecipe.mOutput.func_77955_b(new NBTTagCompound()));
            tNBT.func_74768_a("time", aNewRecipe.mDuration);
            tNBT.func_74768_a("eu", aNewRecipe.mEUt);
            tNBT.func_74778_a("author", author);
            NBTTagList tNBTList = new NBTTagList();
            tNBTList.func_74742_a((NBTBase)new NBTTagString("Construction plan for " + aNewRecipe.mOutput.field_77994_a + " " + s + ". Needed EU/t: " + aNewRecipe.mEUt + " Production time: " + aNewRecipe.mDuration / 20));
            for (i = 0; i < aNewRecipe.mInputs.length; ++i) {
                boolean hasSetOreDictAlt = false;
                if (aNewRecipe.mOreDictAlt[i] != null && aNewRecipe.mOreDictAlt[i].length > 0) {
                    tNBT.func_74768_a("a" + i, aNewRecipe.mOreDictAlt[i].length);
                    int count = 0;
                    StringBuilder tBuilder = new StringBuilder("Input Bus " + (i + 1) + ": ");
                    for (int j = 0; j < aNewRecipe.mOreDictAlt[i].length; ++j) {
                        ItemStack tStack = aNewRecipe.mOreDictAlt[i][j];
                        if (tStack == null) continue;
                        tNBT.func_74782_a("a" + i + ":" + j, (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                        s = tStack.func_82833_r();
                        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = AssemblyLineServer.lServerNames.get(tStack.func_82833_r())) == null) {
                            s = tStack.func_82833_r();
                        }
                        tBuilder.append(count == 0 ? "" : "\nOr ").append(tStack.field_77994_a).append(" ").append(s);
                        ++count;
                    }
                    if (count > 0) {
                        tNBTList.func_74742_a((NBTBase)new NBTTagString(tBuilder.toString()));
                        hasSetOreDictAlt = true;
                    }
                }
                if (aNewRecipe.mInputs[i] == null) continue;
                tNBT.func_74782_a("" + i, (NBTBase)aNewRecipe.mInputs[i].func_77955_b(new NBTTagCompound()));
                if (hasSetOreDictAlt) continue;
                s = aNewRecipe.mInputs[i].func_82833_r();
                if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = AssemblyLineServer.lServerNames.get(aNewRecipe.mInputs[i].func_82833_r())) == null) {
                    s = aNewRecipe.mInputs[i].func_82833_r();
                }
                tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Bus " + (i + 1) + ": " + aNewRecipe.mInputs[i].field_77994_a + " " + s));
            }
            for (i = 0; i < aNewRecipe.mFluidInputs.length; ++i) {
                if (aNewRecipe.mFluidInputs[i] == null) continue;
                tNBT.func_74782_a("f" + i, (NBTBase)aNewRecipe.mFluidInputs[i].writeToNBT(new NBTTagCompound()));
                s = aNewRecipe.mFluidInputs[i].getLocalizedName();
                if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = AssemblyLineServer.lServerNames.get(aNewRecipe.mFluidInputs[i].getLocalizedName())) == null) {
                    s = aNewRecipe.mFluidInputs[i].getLocalizedName();
                }
                tNBTList.func_74742_a((NBTBase)new NBTTagString("Input Hatch " + (i + 1) + ": " + aNewRecipe.mFluidInputs[i].amount + "L " + s));
            }
            tNBT.func_74782_a("pages", (NBTBase)tNBTList);
            if (setUpdateTime) {
                tNBT.func_74772_a("lastUpdate", System.currentTimeMillis());
            }
            aDataStick.func_77982_d(tNBT);
            AssemblyLineUtils.setRecipeHashOnDataStick(aDataStick, aHash);
            return true;
        }
        return false;
    }

    public static class LookupResult {
        private final GTRecipe.RecipeAssemblyLine recipe;
        private final LookupResultType type;

        LookupResult(GTRecipe.RecipeAssemblyLine recipe, LookupResultType type) {
            this.recipe = recipe;
            this.type = type;
        }

        public GTRecipe.RecipeAssemblyLine getRecipe() {
            return this.recipe;
        }

        public LookupResultType getType() {
            return this.type;
        }
    }

    public static enum LookupResultType {
        INVALID_STICK(true),
        VALID_STACK_BUT_INVALID_RECIPE(true),
        VALID_STACK_AND_VALID_RECIPE(false),
        VALID_STACK_AND_VALID_HASH(false);

        private final boolean recipeNull;
        private LookupResult singletonResult;

        private LookupResultType(boolean recipeNull) {
            this.recipeNull = recipeNull;
        }

        public LookupResult getResult() {
            if (!this.recipeNull) {
                throw new IllegalArgumentException("This result type require a nonnull recipe");
            }
            if (this.singletonResult == null) {
                this.singletonResult = new LookupResult(null, this);
            }
            return this.singletonResult;
        }

        public LookupResult getResult(GTRecipe.RecipeAssemblyLine recipe) {
            if (recipe == null != this.recipeNull) {
                throw new IllegalArgumentException("This result type does not allow given input");
            }
            return new LookupResult(recipe, this);
        }
    }
}

