/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.api.util.GTMusicSystem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.world.IBlockAccess;

public class GTPacketMusicSystemData
extends GTPacket {
    ByteBuf storedData;

    public GTPacketMusicSystemData() {
    }

    public GTPacketMusicSystemData(ByteBuf data) {
        this.storedData = data;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.MUSIC_SYSTEM_DATA.id;
    }

    @Override
    public void encode(ByteBuf aOut) {
        if (this.storedData == null) {
            return;
        }
        this.storedData.markReaderIndex();
        int len = this.storedData.readableBytes();
        aOut.writeInt(len);
        aOut.writeBytes(this.storedData);
        this.storedData.resetReaderIndex();
    }

    @Override
    public GTPacket decode(ByteArrayDataInput aData) {
        int len = aData.readInt();
        byte[] fullData = new byte[len];
        aData.readFully(fullData);
        return new GTPacketMusicSystemData(Unpooled.wrappedBuffer((byte[])fullData));
    }

    @Override
    public void process(IBlockAccess aWorld) {
        if (aWorld == null || this.storedData == null) {
            return;
        }
        this.storedData.markReaderIndex();
        GTMusicSystem.ClientSystem.loadUpdatedSources(this.storedData);
        this.storedData.resetReaderIndex();
    }
}

