/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractProcessingLogic<P extends AbstractProcessingLogic<P>> {
    protected IVoidable machine;
    protected Supplier<RecipeMap<?>> recipeMapSupplier;
    protected GTRecipe lastRecipe;
    protected RecipeMap<?> lastRecipeMap;
    protected ItemStack[] outputItems;
    protected FluidStack[] outputFluids;
    protected long calculatedEut;
    protected int duration;
    protected long availableVoltage;
    protected long availableAmperage;
    protected double overClockTimeReduction = 2.0;
    protected double overClockPowerIncrease = 4.0;
    protected boolean protectItems;
    protected boolean protectFluids;
    protected int maxParallel = 1;
    protected Supplier<Integer> maxParallelSupplier;
    protected int calculatedParallels = 0;
    protected int batchSize = 1;
    protected double euModifier = 1.0;
    protected double speedBoost = 1.0;
    protected boolean amperageOC = true;
    protected boolean isCleanroom;

    public P setOutputItems(ItemStack ... itemOutputs) {
        this.outputItems = itemOutputs;
        return this.getThis();
    }

    public P setOutputFluids(FluidStack ... fluidOutputs) {
        this.outputFluids = fluidOutputs;
        return this.getThis();
    }

    public P setIsCleanroom(boolean isCleanroom) {
        this.isCleanroom = isCleanroom;
        return this.getThis();
    }

    public P setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
        return this.getThis();
    }

    public P setMaxParallelSupplier(Supplier<Integer> supplier) {
        this.maxParallelSupplier = supplier;
        return this.getThis();
    }

    public P setBatchSize(int size) {
        this.batchSize = size;
        return this.getThis();
    }

    public P setRecipeMap(RecipeMap<?> recipeMap) {
        return this.setRecipeMapSupplier(() -> recipeMap);
    }

    public P setRecipeMapSupplier(Supplier<RecipeMap<?>> supplier) {
        this.recipeMapSupplier = supplier;
        return this.getThis();
    }

    public P setEuModifier(double modifier) {
        this.euModifier = modifier;
        return this.getThis();
    }

    public P setSpeedBonus(double speedModifier) {
        this.speedBoost = speedModifier;
        return this.getThis();
    }

    public P setMachine(IVoidable machine) {
        this.machine = machine;
        return this.getThis();
    }

    public P setDuration(int duration) {
        this.duration = duration;
        return this.getThis();
    }

    public P setCalculatedEut(long calculatedEut) {
        this.calculatedEut = calculatedEut;
        return this.getThis();
    }

    public P setAvailableVoltage(long voltage) {
        this.availableVoltage = voltage;
        return this.getThis();
    }

    public P setAvailableAmperage(long amperage) {
        this.availableAmperage = amperage;
        return this.getThis();
    }

    public P setVoidProtection(boolean protectItems, boolean protectFluids) {
        this.protectItems = protectItems;
        this.protectFluids = protectFluids;
        return this.getThis();
    }

    public P setOverclock(double timeReduction, double powerIncrease) {
        this.overClockTimeReduction = timeReduction;
        this.overClockPowerIncrease = powerIncrease;
        return this.getThis();
    }

    public P enablePerfectOverclock() {
        return this.setOverclock(4.0, 4.0);
    }

    public P setAmperageOC(boolean amperageOC) {
        this.amperageOC = amperageOC;
        return this.getThis();
    }

    public P clear() {
        this.calculatedEut = 0L;
        this.duration = 0;
        this.calculatedParallels = 0;
        return this.getThis();
    }

    @Nonnull
    public abstract CheckRecipeResult process();

    protected RecipeMap<?> preProcess() {
        RecipeMap<?> recipeMap = this.recipeMapSupplier == null ? null : this.recipeMapSupplier.get();
        if (this.lastRecipeMap != recipeMap) {
            this.lastRecipe = null;
            this.lastRecipeMap = recipeMap;
        }
        if (this.maxParallelSupplier != null) {
            this.maxParallel = this.maxParallelSupplier.get();
        }
        return recipeMap;
    }

    @Nonnull
    protected CheckRecipeResult applyRecipe(@Nonnull GTRecipe recipe, @Nonnull ParallelHelper helper, @Nonnull OverclockCalculator calculator, @Nonnull CheckRecipeResult result) {
        this.lastRecipe = recipe.mCanBeBuffered ? recipe : null;
        this.calculatedParallels = helper.getCurrentParallel();
        if (calculator.getConsumption() == Long.MAX_VALUE) {
            return CheckRecipeResultRegistry.POWER_OVERFLOW;
        }
        if (calculator.getDuration() == Integer.MAX_VALUE) {
            return CheckRecipeResultRegistry.DURATION_OVERFLOW;
        }
        this.calculatedEut = calculator.getConsumption();
        double finalDuration = this.calculateDuration(recipe, helper, calculator);
        if (finalDuration >= 2.147483647E9) {
            return CheckRecipeResultRegistry.DURATION_OVERFLOW;
        }
        this.duration = (int)finalDuration;
        CheckRecipeResult hookResult = this.onRecipeStart(recipe);
        if (!hookResult.wasSuccessful()) {
            return hookResult;
        }
        this.outputItems = helper.getItemOutputs();
        this.outputFluids = helper.getFluidOutputs();
        return result;
    }

    protected double calculateDuration(@Nonnull GTRecipe recipe, @Nonnull ParallelHelper helper, @Nonnull OverclockCalculator calculator) {
        return (double)calculator.getDuration() * helper.getDurationMultiplierDouble();
    }

    @Nonnull
    protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Nonnull
    protected CheckRecipeResult onRecipeStart(@Nonnull GTRecipe recipe) {
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Nonnull
    protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
        return new OverclockCalculator().setRecipeEUt(recipe.mEUt).setAmperage(this.availableAmperage).setEUt(this.availableVoltage).setDuration(recipe.mDuration).setSpeedBoost(this.speedBoost).setEUtDiscount(this.euModifier).setAmperageOC(this.amperageOC).setDurationDecreasePerOC(this.overClockTimeReduction).setEUtIncreasePerOC(this.overClockPowerIncrease);
    }

    public ItemStack[] getOutputItems() {
        return this.outputItems;
    }

    public FluidStack[] getOutputFluids() {
        return this.outputFluids;
    }

    public int getDuration() {
        return this.duration;
    }

    public long getCalculatedEut() {
        return this.calculatedEut;
    }

    public int getCurrentParallels() {
        return this.calculatedParallels;
    }

    @Nonnull
    public P getThis() {
        return (P)this;
    }
}

