/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.client.render;

import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import cpw.mods.fml.client.registry.ClientRegistry;
import goodgenerator.blocks.tileEntity.render.TileAntimatter;
import gregtech.api.enums.Mods;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class AntimatterRenderer
extends TileEntitySpecialRenderer {
    private static ShaderProgram antimatterProgram;
    private static IModelCustom antimatterModel;
    private static IModelCustom containerModel;
    private static IModelCustom ringModel;
    private static final float modelNormalize = 0.5f;
    private int uColorSpike = -1;
    private int uColorCore = -1;
    private int uScale = -1;
    private int uScaleSnapshot = -1;
    private int uTime = -1;
    private int uTimeSnapshot = -1;
    private int uOpacity = -1;
    private static final int particleCount = 32;
    private static ShaderProgram protomatterProgram;
    private int aBeamVertexID;
    private int uProtomatterTime = -1;
    private int uProtomatterScale = -1;
    private int uProtomatterColor = -1;
    private int uProtomatterSpiralRadius = -1;
    private static final int beamVertexCount = 1152;
    private boolean initialized = false;
    private static ShaderProgram glowProgram;
    private int uGlowColor = -1;
    private static final float[] promomatterVerticies;

    public AntimatterRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileAntimatter.class, (TileEntitySpecialRenderer)this);
    }

    public void loadModels() {
        ResourceLocation antimatterLocation = new ResourceLocation(Mods.GoodGenerator.resourceDomain, "models/Antimatter.obj");
        antimatterModel = new WavefrontObject(antimatterLocation);
        ResourceLocation location = new ResourceLocation(Mods.GoodGenerator.resourceDomain, "models/SmoothSphere.obj");
        containerModel = new WavefrontObject(location);
        ResourceLocation ringLocation = new ResourceLocation(Mods.GoodGenerator.resourceDomain, "models/GlowRing.obj");
        ringModel = new WavefrontObject(ringLocation);
    }

    private void init() {
        int uCubeCount;
        int uProtomatterVertices;
        antimatterProgram = new ShaderProgram(Mods.GoodGenerator.resourceDomain, "shaders/antimatter.vert.glsl", "shaders/antimatter.frag.glsl");
        antimatterProgram.use();
        try {
            this.uScale = antimatterProgram.getUniformLocation("u_Scale");
            this.uScaleSnapshot = antimatterProgram.getUniformLocation("u_ScaleSnapshot");
            this.uTime = antimatterProgram.getUniformLocation("u_Time");
            this.uTimeSnapshot = antimatterProgram.getUniformLocation("u_TimeSnapshot");
            this.uOpacity = antimatterProgram.getUniformLocation("u_Opacity");
            this.uColorCore = antimatterProgram.getUniformLocation("u_ColorCore");
            this.uColorSpike = antimatterProgram.getUniformLocation("u_ColorSpike");
        }
        catch (NullPointerException e) {
            System.out.println(e.getMessage());
            return;
        }
        GL20.glUniform3f((int)this.uColorCore, (float)0.435f, (float)0.718f, (float)1.0f);
        GL20.glUniform3f((int)this.uColorSpike, (float)0.153f, (float)0.435f, (float)1.0f);
        GL20.glUniform1f((int)this.uOpacity, (float)1.0f);
        ShaderProgram.clear();
        this.loadModels();
        protomatterProgram = new ShaderProgram(Mods.GoodGenerator.resourceDomain, "shaders/protomatter.vert.glsl", "shaders/protomatter.frag.glsl");
        try {
            uProtomatterVertices = protomatterProgram.getUniformLocation("u_Vertices");
            uCubeCount = protomatterProgram.getUniformLocation("u_CubeCount");
            this.uProtomatterTime = protomatterProgram.getUniformLocation("u_Time");
            this.uProtomatterScale = protomatterProgram.getUniformLocation("u_Scale");
            this.uProtomatterColor = protomatterProgram.getUniformLocation("u_Color");
            this.uProtomatterSpiralRadius = protomatterProgram.getUniformLocation("u_SpiralRadius");
        }
        catch (NullPointerException e) {
            return;
        }
        protomatterProgram.use();
        FloatBuffer bufferBeamVertexID = BufferUtils.createFloatBuffer((int)3456);
        for (int i = 0; i < 1152; ++i) {
            bufferBeamVertexID.put(i * 3, i);
        }
        this.aBeamVertexID = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.aBeamVertexID);
        GL15.glBufferData((int)34962, (FloatBuffer)bufferBeamVertexID, (int)35044);
        FloatBuffer bufferBeamVertex = BufferUtils.createFloatBuffer((int)promomatterVerticies.length);
        bufferBeamVertex.put(promomatterVerticies).flip();
        GL20.glUniform3((int)uProtomatterVertices, (FloatBuffer)bufferBeamVertex);
        GL20.glUniform1f((int)uCubeCount, (float)32.0f);
        ShaderProgram.clear();
        GL15.glBindBuffer((int)34962, (int)0);
        try {
            glowProgram = new ShaderProgram(Mods.GoodGenerator.resourceDomain, "shaders/glow.vert.glsl", "shaders/glow.frag.glsl");
            this.uGlowColor = glowProgram.getUniformLocation("u_Color");
            glowProgram.use();
            GL20.glUniform3f((int)this.uGlowColor, (float)0.0f, (float)1.0f, (float)1.0f);
        }
        catch (NullPointerException e) {
            return;
        }
        ShaderProgram.clear();
        this.initialized = true;
    }

    private void renderAntimatter(TileAntimatter tile, double x, double y, double z, float timer) {
        antimatterProgram.use();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        float angle = timer % 72000.0f * tile.rotationSpeedMultiplier;
        GL11.glRotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(angle / 8.0f), (double)1.0, (double)0.0, (double)0.0);
        float snapshotSize = tile.coreScaleSnapshot;
        float coreSizeSnapshot = Math.min(snapshotSize *= 0.5f, 7.0f / (1.0f + tile.spikeFactor));
        float targetSize = tile.coreScale;
        float coreSize = Math.min(targetSize *= 0.5f, 7.0f / (1.0f + tile.spikeFactor));
        float realTime = timer / 20.0f;
        float snapTime = tile.timeSnapshot / 20.0f;
        GL20.glUniform1f((int)this.uTime, (float)realTime);
        GL20.glUniform1f((int)this.uTimeSnapshot, (float)snapTime);
        GL20.glUniform1f((int)this.uScale, (float)coreSize);
        GL20.glUniform1f((int)this.uScaleSnapshot, (float)coreSizeSnapshot);
        GL11.glDisable((int)2884);
        GL15.glBindBuffer((int)34962, (int)0);
        antimatterModel.renderAll();
        ShaderProgram.clear();
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)-7.0f, (float)-7.0f, (float)-7.0f);
        containerModel.renderAll();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderProtomatterBeam(TileAntimatter tile, double x, double y, double z, float timer) {
        protomatterProgram.use();
        GL11.glPushMatrix();
        GL11.glEnableClientState((int)32884);
        GL20.glEnableVertexAttribArray((int)this.aBeamVertexID);
        GL20.glUniform1f((int)this.uProtomatterTime, (float)timer);
        GL20.glUniform1f((int)this.uProtomatterScale, (float)tile.protomatterScale);
        GL20.glUniform3f((int)this.uProtomatterColor, (float)0.2f, (float)0.2f, (float)0.2f);
        GL20.glUniform1f((int)this.uProtomatterSpiralRadius, (float)tile.getSpiralRadius(0.5f));
        GL15.glBindBuffer((int)34962, (int)this.aBeamVertexID);
        GL20.glVertexAttribPointer((int)0, (int)1, (int)5126, (boolean)false, (int)12, (long)8L);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)tile.rotationAngle, (float)tile.rotX, (float)tile.rotY, (float)tile.rotZ);
        GL11.glDrawArrays((int)4, (int)0, (int)1152);
        GL11.glDisableClientState((int)32884);
        GL20.glDisableVertexAttribArray((int)this.aBeamVertexID);
        GL15.glBindBuffer((int)34962, (int)0);
        ShaderProgram.clear();
        GL11.glPopMatrix();
    }

    public void renderRing(TileAntimatter tile, double x, double y, double z, float timer) {
        GL11.glPushMatrix();
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)x, (double)y, (double)z);
        glowProgram.use();
        GL11.glRotatef((float)tile.rotationAngle, (float)tile.rotX, (float)tile.rotY, (float)tile.rotZ);
        ringModel.renderAll();
        ShaderProgram.clear();
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (!(tile instanceof TileAntimatter)) {
            return;
        }
        TileAntimatter Antimatter = (TileAntimatter)tile;
        if (!Antimatter.shouldRender) {
            return;
        }
        if (!this.initialized) {
            this.init();
            if (!this.initialized) {
                return;
            }
        }
        float tx = (float)x + 0.5f;
        float ty = (float)y + 0.5f;
        float tz = (float)z + 0.5f;
        float timer = (float)tile.func_145831_w().func_72912_H().func_82573_f() + timeSinceLastTick;
        this.renderAntimatter(Antimatter, tx, ty, tz, timer);
        if (!Antimatter.protomatterRender) {
            return;
        }
        this.renderProtomatterBeam(Antimatter, tx, ty, tz, timer);
        this.renderRing(Antimatter, tx, ty, tz, timer);
    }

    static {
        promomatterVerticies = new float[]{-0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f};
    }
}

