/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.werkstoff_loaders.recipe;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MoltenCellLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (!werkstoff.hasItemType(OrePrefixes.cellMolten)) {
            return;
        }
        if (!werkstoff.hasItemType(OrePrefixes.ingot)) {
            if (!werkstoff.hasItemType(OrePrefixes.dust)) {
                return;
            }
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dust)).fluidOutputs(werkstoff.getMolten(144)).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustSmall)).fluidOutputs(werkstoff.getMolten(36)).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustTiny)).fluidOutputs(werkstoff.getMolten(16)).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
        } else {
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingot)).fluidOutputs(werkstoff.getMolten(144)).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.nugget)).fluidOutputs(werkstoff.getMolten(16)).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ingot.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.ingot)).fluidInputs(werkstoff.getMolten(144)).duration((int)werkstoff.getStats().getMass()).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Nugget.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.nugget)).fluidInputs(werkstoff.getMolten(16)).duration((int)((double)werkstoff.getStats().getMass() / 9.0)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
            if (!werkstoff.hasItemType(OrePrefixes.plate)) {
                return;
            }
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.stickLong)).fluidOutputs(werkstoff.getMolten(144)).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.plate)).fluidOutputs(werkstoff.getMolten(144)).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.stick)).fluidOutputs(werkstoff.getMolten(72)).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
        }
        if (werkstoff.getGenerationFeatures().hasMetalCraftingSolidifierRecipes()) {
            if (!werkstoff.hasItemType(OrePrefixes.plate)) {
                return;
            }
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rod_Long.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.stickLong)).fluidInputs(werkstoff.getMolten(144)).duration((int)Math.max(werkstoff.getStats().getMass(), 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rod.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.stick)).fluidInputs(werkstoff.getMolten(72)).duration((int)Math.max(werkstoff.getStats().getMass() / 2L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Plate.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.plate)).fluidInputs(werkstoff.getMolten(144)).duration((int)Math.max(werkstoff.getStats().getMass(), 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
        }
        if (werkstoff.getGenerationFeatures().hasMetaSolidifierRecipes()) {
            if (!werkstoff.hasItemType(OrePrefixes.screw)) {
                return;
            }
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Screw.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.screw)).fluidInputs(werkstoff.getMolten(18)).duration((int)Math.max(werkstoff.getStats().getMass() / 8L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Gear.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.gearGt)).fluidInputs(werkstoff.getMolten(576)).duration((int)Math.max(werkstoff.getStats().getMass() / 4L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Gear_Small.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.gearGtSmall)).fluidInputs(werkstoff.getMolten(144)).duration((int)Math.max(werkstoff.getStats().getMass(), 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Bolt.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.bolt)).fluidInputs(werkstoff.getMolten(18)).duration((int)Math.max(werkstoff.getStats().getMass() / 8L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ring.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.ring)).fluidInputs(werkstoff.getMolten(36)).duration((int)Math.max(werkstoff.getStats().getMass() / 4L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rotor.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.rotor)).fluidInputs(werkstoff.getMolten(612)).duration((int)Math.max((double)werkstoff.getStats().getMass() * 4.25, 1.0)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
        }
        if (werkstoff.getGenerationFeatures().hasMultipleMetalSolidifierRecipes() && !werkstoff.hasItemType(OrePrefixes.plateDouble)) {
            return;
        }
        FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(OrePrefixes.cellMolten), Materials.Empty.getCells(1));
        FluidContainerRegistry.registerFluidContainer((FluidStack)werkstoff.getMolten(144), (ItemStack)werkstoff.get(OrePrefixes.cellMolten), (ItemStack)Materials.Empty.getCells(1));
        GTUtility.addFluidContainerData(data);
        if (!Mods.Forestry.isModLoaded()) {
            return;
        }
        FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(OrePrefixes.capsuleMolten), GTModHandler.getModItem(Mods.Forestry.ID, "refractoryEmpty", 1L));
        FluidContainerRegistry.registerFluidContainer((FluidStack)werkstoff.getMolten(144), (ItemStack)werkstoff.get(OrePrefixes.capsuleMolten), (ItemStack)GTModHandler.getModItem(Mods.Forestry.ID, "refractoryEmpty", 1L));
        GTUtility.addFluidContainerData(emptyData);
    }
}

