/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.loaders;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.system.material.BWNonMetaMaterialItems;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.util.BWRecipes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;

public class RadioHatchMaterialLoader {
    public static void run() {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            if (werkstoff == null || !werkstoff.getStats().isRadioactive()) continue;
            int level = (int)werkstoff.getStats().getProtons();
            if (werkstoff.hasItemType(OrePrefixes.stick)) {
                GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.stick)).duration(1).eut(level).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(level)).noOptimize().addTo(BartWorksRecipeMaps.radioHatchRecipes);
            }
            if (!werkstoff.hasItemType(OrePrefixes.stickLong)) continue;
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.stickLong)).duration(2).eut(level).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(level)).noOptimize().addTo(BartWorksRecipeMaps.radioHatchRecipes);
        }
        for (Materials materials : Materials.getAll()) {
            boolean validProton;
            if (materials == null || materials.mElement == null || !(validProton = materials.getProtons() >= 83L && !materials.equals(Materials.Tritanium) && !materials.equals(Materials.Naquadah))) continue;
            int level = (int)materials.getProtons();
            if (GTOreDictUnificator.get(OrePrefixes.stick, materials, 1L) != null) {
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, materials, 1L)).duration(1).eut(level).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(level)).noOptimize().addTo(BartWorksRecipeMaps.radioHatchRecipes);
            }
            if (GTOreDictUnificator.get(OrePrefixes.stickLong, materials, 1L) == null) continue;
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stickLong, materials, 1L)).duration(2).eut(level).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(level)).noOptimize().addTo(BartWorksRecipeMaps.radioHatchRecipes);
        }
        Materials[] spacialMaterial = new Materials[]{Materials.Naquadah, Materials.NaquadahEnriched, Materials.Naquadria};
        int[] nArray = new int[]{130, 140, 150};
        for (int i = 0; i < spacialMaterial.length; ++i) {
            if (GTOreDictUnificator.get(OrePrefixes.stick, spacialMaterial[i], 1L) != null) {
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, spacialMaterial[i], 1L)).duration(1).eut(nArray[i]).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(nArray[i])).noOptimize().addTo(BartWorksRecipeMaps.radioHatchRecipes);
            }
            if (GTOreDictUnificator.get(OrePrefixes.stickLong, spacialMaterial[i], 1L) == null) continue;
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stickLong, spacialMaterial[i], 1L)).duration(2).eut(nArray[i]).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(nArray[i])).noOptimize().addTo(BartWorksRecipeMaps.radioHatchRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(ItemList.ThoriumCell_1.get(1L, new Object[0])).duration(3).eut((int)Materials.Thorium.getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Thorium.getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.ThoriumCell_2.get(1L, new Object[0])).duration(6).eut((int)Materials.Thorium.getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Thorium.getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.ThoriumCell_4.get(1L, new Object[0])).duration(12).eut((int)Materials.Thorium.getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Thorium.getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.NaquadahCell_1.get(1L, new Object[0])).duration(3).eut(140).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(140)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.NaquadahCell_2.get(1L, new Object[0])).duration(6).eut(140).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(140)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.NaquadahCell_4.get(1L, new Object[0])).duration(12).eut(140).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(140)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Moxcell_1.get(1L, new Object[0])).duration(3).eut((int)Materials.Plutonium.getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Plutonium.getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Moxcell_2.get(1L, new Object[0])).duration(6).eut((int)Materials.Plutonium.getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Plutonium.getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Moxcell_4.get(1L, new Object[0])).duration(12).eut((int)Materials.Plutonium.getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Plutonium.getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Uraniumcell_1.get(1L, new Object[0])).duration(3).eut((int)Materials.Uranium.getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Uranium.getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Uraniumcell_2.get(1L, new Object[0])).duration(6).eut((int)Materials.Uranium.getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Uranium.getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Uraniumcell_4.get(1L, new Object[0])).duration(12).eut((int)Materials.Uranium.getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Uranium.getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.TiberiumCell_1.get(1L, new Object[0])).duration(3).eut((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.TiberiumCell_2.get(1L, new Object[0])).duration(6).eut((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.TiberiumCell_4.get(1L, new Object[0])).duration(12).eut((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons()).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons())).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.TheCoreCell.get(1L, new Object[0])).duration(96).eut(140).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(140)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Depleted_Thorium_1.get(1L, new Object[0])).duration(3).eut((int)Materials.Thorium.getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Thorium.getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Depleted_Thorium_2.get(1L, new Object[0])).duration(6).eut((int)Materials.Thorium.getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Thorium.getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Depleted_Thorium_4.get(1L, new Object[0])).duration(12).eut((int)Materials.Thorium.getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Thorium.getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Depleted_Naquadah_1.get(1L, new Object[0])).duration(3).eut(14).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(14)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Depleted_Naquadah_2.get(1L, new Object[0])).duration(6).eut(14).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(14)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Depleted_Naquadah_4.get(1L, new Object[0])).duration(12).eut(14).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(14)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorMOXSimpledepleted", 1L)).duration(3).eut((int)Materials.Plutonium.getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Plutonium.getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorMOXDualdepleted", 1L)).duration(6).eut((int)Materials.Plutonium.getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Plutonium.getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorMOXQuaddepleted", 1L)).duration(12).eut((int)Materials.Plutonium.getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Plutonium.getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorUraniumSimpledepleted", 1L)).duration(3).eut((int)Materials.Uranium.getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Uranium.getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorUraniumDualdepleted", 1L)).duration(6).eut((int)Materials.Uranium.getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Uranium.getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorUraniumQuaddepleted", 1L)).duration(12).eut((int)Materials.Uranium.getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)Materials.Uranium.getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.Depleted_Tiberium_1.get(1L, new Object[0])).duration(3).eut((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.Depleted_Tiberium_2.get(1L, new Object[0])).duration(6).eut((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.Depleted_Tiberium_4.get(1L, new Object[0])).duration(12).eut((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons() / 10).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks((int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons() / 10)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.Depleted_TheCoreCell.get(1L, new Object[0])).duration(96).eut(13).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(13)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.MNqCell_1.get(1L, new Object[0])).duration(3).eut(150).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(150)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.MNqCell_2.get(1L, new Object[0])).duration(6).eut(150).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(150)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.MNqCell_4.get(1L, new Object[0])).duration(12).eut(150).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(150)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Depleted_MNq_1.get(1L, new Object[0])).duration(3).eut(15).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(15)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Depleted_MNq_2.get(1L, new Object[0])).duration(6).eut(15).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(15)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Depleted_MNq_4.get(1L, new Object[0])).duration(12).eut(15).metadata(GTRecipeConstants.DECAY_TICKS, (int)BWRecipes.calcDecayTicks(15)).addTo(BartWorksRecipeMaps.radioHatchRecipes);
    }
}

