/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.loaders;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.common.loaders.BioCultureLoader;
import bartworks.common.loaders.BioItemList;
import bartworks.common.loaders.FluidLoader;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BioRecipeLoader {
    public static void run() {
        BioRecipeLoader.registerWaterBasedBioLabIncubations();
        BioRecipeLoader.registerBacterialVatRecipes();
    }

    public static void registerWaterBasedBioLabIncubations() {
        FluidStack[] easyFluids;
        for (FluidStack fluidStack : easyFluids = new FluidStack[]{Materials.Water.getFluid(1000L), FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}) {
            GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), new ItemStack(Items.field_151078_bh)).itemOutputs(BioItemList.getPetriDish(BioCultureLoader.rottenFleshBacteria)).outputChances(3300).fluidInputs(fluidStack).duration(500).eut(TierEU.RECIPE_HV).addTo(BartWorksRecipeMaps.bioLabRecipes);
            GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), new ItemStack(Items.field_151071_bq)).itemOutputs(BioItemList.getPetriDish(BioCultureLoader.eColi)).outputChances(4500).fluidInputs(fluidStack).duration(500).eut(TierEU.RECIPE_HV).addTo(BartWorksRecipeMaps.bioLabRecipes);
            GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), ItemList.Food_Dough.get(1L, new Object[0])).itemOutputs(BioItemList.getPetriDish(BioCultureLoader.CommonYeast)).outputChances(7500).fluidInputs(fluidStack).duration(500).eut(TierEU.RECIPE_HV).addTo(BartWorksRecipeMaps.bioLabRecipes);
            GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), ItemList.Food_Dough_Sugar.get(1L, new Object[0])).itemOutputs(BioItemList.getPetriDish(BioCultureLoader.WhineYeast)).outputChances(2500).fluidInputs(fluidStack).duration(500).eut(TierEU.RECIPE_HV).addTo(BartWorksRecipeMaps.bioLabRecipes);
            GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), ItemList.Bottle_Wine.get(1L, new Object[0])).itemOutputs(BioItemList.getPetriDish(BioCultureLoader.WhineYeast)).outputChances(3300).fluidInputs(fluidStack).duration(500).eut(TierEU.RECIPE_HV).addTo(BartWorksRecipeMaps.bioLabRecipes);
            GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), ItemList.Bottle_Beer.get(1L, new Object[0])).itemOutputs(BioItemList.getPetriDish(BioCultureLoader.BeerYeast)).outputChances(2500).fluidInputs(fluidStack).duration(500).eut(TierEU.RECIPE_HV).addTo(BartWorksRecipeMaps.bioLabRecipes);
            GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), ItemList.Bottle_Dark_Beer.get(1L, new Object[0])).itemOutputs(BioItemList.getPetriDish(BioCultureLoader.BeerYeast)).outputChances(3300).fluidInputs(fluidStack).duration(500).eut(TierEU.RECIPE_HV).addTo(BartWorksRecipeMaps.bioLabRecipes);
            GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), new ItemStack(Blocks.field_150346_d)).itemOutputs(BioItemList.getPetriDish(BioCultureLoader.anaerobicOil)).outputChances(100).fluidInputs(fluidStack).duration(1500).eut(TierEU.RECIPE_EV).addTo(BartWorksRecipeMaps.bioLabRecipes);
        }
    }

    public static void registerWaterBasedBacterialVatRecipes() {
        FluidStack[] easyFluids;
        for (FluidStack fluidStack : easyFluids = new FluidStack[]{Materials.Water.getFluid(1000L), FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}) {
            if (Mods.CropsPlusPlus.isModLoaded()) {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(2), new ItemStack(Items.field_151102_aT, 64)).special(BioItemList.getPetriDish(BioCultureLoader.CommonYeast)).fluidInputs(new FluidStack(fluidStack, 100)).fluidOutputs(FluidRegistry.getFluidStack((String)"potion.ghp", (int)1)).duration(350).eut(TierEU.RECIPE_EV).noOptimize().addTo(BartWorksRecipeMaps.bacterialVatRecipes);
            }
            GTValues.RA.stdBuilder().itemInputs(ItemList.Crop_Drop_Grapes.get(16L, new Object[0])).special(BioItemList.getPetriDish(BioCultureLoader.WhineYeast)).fluidInputs(new FluidStack(fluidStack, 100)).fluidOutputs(FluidRegistry.getFluidStack((String)"potion.wine", (int)12)).duration(200).eut(TierEU.RECIPE_MV).noOptimize().addTo(BartWorksRecipeMaps.bacterialVatRecipes);
            GTValues.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151102_aT, 4), ItemList.IC2_Hops.get(16L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Wheat, 8L)).special(BioItemList.getPetriDish(BioCultureLoader.BeerYeast)).fluidInputs(new FluidStack(fluidStack, 100)).fluidOutputs(FluidRegistry.getFluidStack((String)"potion.beer", (int)5)).duration(600).eut(TierEU.RECIPE_LV).noOptimize().addTo(BartWorksRecipeMaps.bacterialVatRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.IC2_Hops.get(32L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Wheat, 16L)).special(BioItemList.getPetriDish(BioCultureLoader.BeerYeast)).fluidInputs(new FluidStack(fluidStack, 100)).fluidOutputs(FluidRegistry.getFluidStack((String)"potion.darkbeer", (int)10)).duration(600).eut(TierEU.RECIPE_LV).noOptimize().addTo(BartWorksRecipeMaps.bacterialVatRecipes);
        }
    }

    public static void registerBacterialVatRecipes() {
        BioRecipeLoader.registerWaterBasedBacterialVatRecipes();
        GTValues.RA.stdBuilder().special(BioItemList.getPetriDish(BioCultureLoader.WhineYeast)).fluidInputs(FluidRegistry.getFluidStack((String)"potion.grapejuice", (int)100)).fluidOutputs(FluidRegistry.getFluidStack((String)"potion.wine", (int)12)).duration(400).eut(TierEU.RECIPE_LV).noOptimize().addTo(BartWorksRecipeMaps.bacterialVatRecipes);
        GTValues.RA.stdBuilder().special(BioItemList.getPetriDish(BioCultureLoader.anaerobicOil)).fluidInputs(Materials.FermentedBiomass.getFluid(10000L)).fluidOutputs(new FluidStack(FluidLoader.fulvicAcid, 1000)).duration(2748).eut(TierEU.RECIPE_LV).noOptimize().addTo(BartWorksRecipeMaps.bacterialVatRecipes);
    }

    public static void runOnServerStarted() {
    }
}

