/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import openmods.calc.IExecutable;

public class Compilers<E, M> {
    private final Map<M, ICompiler<E>> compilers;

    public Compilers(Map<M, ICompiler<E>> compilers) {
        this.compilers = ImmutableMap.copyOf(compilers);
    }

    public IExecutable<E> compile(M type, String input) {
        ICompiler<E> compiler = this.compilers.get(type);
        Preconditions.checkArgument((compiler != null ? 1 : 0) != 0, (Object)("Unknown compiler: " + type));
        return compiler.compile(input);
    }

    public static interface ICompiler<E> {
        public IExecutable<E> compile(String var1);
    }
}

