/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import cpw.mods.fml.client.FMLClientHandler;
import jds.bibliocraft.BiblioEnums;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.PaintingUtil;
import jds.bibliocraft.models.ModelPaintingCanvas;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemCanvasRenderer
implements IItemRenderer {
    private ModelPaintingCanvas model;
    private EntityPainting.EnumArt[] vanillaArtList = EntityPainting.EnumArt.values();
    private BiblioEnums.EnumBiblioPaintings[] biblioArtList = BiblioEnums.EnumBiblioPaintings.values();
    private String artName = "blank";
    private Tessellator tess = Tessellator.field_78398_a;

    public ItemCanvasRenderer() {
        this.model = new ModelPaintingCanvas();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        NBTTagCompound tags = item.func_77978_p();
        switch (type) {
            case ENTITY: {
                this.renderItem(0.0f, 0.01f, -0.0f, true, tags);
                break;
            }
            case EQUIPPED: {
                this.renderItem(0.35f, 0.5f, 0.7f, false, tags);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderItem(-0.4f, 0.5f, -0.35f, false, tags);
                break;
            }
            case INVENTORY: {
                this.renderItem(-0.5f, -0.4f, -0.5f, false, tags);
                break;
            }
        }
    }

    private void renderItem(float i, float j, float k, boolean entity, NBTTagCompound canvas) {
        GL11.glPushMatrix();
        if (entity) {
            GL11.glScalef((float)0.64f, (float)0.64f, (float)0.64f);
        } else {
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.PLANKSBIRCH);
        GL11.glTranslatef((float)i, (float)j, (float)k);
        this.model.renderCanvas();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.PAINTINGCANVAS);
        if (canvas != null) {
            this.artName = canvas.func_74779_i("paintingTitle");
            switch (canvas.func_74762_e("paintingType")) {
                case 0: {
                    for (int x = 0; x < this.biblioArtList.length; ++x) {
                        if (!this.artName.contentEquals(this.biblioArtList[x].title)) continue;
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.biblioArtList[x].paintingTextures[0][0]);
                    }
                    break;
                }
                case 1: {
                    GL11.glDisable((int)2896);
                    FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.PAINTINGSHEET);
                    this.renderVanillaPainting(i, j, k);
                    GL11.glEnable((int)2896);
                    FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.PAINTINGCANVAS);
                    break;
                }
                case 2: {
                    if (PaintingUtil.customArtNames == null || PaintingUtil.customArtNames.length <= 0 || PaintingUtil.customArtResources == null) break;
                    for (int x = 0; x < PaintingUtil.customArtNames.length; ++x) {
                        if (!this.artName.contentEquals(PaintingUtil.customArtNames[x])) continue;
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(PaintingUtil.customArtResources[x]);
                    }
                    break;
                }
            }
        }
        this.model.renderPainting();
        GL11.glPopMatrix();
    }

    private void renderVanillaPainting(float i, float j, float k) {
        for (int x = 0; x < this.vanillaArtList.length; ++x) {
            if (!this.artName.contentEquals(this.vanillaArtList[x].field_75702_A)) continue;
            float x1 = (float)this.vanillaArtList[x].field_75699_D / 256.0f;
            float x2 = (float)(this.vanillaArtList[x].field_75699_D + this.vanillaArtList[x].field_75703_B) / 256.0f;
            float y1 = (float)this.vanillaArtList[x].field_75700_E / 256.0f;
            float y2 = (float)(this.vanillaArtList[x].field_75700_E + this.vanillaArtList[x].field_75704_C) / 256.0f;
            this.tess.func_78382_b();
            this.tess.func_78374_a(0.035, -0.4, -0.4, (double)x2, (double)y2);
            this.tess.func_78374_a(0.035, 0.4, -0.4, (double)x2, (double)y1);
            this.tess.func_78374_a(0.035, 0.4, 0.4, (double)x1, (double)y1);
            this.tess.func_78374_a(0.035, -0.4, 0.4, (double)x1, (double)y2);
            this.tess.func_78381_a();
        }
    }
}

