/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.dimension;

import galaxyspace.core.world.GSBiomeGenBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;

public abstract class ChunkProviderSpaceCraters
extends ChunkProviderGenerate {
    protected final Random field_73220_k;
    private final Gradient noiseGen1;
    private final Gradient noiseGen2;
    private final Gradient noiseGen3;
    private final Gradient noiseGen4;
    private final Gradient noiseGen5;
    private final Gradient noiseGen6;
    private final Gradient noiseGen7;
    protected final World field_73230_p;
    protected BiomeGenBase[] field_73231_z = this.getBiomesForGeneration();
    private final double TERRAIN_HEIGHT_MOD = this.getHeightModifier();
    private final double SMALL_FEATURE_HEIGHT_MOD = this.getSmallFeatureHeightModifier();
    private final double MOUNTAIN_HEIGHT_MOD = this.getMountainHeightModifier();
    private final double VALLEY_HEIGHT_MOD = this.getValleyHeightModifier();
    private final int CRATER_PROB = this.getCraterProbability();
    private final int MID_HEIGHT = this.getSeaLevel();
    protected static final int CHUNK_SIZE_X = 16;
    protected static final int CHUNK_SIZE_Z = 16;
    private List<MapGenBaseMeta> worldGenerators;

    public ChunkProviderSpaceCraters(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled);
        this.field_73230_p = par1World;
        this.field_73220_k = new Random(seed);
        this.noiseGen1 = new Gradient(this.field_73220_k.nextLong(), 4, 0.25f);
        this.noiseGen2 = new Gradient(this.field_73220_k.nextLong(), 4, 0.25f);
        this.noiseGen3 = new Gradient(this.field_73220_k.nextLong(), 4, 0.25f);
        this.noiseGen4 = new Gradient(this.field_73220_k.nextLong(), 2, 0.25f);
        this.noiseGen5 = new Gradient(this.field_73220_k.nextLong(), 1, 0.25f);
        this.noiseGen6 = new Gradient(this.field_73220_k.nextLong(), 1, 0.25f);
        this.noiseGen7 = new Gradient(this.field_73220_k.nextLong(), 1, 0.25f);
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray) {
        this.noiseGen1.setFrequency(0.015f);
        this.noiseGen2.setFrequency(0.01f);
        this.noiseGen3.setFrequency(0.01f);
        this.noiseGen4.setFrequency(0.01f);
        this.noiseGen5.setFrequency(0.01f);
        this.noiseGen6.setFrequency(0.001f);
        this.noiseGen7.setFrequency(0.005f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double baseHeight = (double)this.noiseGen1.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.TERRAIN_HEIGHT_MOD;
                double smallHillHeight = (double)this.noiseGen2.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.SMALL_FEATURE_HEIGHT_MOD;
                double mountainHeight = Math.abs(this.noiseGen3.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double valleyHeight = Math.abs(this.noiseGen4.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double featureFilter = (double)this.noiseGen5.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 4.0;
                double largeFilter = (double)this.noiseGen6.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 8.0;
                double smallFilter = (double)this.noiseGen7.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 8.0 - 0.5;
                mountainHeight = this.lerp(smallHillHeight, mountainHeight * this.MOUNTAIN_HEIGHT_MOD, this.fade(this.clamp(mountainHeight * 2.0, 0.0, 1.0)));
                valleyHeight = this.lerp(smallHillHeight, valleyHeight * this.VALLEY_HEIGHT_MOD - this.VALLEY_HEIGHT_MOD + 9.0, this.fade(this.clamp((valleyHeight + 2.0) * 4.0, 0.0, 1.0)));
                double yDev = this.lerp(valleyHeight, mountainHeight, this.fade(largeFilter));
                yDev = this.lerp(smallHillHeight, yDev, smallFilter);
                yDev = this.lerp(baseHeight, yDev, featureFilter);
                GSBiomeGenBase biome = (GSBiomeGenBase)this.field_73230_p.func_72807_a(x + chunkX * 16, z + chunkZ * 16);
                for (int y = 0; y < 256; ++y) {
                    if (!((double)y < (double)this.MID_HEIGHT + yDev)) continue;
                    if (this.enableBiomeGenBaseBlock()) {
                        idArray[this.getIndex((int)x, (int)y, (int)z)] = biome.stoneBlock;
                        metaArray[this.getIndex((int)x, (int)y, (int)z)] = biome.stoneMeta;
                        continue;
                    }
                    idArray[this.getIndex((int)x, (int)y, (int)z)] = this.getStoneBlock().getBlock();
                    metaArray[this.getIndex((int)x, (int)y, (int)z)] = this.getStoneBlock().getMetadata();
                }
            }
        }
    }

    protected double lerp(double d1, double d2, double t) {
        if (t < 0.0) {
            return d1;
        }
        if (t > 1.0) {
            return d2;
        }
        return d1 + (d2 - d1) * t;
    }

    protected double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    protected double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public void func_147422_a(int par1, int par2, Block[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        this.noiseGen4.setFrequency(0.0625f);
        for (int var7 = 0; var7 < 16; ++var7) {
            for (int var8 = 0; var8 < 16; ++var8) {
                GSBiomeGenBase biomegenbase = (GSBiomeGenBase)par4ArrayOfBiomeGenBase[var7 + var8 * 16];
                int var9 = (int)((double)this.noiseGen4.getNoise((float)(par1 * 16 + var7), (float)(par2 * 16 + var8)) / 3.0 + 3.0 + this.field_73220_k.nextDouble() * 0.25);
                int var10 = -1;
                Block var11 = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76752_A : this.getGrassBlock().getBlock();
                byte var14m = this.enableBiomeGenBaseBlock() ? biomegenbase.topMeta : this.getGrassBlock().getMetadata();
                Block var12 = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76753_B : this.getDirtBlock().getBlock();
                byte var15m = this.enableBiomeGenBaseBlock() ? biomegenbase.fillerMeta : this.getDirtBlock().getMetadata();
                for (int var13 = 255; var13 >= 0; --var13) {
                    int index = this.getIndex(var7, var13, var8);
                    if (var13 <= 0 + this.field_73220_k.nextInt(5)) {
                        arrayOfIDs[index] = Blocks.field_150357_h;
                        continue;
                    }
                    Block var14 = arrayOfIDs[index];
                    if (Blocks.field_150350_a == var14) {
                        var10 = -1;
                        continue;
                    }
                    if (var14 != this.getStoneBlock().getBlock()) continue;
                    arrayOfMeta[index] = this.getStoneBlock().getMetadata();
                    if (var10 == -1) {
                        if (var9 <= 0) {
                            var11 = Blocks.field_150350_a;
                            var14m = 0;
                            if (this.enableBiomeGenBaseBlock()) {
                                var12 = biomegenbase.stoneBlock;
                                var15m = biomegenbase.stoneMeta;
                            } else {
                                var12 = this.getStoneBlock().getBlock();
                                var15m = this.getStoneBlock().getMetadata();
                            }
                        } else if (var13 >= 36 && var13 <= 21) {
                            if (this.enableBiomeGenBaseBlock()) {
                                var11 = biomegenbase.field_76752_A;
                                var14m = biomegenbase.topMeta;
                                var11 = biomegenbase.field_76753_B;
                                var14m = biomegenbase.fillerMeta;
                            } else {
                                var11 = this.getGrassBlock().getBlock();
                                var14m = this.getGrassBlock().getMetadata();
                                var11 = this.getDirtBlock().getBlock();
                                var14m = this.getDirtBlock().getMetadata();
                            }
                        }
                        var10 = var9;
                        if (var13 >= 19) {
                            arrayOfIDs[index] = var11;
                            arrayOfMeta[index] = var14m;
                            continue;
                        }
                        arrayOfIDs[index] = var12;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var10 <= 0) continue;
                    --var10;
                    arrayOfIDs[index] = var12;
                    arrayOfMeta[index] = var15m;
                }
            }
        }
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.field_73220_k.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Block[] ids = new Block[65536];
        byte[] meta = new byte[65536];
        this.generateTerrain(par1, par2, ids, meta);
        this.createCraters(par1, par2, ids, meta);
        this.field_73231_z = this.field_73230_p.func_72959_q().func_76933_b(this.field_73231_z, par1 * 16, par2 * 16, 16, 16);
        this.func_147422_a(par1, par2, ids, meta, this.field_73231_z);
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate((IChunkProvider)this, this.field_73230_p, par1, par2, ids, meta);
        }
        this.onChunkProvide(par1, par2, ids, meta);
        Chunk var4 = new Chunk(this.field_73230_p, ids, meta, par1, par2);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)this.field_73231_z[var6].field_76756_M;
        }
        var4.func_76603_b();
        return var4;
    }

    public void createCraters(int chunkX, int chunkZ, Block[] chunkArray, byte[] metaArray) {
        this.noiseGen5.setFrequency(0.015f);
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.noiseGen5.getNoise((float)(cx * 16 + x), (float)(cz * 16 + z)) / (float)this.CRATER_PROB))) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE + 15;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, chunkArray, metaArray);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, Block[] chunkArray, byte[] metaArray) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0 && !((double)helper > yDev); --y) {
                    if (chunkArray[this.getIndex(x, y, z)] == null) continue;
                    chunkArray[this.getIndex((int)x, (int)y, (int)z)] = Blocks.field_150350_a;
                    metaArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                    ++helper;
                }
            }
        }
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void decoratePlanet(World par1World, Random par2Random, int par3, int par4) {
        this.getBiomeGenerator().decorate(par1World, par2Random, par3, par4);
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        BlockFalling.field_149832_M = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        this.field_73230_p.func_72807_a(var4 + 16, var5 + 16);
        this.field_73220_k.setSeed(this.field_73230_p.func_72905_C());
        long var6 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        long var7 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        this.field_73220_k.setSeed((long)par2 * var6 + (long)par3 * var7 ^ this.field_73230_p.func_72905_C());
        this.decoratePlanet(this.field_73230_p, this.field_73220_k, var4, var5);
        this.onPopulate(par1IChunkProvider, par2, par3);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            Collections.addAll(monsters, this.getMonsters());
            return monsters;
        }
        if (par1EnumCreatureType == EnumCreatureType.creature) {
            ArrayList<BiomeGenBase.SpawnListEntry> creatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            Collections.addAll(creatures, this.getCreatures());
            return creatures;
        }
        if (par1EnumCreatureType == EnumCreatureType.waterCreature) {
            ArrayList<BiomeGenBase.SpawnListEntry> watercreatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            Collections.addAll(watercreatures, this.getWaterCreatures());
            return watercreatures;
        }
        return null;
    }

    protected abstract BiomeDecoratorSpace getBiomeGenerator();

    protected abstract BiomeGenBase[] getBiomesForGeneration();

    protected abstract int getSeaLevel();

    protected abstract List<MapGenBaseMeta> getWorldGenerators();

    protected abstract BiomeGenBase.SpawnListEntry[] getMonsters();

    protected abstract BiomeGenBase.SpawnListEntry[] getCreatures();

    protected abstract BiomeGenBase.SpawnListEntry[] getWaterCreatures();

    public abstract double getHeightModifier();

    public abstract double getSmallFeatureHeightModifier();

    public abstract double getMountainHeightModifier();

    public abstract double getValleyHeightModifier();

    public abstract int getCraterProbability();

    public abstract void onChunkProvide(int var1, int var2, Block[] var3, byte[] var4);

    public abstract void onPopulate(IChunkProvider var1, int var2, int var3);

    protected abstract BlockMetaPair getGrassBlock();

    protected abstract BlockMetaPair getDirtBlock();

    protected abstract BlockMetaPair getStoneBlock();

    protected abstract boolean enableBiomeGenBaseBlock();
}

