/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.init.ItemList;
import chylex.hee.mechanics.misc.StardustDecomposition;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.ItemDamagePair;
import chylex.hee.tileentity.TileEntityAbstractTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;

public class TileEntityDecompositionTable
extends TileEntityAbstractTable {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsSides = new int[]{1};
    private static final int[] slotsBottom = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
    private List<ItemStack> chosenIngredients = new ArrayList<ItemStack>();

    @Override
    public void invalidateInventory() {
        List<ItemStack> recipeIngredients;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        this.chosenIngredients.clear();
        this.resetTable();
        if (this.items[0] != null && this.field_145850_b != null && (recipeIngredients = StardustDecomposition.getRandomRecipeIngredientsFor(this.items[0], this.field_145850_b.field_73012_v)) != null) {
            int originalAmt = recipeIngredients.size();
            HashSet<ItemDamagePair> diversity = new HashSet<ItemDamagePair>();
            for (ItemStack ingredient : recipeIngredients) {
                diversity.add(new ItemDamagePair(ingredient.func_77973_b(), ingredient.func_77960_j()));
            }
            int amt = Math.max(1, Math.round((float)recipeIngredients.size() * (0.425f + this.field_145850_b.field_73012_v.nextFloat() * 0.415f) * (this.items[0].func_77984_f() ? 1.0f - (float)this.items[0].func_77960_j() / (float)this.items[0].func_77958_k() : 1.0f)));
            for (int a = 0; a < amt; ++a) {
                ItemStack ingredient;
                ingredient = recipeIngredients.remove(this.field_145850_b.field_73012_v.nextInt(recipeIngredients.size())).func_77946_l();
                recipeIngredients.remove(this.field_145850_b.field_73012_v.nextInt(recipeIngredients.size())).func_77946_l().field_77994_a = 1;
                this.chosenIngredients.add(ingredient);
            }
            float stardust = (float)originalAmt * 0.6f;
            if (this.items[0].field_77994_a == 1) {
                stardust *= 1.2f;
            }
            this.requiredStardust = (byte)Math.ceil(stardust *= 0.75f + (float)diversity.size() * 0.8f / (float)originalAmt);
            this.timeStep = (short)Math.max(2.0, 20.0 - Math.pow(this.requiredStardust, 0.9));
            this.updateComparatorStatus();
        }
    }

    @Override
    protected boolean onWorkFinished() {
        ItemStack[] itemsCopy = new ItemStack[9];
        for (int slot = 2; slot < this.items.length; ++slot) {
            itemsCopy[slot - 2] = this.items[slot] == null ? null : this.items[slot].func_77946_l();
        }
        for (ItemStack ingredient : this.chosenIngredients) {
            boolean canAdd = false;
            for (int slot = 0; slot < itemsCopy.length; ++slot) {
                if (itemsCopy[slot] == null) {
                    itemsCopy[slot] = ingredient.func_77946_l();
                } else {
                    if (!DragonUtil.canAddOneItemTo(itemsCopy[slot], ingredient)) continue;
                    ++itemsCopy[slot].field_77994_a;
                }
                canAdd = true;
                break;
            }
            if (canAdd) continue;
            return false;
        }
        block3: for (ItemStack ingredient : this.chosenIngredients) {
            for (int slot = 2; slot < this.items.length; ++slot) {
                if (this.items[slot] == null) {
                    this.items[slot] = ingredient.func_77946_l();
                    continue block3;
                }
                if (!DragonUtil.canAddOneItemTo(this.items[slot], ingredient)) continue;
                ++this.items[slot].field_77994_a;
                continue block3;
            }
        }
        this.items[0] = null;
        if ((this.items[1].field_77994_a -= this.requiredStardust) <= 0) {
            this.items[1] = null;
        }
        this.chosenIngredients.clear();
        return true;
    }

    @Override
    public int getHoldingStardust() {
        return this.items[1] == null ? 0 : this.items[1].field_77994_a;
    }

    public int func_70302_i_() {
        return 11;
    }

    @Override
    public void func_70299_a(int slot, ItemStack is) {
        super.func_70299_a(slot, is);
        if (slot == 0) {
            this.invalidateInventory();
        }
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 1 ? is.func_77973_b() == ItemList.stardust : true;
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    @Override
    protected String getContainerDefaultName() {
        return "container.decompositionTable";
    }
}

