/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackReinforced;
import mods.railcraft.common.blocks.tracks.speedcontroller.SpeedControllerReinforced;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.misc.SafeNBTWrapper;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackLauncher
extends TrackReinforced
implements ITrackPowered,
IGuiReturnHandler {
    private boolean powered = false;
    private byte launchForce = (byte)5;
    public static final int MIN_LAUNCH_FORCE = 5;
    private static final float LAUNCH_THRESHOLD = 0.01f;

    public TrackLauncher() {
        this.speedController = SpeedControllerReinforced.getInstance();
    }

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LAUNCHER;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public IIcon getIcon() {
        if (!this.isPowered()) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            GuiHandler.openGui(EnumGui.TRACK_LAUNCHER, player, this.getWorld(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (this.isPowered()) {
            if (Math.abs(cart.field_70159_w) > (double)0.01f) {
                cart.field_70159_w = Math.copySign((double)0.6f, cart.field_70159_w);
            }
            if (Math.abs(cart.field_70179_y) > (double)0.01f) {
                cart.field_70179_y = Math.copySign((double)0.6f, cart.field_70179_y);
            }
            cart.setMaxSpeedAirLateral(0.6f);
            cart.setMaxSpeedAirVertical(0.5f);
            cart.setDragAir(0.99999);
            cart.field_70181_x = (double)this.getLaunchForce() * 0.1;
            cart.getEntityData().func_74768_a("Launched", 1);
            cart.setCanUseRail(false);
            cart.func_70091_d(cart.field_70159_w, 1.5, cart.field_70179_y);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
        data.func_74774_a("force", this.getLaunchForce());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.setLaunchForce(safe.getByte("force"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.launchForce);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.launchForce = data.readByte();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.launchForce);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.launchForce = data.readByte();
    }

    public byte getLaunchForce() {
        return this.launchForce;
    }

    public void setLaunchForce(int force) {
        force = Math.max(force, 5);
        force = Math.min(force, RailcraftConfig.getLaunchRailMaxForce());
        this.launchForce = (byte)force;
    }
}

