/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.preload;

import gregtech.GTMod;
import gregtech.api.enums.Materials;
import gregtech.api.multitileentity.MultiTileEntityBlock;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.enums.GT_MultiTileCasing;
import gregtech.api.multitileentity.enums.GT_MultiTileComponentCasing;
import gregtech.api.multitileentity.enums.GT_MultiTileUpgradeCasing;
import gregtech.api.multitileentity.multiblock.base.WallShareablePart;
import gregtech.api.multitileentity.multiblock.casing.BasicCasing;
import gregtech.common.tileentities.casings.functional.Conveyor;
import gregtech.common.tileentities.casings.functional.Emitter;
import gregtech.common.tileentities.casings.functional.FieldGenerator;
import gregtech.common.tileentities.casings.functional.Motor;
import gregtech.common.tileentities.casings.functional.Piston;
import gregtech.common.tileentities.casings.functional.Pump;
import gregtech.common.tileentities.casings.functional.RobotArm;
import gregtech.common.tileentities.casings.functional.Sensor;
import gregtech.common.tileentities.casings.upgrade.Ampere;
import gregtech.common.tileentities.casings.upgrade.Cleanroom;
import gregtech.common.tileentities.casings.upgrade.Heater;
import gregtech.common.tileentities.casings.upgrade.Insulator;
import gregtech.common.tileentities.casings.upgrade.Inventory;
import gregtech.common.tileentities.casings.upgrade.Laser;
import gregtech.common.tileentities.casings.upgrade.Tank;
import gregtech.common.tileentities.casings.upgrade.Wireless;
import gregtech.common.tileentities.machines.multiblock.AdvChemicalProcessor;
import gregtech.common.tileentities.machines.multiblock.CokeOven;
import gregtech.common.tileentities.machines.multiblock.DistillationTower;
import gregtech.common.tileentities.machines.multiblock.LaserEngraver;
import gregtech.common.tileentities.machines.multiblock.LayeredCokeBattery;
import gregtech.common.tileentities.machines.multiblock.Macerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;

public class GT_Loader_MultiTileEntities
implements Runnable {
    public static final String COMPONENT_CASING_REGISTRY_NAME = "gt.multitileentity.component.casings";
    public static final String UPGRADE_CASING_REGISTRY_NAME = "gt.multitileentity.upgrade.casings";
    public static final String CASING_REGISTRY_NAME = "gt.multitileentity.casings";
    public static final String MACHINE_REGISTRY_NAME = "gt.multitileentity.controllers";
    public static final MultiTileEntityRegistry MACHINE_REGISTRY = new MultiTileEntityRegistry("gt.multitileentity.controllers", new MultiTileEntityBlock(Material.field_151573_f).modID("gregtech").materialName("machine").tool("wrench").sound(Block.field_149777_j).opaque(true).normalCube(true).register());
    public static final MultiTileEntityRegistry CASING_REGISTRY = new MultiTileEntityRegistry("gt.multitileentity.casings", new MultiTileEntityBlock(Material.field_151573_f).modID("gregtech").materialName("casing").tool("wrench").sound(Block.field_149777_j).opaque(true).normalCube(true).register());
    public static final MultiTileEntityRegistry COMPONENT_CASING_REGISTRY = new MultiTileEntityRegistry("gt.multitileentity.component.casings", new MultiTileEntityBlock(Material.field_151573_f).modID("gregtech").materialName("componentCasing").tool("wrench").sound(Block.field_149777_j).opaque(true).normalCube(true).register());
    public static final MultiTileEntityRegistry UPGRADE_CASING_REGISTRY = new MultiTileEntityRegistry("gt.multitileentity.upgrade.casings", new MultiTileEntityBlock(Material.field_151573_f).modID("gregtech").materialName("upgradeCasing").tool("wrench").sound(Block.field_149777_j).opaque(true).normalCube(true).register());

    @Override
    public void run() {
        GTMod.GT_FML_LOGGER.info("GTMod: Registering MultiTileEntities");
        GT_Loader_MultiTileEntities.registerMachines();
        GT_Loader_MultiTileEntities.registerCasings();
        GT_Loader_MultiTileEntities.registerComponentCasings();
    }

    private static void registerMachines() {
        MACHINE_REGISTRY.create(1000, Macerator.class).name("Large Macerator").category("Multiblock Controller").material(Materials.Iron).textureFolder("macerator").tankCapacity(128000L).inputInventorySize(16).outputInventorySize(16).register();
        MACHINE_REGISTRY.create(0, CokeOven.class).name("Coke Oven").category("MultiblockController").textureFolder("cokeOven").inputInventorySize(1).outputInventorySize(1).register();
        MACHINE_REGISTRY.create(1, AdvChemicalProcessor.class).name("Advanced Chemical Processor").category("MultiblockController").textureFolder("advChemicalProcessor").inputInventorySize(16).outputInventorySize(16).tankCapacity(128000L).register();
        MACHINE_REGISTRY.create(2, DistillationTower.class).name("Distillation Tower").category("MultiblockController").textureFolder("distillationTower").inputInventorySize(16).outputInventorySize(16).tankCapacity(128000L).register();
        MACHINE_REGISTRY.create(3, LayeredCokeBattery.class).name("Layered Coke Battery").category("Multiblock Controller").material(Materials.Iron).textureFolder("macerator").tankCapacity(128000L).inputInventorySize(16).outputInventorySize(16).register();
        MACHINE_REGISTRY.create(4, LaserEngraver.class).name("Big Laser Engraver").category("Multiblock Controller").textureFolder("BigLaserEngraver").inputInventorySize(16).outputInventorySize(16).tankCapacity(128000L).register();
    }

    private static void registerCasings() {
        CASING_REGISTRY.create(GT_MultiTileCasing.CokeOven.getId(), WallShareablePart.class).name("Coke Oven Bricks").category("MultiBlock Casing").textureFolder("cokeOven").register();
        CASING_REGISTRY.create(GT_MultiTileCasing.Chemical.getId(), BasicCasing.class).name("Chemical Casing").category("MultiBlock Casing").textureFolder("advChemicalProcessor").register();
        CASING_REGISTRY.create(GT_MultiTileCasing.Distillation.getId(), BasicCasing.class).name("Distillation Casing").category("MultiBlock Casing").textureFolder("distillationTower").register();
        CASING_REGISTRY.create(18000, BasicCasing.class).name("Test Casing").category("Multiblock Casing").material(Materials.Cobalt).textureFolder("macerator").register();
        CASING_REGISTRY.create(GT_MultiTileCasing.LaserEngraver.getId(), BasicCasing.class).name("Laser Engraver Casing").category("MultiBlock Casing").textureFolder("BigLaserEngraver").register();
        CASING_REGISTRY.create(GT_MultiTileCasing.Mirror.getId(), BasicCasing.class).name("Mirror").category("MultiBlock Casing").textureFolder("Laserblock").register();
        CASING_REGISTRY.create(GT_MultiTileCasing.BlackLaserEngraverCasing.getId(), BasicCasing.class).name("Black Laser Engraver Casing").category("MultiBlock Casing").textureFolder("BlackLaserEngraver").register();
        CASING_REGISTRY.create(GT_MultiTileCasing.LaserEngraverUpgrade1.getId(), BasicCasing.class).name("Crude Laser Engraving Casing").category("MultiBlock Casing").textureFolder("laserengraverupgrade1").register();
        CASING_REGISTRY.create(GT_MultiTileCasing.LaserEngraverUpgrade2.getId(), BasicCasing.class).name("Advanced Laser Engraving Casing").category("MultiBlock Casing").textureFolder("laserengraverupgrade2").register();
        CASING_REGISTRY.create(GT_MultiTileCasing.LaserEngraverUpgrade3.getId(), BasicCasing.class).name("Ultimate Laser Engraving Casing").category("MultiBlock Casing").textureFolder("laserengraverupgrade3").register();
        CASING_REGISTRY.create(GT_MultiTileCasing.LaserEngraverUpgrade4.getId(), BasicCasing.class).name("Superb Laser Engraving Casing").category("MultiBlock Casing").textureFolder("laserengraverupgrade4").register();
    }

    private static void registerComponentCasings() {
        GT_Loader_MultiTileEntities.registerMotorCasings();
        GT_Loader_MultiTileEntities.registerPumpCasings();
        GT_Loader_MultiTileEntities.registerPistonCasings();
        GT_Loader_MultiTileEntities.registerRobotArmCasings();
        GT_Loader_MultiTileEntities.registerConveyorCasings();
        GT_Loader_MultiTileEntities.registerEmitterCasings();
        GT_Loader_MultiTileEntities.registerSensorCasings();
        GT_Loader_MultiTileEntities.registerFieldGeneratorCasings();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.ULV_Inventory.getId(), Inventory.class).name("Inventory Upgrade ULV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(1).tier(0).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.LV_Inventory.getId(), Inventory.class).name("Inventory Upgrade LV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(4).tier(1).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.MV_Inventory.getId(), Inventory.class).name("Inventory Upgrade MV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(8).tier(2).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.HV_Inventory.getId(), Inventory.class).name("Inventory Upgrade HV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(16).tier(3).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.EV_Inventory.getId(), Inventory.class).name("Inventory Upgrade EV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(32).tier(4).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.IV_Inventory.getId(), Inventory.class).name("Inventory Upgrade IV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(64).tier(5).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.LuV_Inventory.getId(), Inventory.class).name("Inventory Upgrade LuV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(128).tier(6).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.ZPM_Inventory.getId(), Inventory.class).name("Inventory Upgrade ZPM").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(256).tier(7).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UV_Inventory.getId(), Inventory.class).name("Inventory Upgrade UV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(256).tier(8).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UHV_Inventory.getId(), Inventory.class).name("Inventory Upgrade UHV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(256).tier(9).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UEV_Inventory.getId(), Inventory.class).name("Inventory Upgrade UEV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(256).tier(10).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UIV_Inventory.getId(), Inventory.class).name("Inventory Upgrade UIV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(256).tier(11).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UMV_Inventory.getId(), Inventory.class).name("Inventory Upgrade UMV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(256).tier(12).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UXV_Inventory.getId(), Inventory.class).name("Inventory Upgrade UXV").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(256).tier(13).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.MAX_Inventory.getId(), Inventory.class).name("Inventory Upgrade MAX").category("MultiBlock Upgrade Casing").textureFolder("inventory").upgradeInventorySize(256).tier(14).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.ULV_Tank.getId(), Tank.class).name("Tank Upgrade ULV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(8000L).upgradeTankCount(1).tier(0).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.LV_Tank.getId(), Tank.class).name("Tank Upgrade LV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(16000L).upgradeTankCount(2).tier(1).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.MV_Tank.getId(), Tank.class).name("Tank Upgrade MV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(32000L).upgradeTankCount(4).tier(2).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.HV_Tank.getId(), Tank.class).name("Tank Upgrade HV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(64000L).upgradeTankCount(6).tier(3).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.EV_Tank.getId(), Tank.class).name("Tank Upgrade EV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(128000L).upgradeTankCount(8).tier(4).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.IV_Tank.getId(), Tank.class).name("Tank Upgrade IV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(256000L).upgradeTankCount(10).tier(5).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.LuV_Tank.getId(), Tank.class).name("Tank Upgrade LuV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(512000L).upgradeTankCount(12).tier(6).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.ZPM_Tank.getId(), Tank.class).name("Tank Upgrade ZPM").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(1024000L).upgradeTankCount(14).tier(7).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UV_Tank.getId(), Tank.class).name("Tank Upgrade UV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(2048000L).upgradeTankCount(16).tier(8).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UHV_Tank.getId(), Tank.class).name("Tank Upgrade UHV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(4096000L).upgradeTankCount(16).tier(9).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UEV_Tank.getId(), Tank.class).name("Tank Upgrade UEV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(0x7D0000L).upgradeTankCount(16).tier(10).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UIV_Tank.getId(), Tank.class).name("Tank Upgrade UIV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(0xFA0000L).upgradeTankCount(16).tier(11).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UMV_Tank.getId(), Tank.class).name("Tank Upgrade UMV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(32768000L).upgradeTankCount(16).tier(12).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.UXV_Tank.getId(), Tank.class).name("Tank Upgrade UXV").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(65536000L).upgradeTankCount(16).tier(13).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.MAX_Tank.getId(), Tank.class).name("Tank Upgrade MAX").category("MultiBlock Upgrade Casing").textureFolder("tank").upgradeTankCapacity(0x7D00000L).upgradeTankCount(16).tier(14).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_4.getId(), Ampere.class).name("Amperage Upgrade (4 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(4L).tier(1).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_16.getId(), Ampere.class).name("Amperage Upgrade (16 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(16L).tier(2).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_64.getId(), Ampere.class).name("Amperage Upgrade (64 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(64L).tier(3).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_256.getId(), Ampere.class).name("Amperage Upgrade (256 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(256L).tier(4).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_1_024.getId(), Ampere.class).name("Amperage Upgrade (1,024 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(1024L).tier(5).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_4_096.getId(), Ampere.class).name("Amperage Upgrade (4,096 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(4096L).tier(6).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_16_384.getId(), Ampere.class).name("Amperage Upgrade (16,384 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(16384L).tier(7).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_65_536.getId(), Ampere.class).name("Amperage Upgrade (65,536 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(65536L).tier(8).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_262_144.getId(), Ampere.class).name("Amperage Upgrade (262,144 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(262144L).tier(9).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Amp_1_048_576.getId(), Ampere.class).name("Amperage Upgrade (1,048,576 A)").category("MultiBlock Upgrade Casing").textureFolder("amperage").upgradeAmperage(0x100000L).tier(10).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Cleanroom.getId(), Cleanroom.class).name("Cleanroom Upgrade").category("MultiBlock Upgrade Casing").textureFolder("cleanroom").tier(1).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Laser.getId(), Laser.class).name("Laser Upgrade").category("MultiBlock Upgrade Casing").textureFolder("laser").tier(8).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Wireless.getId(), Wireless.class).name("Wireless Upgrade").category("MultiBlock Upgrade Casing").textureFolder("wireless").tier(11).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Heater_Prototype.getId(), Heater.class).name("Prototype Heater Upgrade").category("MultiBlock Upgrade Casing").textureFolder("heater").tier(1).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Heater_IndustrialGrade.getId(), Heater.class).name("Industrial-Grade Heater Upgrade").category("MultiBlock Upgrade Casing").textureFolder("heater").tier(4).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Heater_NextGen.getId(), Heater.class).name("Next-Gen Heater Upgrade").category("MultiBlock Upgrade Casing").textureFolder("heater").tier(7).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Heater_Omnipotent.getId(), Heater.class).name("Omnipotent Heater Upgrade").category("MultiBlock Upgrade Casing").textureFolder("heater").tier(10).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Heater_OmegaType.getId(), Heater.class).name("OMEGA-Type Heater Upgrade").category("MultiBlock Upgrade Casing").textureFolder("heater").tier(12).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Insulator_Prototype.getId(), Insulator.class).name("Prototype Insulator Upgrade").category("MultiBlock Upgrade Casing").textureFolder("insulator").tier(1).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Insulator_IndustrialGrade.getId(), Insulator.class).name("Industrial-Grade Insulator Upgrade").category("MultiBlock Upgrade Casing").textureFolder("insulator").tier(4).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Insulator_NextGen.getId(), Insulator.class).name("Next-Gen Insulator Upgrade").category("MultiBlock Upgrade Casing").textureFolder("insulator").tier(7).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Insulator_Omnipotent.getId(), Insulator.class).name("Omnipotent Insulator Upgrade").category("MultiBlock Upgrade Casing").textureFolder("insulator").tier(10).register();
        UPGRADE_CASING_REGISTRY.create(GT_MultiTileUpgradeCasing.Insulator_OmegaType.getId(), Insulator.class).name("OMEGA-Type Insulator Upgrade").category("MultiBlock Upgrade Casing").textureFolder("insulator").tier(12).register();
    }

    private static void registerMotorCasings() {
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LV_Motor.getId(), Motor.class).name("Motor Casing LV").tier(1).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MV_Motor.getId(), Motor.class).name("Motor Casing MV").tier(2).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.HV_Motor.getId(), Motor.class).name("Motor Casing HV").tier(3).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.EV_Motor.getId(), Motor.class).name("Motor Casing EV").tier(4).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.IV_Motor.getId(), Motor.class).name("Motor Casing IV").tier(5).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LuV_Motor.getId(), Motor.class).name("Motor Casing LuV").tier(6).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.ZPM_Motor.getId(), Motor.class).name("Motor Casing ZPM").tier(7).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UV_Motor.getId(), Motor.class).name("Motor Casing UV").tier(8).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UHV_Motor.getId(), Motor.class).name("Motor Casing UHV").tier(9).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UEV_Motor.getId(), Motor.class).name("Motor Casing UEV").tier(10).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UIV_Motor.getId(), Motor.class).name("Motor Casing UIV").tier(11).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UMV_Motor.getId(), Motor.class).name("Motor Casing UMV").tier(12).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UXV_Motor.getId(), Motor.class).name("Motor Casing UXV").tier(13).category("MultiBlock Functional Casing").textureFolder("motor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MAX_Motor.getId(), Motor.class).name("Motor Casing MAX").tier(14).category("MultiBlock Functional Casing").textureFolder("motor").register();
    }

    private static void registerPumpCasings() {
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LV_Pump.getId(), Pump.class).name("Pump Casing LV").tier(1).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MV_Pump.getId(), Pump.class).name("Pump Casing MV").tier(2).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.HV_Pump.getId(), Pump.class).name("Pump Casing HV").tier(3).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.EV_Pump.getId(), Pump.class).name("Pump Casing EV").tier(4).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.IV_Pump.getId(), Pump.class).name("Pump Casing IV").tier(5).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LuV_Pump.getId(), Pump.class).name("Pump Casing LuV").tier(6).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.ZPM_Pump.getId(), Pump.class).name("Pump Casing ZPM").tier(7).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UV_Pump.getId(), Pump.class).name("Pump Casing UV").tier(8).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UHV_Pump.getId(), Pump.class).name("Pump Casing UHV").tier(9).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UEV_Pump.getId(), Pump.class).name("Pump Casing UEV").tier(10).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UIV_Pump.getId(), Pump.class).name("Pump Casing UIV").tier(11).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UMV_Pump.getId(), Pump.class).name("Pump Casing UMV").tier(12).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UXV_Pump.getId(), Pump.class).name("Pump Casing UXV").tier(13).category("MultiBlock Functional Casing").textureFolder("pump").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MAX_Pump.getId(), Pump.class).name("Pump Casing MAX").tier(14).category("MultiBlock Functional Casing").textureFolder("pump").register();
    }

    private static void registerPistonCasings() {
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LV_Piston.getId(), Piston.class).name("Piston Casing LV").tier(1).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MV_Piston.getId(), Piston.class).name("Piston Casing MV").tier(2).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.HV_Piston.getId(), Piston.class).name("Piston Casing HV").tier(3).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.EV_Piston.getId(), Piston.class).name("Piston Casing EV").tier(4).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.IV_Piston.getId(), Piston.class).name("Piston Casing IV").tier(5).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LuV_Piston.getId(), Piston.class).name("Piston Casing LuV").tier(6).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.ZPM_Piston.getId(), Piston.class).name("Piston Casing ZPM").tier(7).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UV_Piston.getId(), Piston.class).name("Piston Casing UV").tier(8).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UHV_Piston.getId(), Piston.class).name("Piston Casing UHV").tier(9).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UEV_Piston.getId(), Piston.class).name("Piston Casing UEV").tier(10).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UIV_Piston.getId(), Piston.class).name("Piston Casing UIV").tier(11).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UMV_Piston.getId(), Piston.class).name("Piston Casing UMV").tier(12).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UXV_Piston.getId(), Piston.class).name("Piston Casing UXV").tier(13).category("MultiBlock Functional Casing").textureFolder("piston").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MAX_Piston.getId(), Piston.class).name("Piston Casing MAX").tier(14).category("MultiBlock Functional Casing").textureFolder("piston").register();
    }

    private static void registerConveyorCasings() {
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing LV").tier(1).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing MV").tier(2).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.HV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing HV").tier(3).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.EV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing EV").tier(4).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.IV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing IV").tier(5).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LuV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing LuV").tier(6).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.ZPM_Conveyor.getId(), Conveyor.class).name("Conveyor Casing ZPM").tier(7).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing UV").tier(8).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UHV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing UHV").tier(9).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UEV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing UEV").tier(10).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UIV_Conveyor.getId(), Conveyor.class).name("Conveyor Casing UIV").tier(11).category("MultiBlock Structural Casing").textureFolder("conveyor").register();
    }

    private static void registerRobotArmCasings() {
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing LV").tier(1).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing MV").tier(2).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.HV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing HV").tier(3).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.EV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing EV").tier(4).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.IV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing IV").tier(5).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LuV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing LuV").tier(6).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.ZPM_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing ZPM").tier(7).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing UV").tier(8).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UHV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing UHV").tier(9).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UEV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing UEV").tier(10).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UIV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing UIV").tier(11).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UMV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing UMV").tier(12).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UXV_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing UXV").tier(13).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MAX_RobotArm.getId(), RobotArm.class).name("Robot Arm Casing MAX").tier(14).category("MultiBlock Functional Casing").textureFolder("robotArm").register();
    }

    private static void registerSensorCasings() {
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LV_Sensor.getId(), Sensor.class).name("Sensor Casing LV").tier(1).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MV_Sensor.getId(), Sensor.class).name("Sensor Casing MV").tier(2).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.HV_Sensor.getId(), Sensor.class).name("Sensor Casing HV").tier(3).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.EV_Sensor.getId(), Sensor.class).name("Sensor Casing EV").tier(4).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.IV_Sensor.getId(), Sensor.class).name("Sensor Casing IV").tier(5).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LuV_Sensor.getId(), Sensor.class).name("Sensor Casing LuV").tier(6).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.ZPM_Sensor.getId(), Sensor.class).name("Sensor Casing ZPM").tier(7).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UV_Sensor.getId(), Sensor.class).name("Sensor Casing UV").tier(8).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UHV_Sensor.getId(), Sensor.class).name("Sensor Casing UHV").tier(9).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UEV_Sensor.getId(), Sensor.class).name("Sensor Casing UEV").tier(10).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UIV_Sensor.getId(), Sensor.class).name("Sensor Casing UIV").tier(11).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UMV_Sensor.getId(), Sensor.class).name("Sensor Casing UMV").tier(12).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UXV_Sensor.getId(), Sensor.class).name("Sensor Casing UXV").tier(13).category("MultiBlock Functional Casing").textureFolder("sensor").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MAX_Sensor.getId(), Sensor.class).name("Sensor Casing MAX").tier(14).category("MultiBlock Functional Casing").textureFolder("sensor").register();
    }

    private static void registerEmitterCasings() {
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LV_Emitter.getId(), Emitter.class).name("Emitter Casing LV").tier(1).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MV_Emitter.getId(), Emitter.class).name("Emitter Casing MV").tier(2).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.HV_Emitter.getId(), Emitter.class).name("Emitter Casing HV").tier(3).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.EV_Emitter.getId(), Emitter.class).name("Emitter Casing EV").tier(4).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.IV_Emitter.getId(), Emitter.class).name("Emitter Casing IV").tier(5).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LuV_Emitter.getId(), Emitter.class).name("Emitter Casing LuV").tier(6).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.ZPM_Emitter.getId(), Emitter.class).name("Emitter Casing ZPM").tier(7).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UV_Emitter.getId(), Emitter.class).name("Emitter Casing UV").tier(8).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UHV_Emitter.getId(), Emitter.class).name("Emitter Casing UHV").tier(9).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UEV_Emitter.getId(), Emitter.class).name("Emitter Casing UEV").tier(10).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UIV_Emitter.getId(), Emitter.class).name("Emitter Casing UIV").tier(11).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UMV_Emitter.getId(), Emitter.class).name("Emitter Casing UMV").tier(12).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UXV_Emitter.getId(), Emitter.class).name("Emitter Casing UXV").tier(13).category("MultiBlock Functional Casing").textureFolder("emitter").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MAX_Emitter.getId(), Emitter.class).name("Emitter Casing MAX").tier(14).category("MultiBlock Functional Casing").textureFolder("emitter").register();
    }

    private static void registerFieldGeneratorCasings() {
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator LV").tier(1).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator MV").tier(2).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.HV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator HV").tier(3).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.EV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator EV").tier(4).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.IV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator IV").tier(5).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.LuV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator LuV").tier(6).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.ZPM_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator ZPM").tier(7).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator UV").tier(8).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UHV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator UHV").tier(9).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UEV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator UEV").tier(10).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UIV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator UIV").tier(11).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UMV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator UMV").tier(12).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.UXV_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator UXV").tier(13).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
        COMPONENT_CASING_REGISTRY.create(GT_MultiTileComponentCasing.MAX_FieldGenerator.getId(), FieldGenerator.class).name("Field Generator MAX").tier(14).category("Multiblock Energy Field").textureFolder("fieldGenerator").register();
    }
}

