/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.compressor;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.metadata.CompressionTierKey;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings10;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTENeutroniumCompressor
extends MTEExtendedPowerMultiBlockBase<MTENeutroniumCompressor>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTENeutroniumCompressor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"  CEEEEEC  ", " CE     EC ", "CE       EC", "E         E", "E         E", "E         E", "E         E", "E         E", "CE       EC", " CE     EC ", "  CEEEEEC  "}, {" CE     EC ", "C  BBBBB  C", "E BBBBBBB E", " BBCCCCCBB ", " BBCBBBCBB ", " BBCCCCCBB ", " BBCBBBCBB ", " BBCCCCCBB ", "E BBBBBBB E", "C  BBBBB  C", " CE     EC "}, {"CE       EC", "E BBBBBBB E", " B       B ", " D       D ", " B       B ", " B       B ", " D       D ", " B       B ", " B       B ", "E BDDDBDB E", "CE       EC"}, {"E         E", " BBAAAAABB ", " B       B ", " D       D ", " B       B ", " D       D ", " D       D ", " B       B ", " B       B ", " BBDBBBDBB ", "E         E"}, {"E         E", " BBAAAAABB ", " B       B ", " D       D ", " B       B ", " B       B ", " D       D ", " D       D ", " D       D ", " BDDBDDDDB ", "E         E"}, {"E         E", " BBAAAAABB ", " D       D ", " D       D ", " D       D ", " B       B ", " B       B ", " B       B ", " B       B ", " BBDBBBBDB ", "E         E"}, {"E         E", " BBAAAAABB ", " B       B ", " B       B ", " D       D ", " B       B ", " B       B ", " D       D ", " B       B ", " BBDBBDBBB ", "E         E"}, {"E         E", " BBAAAAABB ", " B       B ", " D       D ", " D       D ", " B       B ", " D       D ", " D       D ", " D       D ", " BBBBBDDDB ", "E         E"}, {"CE       EC", "E BBBBBBB E", " B       B ", " D       D ", " B       B ", " B       B ", " D       D ", " B       B ", " B       B ", "E BDDBBBB E", "CE       EC"}, {" CE     EC ", "C  BB~BB  C", "E BBBBBBB E", " BBBBBBBBB ", " BBBBBBBBB ", " BBBBBBBBB ", " BBBBBBBBB ", " BBBBBBBBB ", "E BBBBBBB E", "C  BBBBB  C", " CE     EC "}, {"  CEEEEEC  ", " CE     EC ", "CE       EC", "E         E", "E         E", "E         E", "E         E", "E         E", "CE       EC", " CE     EC ", "  CEEEEEC  "}})).addElement('A', Glasses.chainAllGlasses()).addElement('B', GTStructureUtility.buildHatchAdder(MTENeutroniumCompressor.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(6)).dot(1).buildAndChain(StructureUtility.onElementPass(MTENeutroniumCompressor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)6)))).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)8)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)7)).addElement('E', GTStructureUtility.ofFrame(Materials.NaquadahAlloy)).build();
    private int mCasingAmount;

    public MTENeutroniumCompressor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTENeutroniumCompressor(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTENeutroniumCompressor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENeutroniumCompressor(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 6)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_MULTI_NEUTRONIUM_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_MULTI_NEUTRONIUM_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 6)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_MULTI_NEUTRONIUM).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_MULTI_NEUTRONIUM_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 6))};
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Neutronium Compressor").addInfo("Has a static 8 parallels").addInfo("Capable of compressing matter into " + EnumChatFormatting.GOLD + "singularities").addInfo("More advanced singularities will require even stronger compression...").beginStructureBlock(11, 11, 11, true).addController("Front Center").addCasingInfoMin("Neutronium Casing", 220, false).addCasingInfoExactly("Active Neutronium Casing", 63, false).addCasingInfoExactly("Any Glass", 25, false).addCasingInfoExactly("Naquadah Alloy Frame Box", 108, false).addCasingInfoExactly("Neutronium Stabilization Casing", 67, false).addInputBus("Any Neutronium Casing", 1).addOutputBus("Any Neutronium Casing", 1).addEnergyHatch("Any Neutronium Casing", 1).addMaintenanceHatch("Any Neutronium Casing", 1).toolTipFinisher(GTValues.AuthorFourIsTheNumber, GTValues.Ollie);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 5, 9, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 5, 9, 1, elementBudget, env, false, true);
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 5, 9, 1) && this.mCasingAmount >= 220;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTUtility.roundUpVoltage(this.getMaxInputVoltage()));
        logic.setAvailableAmperage(1L);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (recipe.getMetadataOrDefault(CompressionTierKey.INSTANCE, 0) > 0) {
                    return CheckRecipeResultRegistry.NO_BLACK_HOLE;
                }
                return super.validateRecipe(recipe);
            }
        }.setMaxParallel(8);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.neutroniumCompressorRecipes;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }
}

