/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.gui.IOpenableGui;
import serverutils.lib.gui.misc.GuiSelectItemStack;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.item.ItemStackSerializer;
import serverutils.lib.util.InvUtils;
import serverutils.lib.util.misc.MouseButton;

public class ConfigItemStack
extends ConfigValue {
    public static final String ID = "item_stack";
    private ItemStack value;
    private boolean singleItemOnly;

    public ConfigItemStack(ItemStack is, boolean b) {
        this.value = is;
        this.singleItemOnly = b;
        if (this.singleItemOnly && this.value != null && this.value.field_77994_a > 1) {
            this.value.field_77994_a = 1;
        }
    }

    public ConfigItemStack(ItemStack is) {
        this(is, false);
    }

    @Override
    public String getId() {
        return ID;
    }

    public ItemStack getStack() {
        return this.value;
    }

    public void setStack(ItemStack is) {
        this.value = is;
        if (this.getSingleItemOnly() && this.value != null && this.value.field_77994_a > 1) {
            this.value.field_77994_a = 1;
        }
    }

    public boolean getSingleItemOnly() {
        return this.singleItemOnly;
    }

    public void setSingleItemOnly(boolean v) {
        this.singleItemOnly = v;
    }

    @Override
    public String getString() {
        return this.getStack().func_77955_b(new NBTTagCompound()).toString();
    }

    @Override
    public boolean getBoolean() {
        return this.getInt() > 0;
    }

    @Override
    public int getInt() {
        return this.getStack().field_77994_a;
    }

    @Override
    public ConfigItemStack copy() {
        return new ConfigItemStack(this.getStack(), this.getSingleItemOnly());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getStack();
        if (this.value != null) {
            nbt.func_74782_a(key, (NBTBase)this.value.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        NBTTagCompound nbt1 = nbt.func_74775_l(key);
        if (nbt1.func_82582_d()) {
            this.setStack(InvUtils.EMPTY_STACK);
        } else {
            this.setStack(ItemStack.func_77949_a((NBTTagCompound)nbt1));
        }
    }

    @Override
    public void writeData(DataOut data) {
        data.writeItemStack(this.getStack());
        data.writeBoolean(this.getSingleItemOnly());
    }

    @Override
    public void readData(DataIn data) {
        this.setStack(data.readItemStack());
        this.setSingleItemOnly(data.readBoolean());
    }

    @Override
    public boolean isEmpty() {
        return this.getStack() == null;
    }

    @Override
    public IChatComponent getStringForGUI() {
        this.value = this.getStack();
        if (this.value.field_77994_a <= 1) {
            return new ChatComponentText(this.value.func_82833_r());
        }
        return new ChatComponentText(this.value.field_77994_a + "x " + this.value.func_82833_r());
    }

    @Override
    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
        if (inst.getCanEdit()) {
            new GuiSelectItemStack(gui, this.getStack().func_77946_l(), this.getSingleItemOnly(), stack -> {
                this.setStack((ItemStack)stack);
                callback.run();
            }).openGui();
        }
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.isEmpty()) {
            return false;
        }
        try {
            ItemStack stack = ItemStackSerializer.parseItemThrowingException(string);
            if (stack.field_77994_a > 1 && this.getSingleItemOnly()) {
                return false;
            }
            if (!simulate) {
                this.setStack(stack);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        if (value instanceof ConfigItemStack) {
            ConfigItemStack configItemStack = (ConfigItemStack)value;
            this.setStack(configItemStack.getStack().func_77946_l());
        } else {
            super.setValueFromOtherValue(value);
        }
    }

    public static class SimpleStack
    extends ConfigItemStack {
        private final Supplier<ItemStack> get;
        private final Consumer<ItemStack> set;

        public SimpleStack(boolean single, Supplier<ItemStack> g, Consumer<ItemStack> s) {
            super(InvUtils.EMPTY_STACK, single);
            this.get = g;
            this.set = s;
        }

        public SimpleStack(Supplier<ItemStack> g, Consumer<ItemStack> s) {
            this(false, g, s);
        }

        @Override
        public ItemStack getStack() {
            return this.get.get();
        }

        @Override
        public void setStack(ItemStack v) {
            this.set.accept(v);
        }
    }
}

