/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.item;

import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="minetweaker.item.IIngredient")
public class IngredientTransform {
    @ZenMethod
    public static IIngredient reuse(IIngredient ingredient) {
        return ingredient.transform((item, byPlayer) -> item.withAmount(item.getAmount() + 1));
    }

    @ZenMethod
    public static IIngredient transformDamage(IIngredient ingredient) {
        return ingredient.transform((item, byPlayer) -> {
            int newDamage = item.getDamage() + 1;
            if (newDamage >= item.getMaxDamage()) {
                return item.withAmount(item.getAmount()).withDamage(0);
            }
            return item.withAmount(item.getAmount() + 1).withDamage(newDamage);
        });
    }

    @ZenMethod
    public static IIngredient transformDamage(IIngredient ingredient, int damage) {
        return ingredient.transform((item, byPlayer) -> {
            int newDamage = item.getDamage() + damage;
            if (newDamage >= item.getMaxDamage()) {
                return item.withAmount(item.getAmount()).withDamage(0);
            }
            return item.withAmount(item.getAmount()).withDamage(newDamage);
        });
    }

    @ZenMethod
    public static IIngredient transformReplace(IIngredient ingredient, IItemStack withItem) {
        return ingredient.transform((item, byPlayer) -> {
            if (item.getAmount() > 1) {
                byPlayer.give(withItem);
                return item;
            }
            return withItem.withAmount(withItem.getAmount());
        });
    }

    @ZenMethod
    public static IIngredient transformConsume(IIngredient ingredient, int amount) {
        return ingredient.transform((item, byPlayer) -> item.withAmount(Math.max(item.getAmount() - amount, 0) + 1));
    }

    @ZenMethod
    public static IIngredient noReturn(IIngredient ingredient) {
        return ingredient.transform((item, byPlayer) -> null);
    }

    @ZenMethod
    public static IIngredient giveBack(IIngredient ingredient, @Optional IItemStack givenItem) {
        return ingredient.transform((item, byPlayer) -> {
            if (givenItem == null) {
                byPlayer.give(item.withAmount(1));
                return item;
            }
            byPlayer.give(givenItem);
            return item;
        });
    }
}

