/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui.widgets;

import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.BiomeDictionary;
import org.lwjgl.opengl.GL11;

public class HabitatSlot
extends Widget {
    private final Collection<BiomeDictionary.Type> biomes;
    private final String name;
    private final String iconIndex;
    public boolean isActive = false;

    public HabitatSlot(WidgetManager widgetManager, int xPos, int yPos, String name, Collection<BiomeDictionary.Type> biomes) {
        super(widgetManager, xPos, yPos);
        this.biomes = biomes;
        this.name = name;
        this.iconIndex = "habitats/" + name.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String getLegacyTooltip(EntityPlayer player) {
        return this.name;
    }

    public IIcon getIcon() {
        return TextureManager.getInstance().getDefault(this.iconIndex);
    }

    public void setActive(Collection<BiomeDictionary.Type> biomes) {
        this.isActive = !Collections.disjoint(this.biomes, biomes);
    }

    @Override
    public void draw(int startX, int startY) {
        if (this.getIcon() != null) {
            if (!this.isActive) {
                GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Proxies.render.bindTexture(SpriteSheet.ITEMS);
            this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, this.getIcon(), 16, 16);
        }
    }
}

