/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.ironchestminecarts.minecarts;

import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemChestChanger;
import ganymedes01.ironchestminecarts.IronChestMinecarts;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.carts.IItemTransfer;
import mods.railcraft.api.core.items.IStackFilter;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

@Optional.Interface(iface="mods.railcraft.api.carts.IItemTransfer", modid="Railcraft")
public abstract class EntityMinecartIronChestAbstract
extends EntityMinecartChest
implements IItemTransfer {
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private static final Map<IronChestType, Class<? extends EntityMinecartIronChestAbstract>> map = new HashMap<IronChestType, Class<? extends EntityMinecartIronChestAbstract>>();

    public static Set<IronChestType> registeredTypes() {
        return map.keySet();
    }

    public static EntityMinecartIronChestAbstract makeMinecart(World world, double x, double y, double z, IronChestType type) {
        try {
            Class<? extends EntityMinecartIronChestAbstract> cls = map.get(type);
            return cls.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(world, x, y, z);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EntityMinecartIronChestAbstract(World world) {
        super(world);
    }

    public EntityMinecartIronChestAbstract(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public abstract IronChestType type();

    public ItemStack getCartItem() {
        Item minecart = IronChestMinecarts.carts.get(this.type());
        return new ItemStack(minecart != null ? minecart : Items.field_151143_au);
    }

    public void func_94095_a(DamageSource src) {
        this.func_70106_y();
        ItemStack minecart = new ItemStack(Items.field_151143_au);
        if (this.func_95999_t() != null) {
            minecart.func_151001_c(this.func_95999_t());
        }
        this.func_70099_a(minecart, 0.0f);
        this.func_70099_a(new ItemStack(this.func_145817_o(), 1, this.type().ordinal()), 0.0f);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            float x = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
            float y = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
            float z = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)x, this.field_70163_u + (double)y, this.field_70161_v + (double)z, stack.func_77946_l());
            entityitem.field_70159_w = (float)this.field_70146_Z.nextGaussian() * 0.05f;
            entityitem.field_70181_x = (float)this.field_70146_Z.nextGaussian() * 0.25f;
            entityitem.field_70179_y = (float)this.field_70146_Z.nextGaussian() * 0.05f;
            this.field_70170_p.func_72838_d((Entity)entityitem);
            this.func_70299_a(i, null);
        }
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public int func_70302_i_() {
        IronChestType type = this.type();
        return type.getRowCount() * type.getRowLength();
    }

    public Block func_145817_o() {
        return IronChest.ironChestBlock;
    }

    public int func_94097_p() {
        return this.type().ordinal();
    }

    public boolean func_130002_c(EntityPlayer player) {
        ItemChestChanger changer;
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player))) {
            return true;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof ItemChestChanger && (changer = (ItemChestChanger)stack.func_77973_b()).getType().canUpgrade(this.type())) {
            if (!this.field_70170_p.field_72995_K) {
                IronChestType newType = IronChestType.values()[changer.getTargetChestOrdinal(this.type().ordinal())];
                NBTTagCompound nbt = new NBTTagCompound();
                this.func_70109_d(nbt);
                this.func_70106_y();
                try {
                    EntityMinecartIronChestAbstract minecart = map.get(newType).getConstructor(World.class).newInstance(this.field_70170_p);
                    minecart.func_70020_e(nbt);
                    this.field_70170_p.func_72838_d((Entity)minecart);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                player.func_70062_b(0, null);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            player.openGui((Object)IronChestMinecarts.instance, this.hashCode(), this.field_70170_p, 0, 0, 0);
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= size) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(size);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemstack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.type().acceptsStack(stack);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        String entityName;
        if (this.func_94100_s()) {
            nbt.func_74757_a("CustomDisplayTile", true);
            nbt.func_74768_a("DisplayTile", this.func_145820_n().func_149688_o() == Material.field_151579_a ? 0 : Block.func_149682_b((Block)this.func_145820_n()));
            nbt.func_74768_a("DisplayData", this.func_94098_o());
            nbt.func_74768_a("DisplayOffset", this.func_94099_q());
        }
        if ((entityName = this.func_95999_t()) != null && entityName.length() > 0) {
            nbt.func_74778_a("CustomName", entityName);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74767_n("CustomDisplayTile")) {
            this.func_145819_k(nbt.func_74762_e("DisplayTile"));
            this.func_94092_k(nbt.func_74762_e("DisplayData"));
            this.func_94086_l(nbt.func_74762_e("DisplayOffset"));
        }
        if (nbt.func_150297_b("CustomName", 8) && nbt.func_74779_i("CustomName").length() > 0) {
            this.func_96094_a(nbt.func_74779_i("CustomName"));
        }
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Optional.Method(modid="Railcraft")
    public ItemStack offerItem(Object source, ItemStack offer) {
        if (offer == null) {
            return null;
        }
        offer = offer.func_77946_l();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (this.func_70301_a(slot) == null) {
                this.func_70299_a(slot, offer);
                return null;
            }
            ItemStack invtStack = this.func_70301_a(slot);
            if (invtStack.field_77994_a >= Math.min(invtStack.func_77976_d(), this.func_70297_j_()) || !ItemStack.func_77989_b((ItemStack)offer, (ItemStack)invtStack)) continue;
            invtStack.field_77994_a += offer.field_77994_a;
            if (invtStack.field_77994_a > invtStack.func_77976_d()) {
                offer.field_77994_a = invtStack.field_77994_a - invtStack.func_77976_d();
                invtStack.field_77994_a = invtStack.func_77976_d();
                return offer;
            }
            return null;
        }
        return offer;
    }

    @Optional.Method(modid="Railcraft")
    public ItemStack requestItem(Object source) {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack == null) continue;
            return this.func_70298_a(slot, 1);
        }
        return null;
    }

    @Optional.Method(modid="Railcraft")
    public ItemStack requestItem(Object source, ItemStack request) {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack == null || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)request)) continue;
            return this.func_70298_a(slot, 1);
        }
        return null;
    }

    @Optional.Method(modid="Railcraft")
    public ItemStack requestItem(Object source, IStackFilter request) {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack == null || !request.matches(stack)) continue;
            return this.func_70298_a(slot, 1);
        }
        return null;
    }

    static {
        try {
            Class<EntityMinecartIronChestAbstract> clss = EntityMinecartIronChestAbstract.class;
            String name = clss.getCanonicalName();
            name = name.substring(0, name.lastIndexOf(46));
            for (ClassPath.ClassInfo clazzInfo : ClassPath.from((ClassLoader)clss.getClassLoader()).getTopLevelClasses(name + ".types")) {
                Class clazz = clazzInfo.load();
                if (!clss.isAssignableFrom(clazz)) continue;
                IronChestType type = ((EntityMinecartIronChestAbstract)((Object)clazz.getConstructor(World.class).newInstance(new Object[]{null}))).type();
                EntityRegistry.registerModEntity((Class)clazz, (String)("minecart_chest_" + type.name().toLowerCase().replace("teel", "ilver")), (int)type.ordinal(), (Object)IronChestMinecarts.instance, (int)80, (int)3, (boolean)true);
                map.put(type, clazz);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

