/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IEffectData;
import java.util.List;
import magicbees.bees.Allele;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;

public abstract class AlleleEffect
extends Allele
implements IAlleleBeeEffect {
    protected int throttle;
    protected boolean combinable;

    public AlleleEffect(String id, boolean isDominant, int timeout) {
        super("effect" + id, isDominant, new IChromosomeType[]{EnumBeeChromosome.EFFECT});
        this.throttle = timeout;
        this.combinable = false;
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public AlleleEffect setIsCombinable(boolean canCombine) {
        this.combinable = canCombine;
        return this;
    }

    public abstract IEffectData validateStorage(IEffectData var1);

    public final IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int count = storedData.getInteger(0);
        if (count >= this.throttle) {
            storedData = this.doEffectThrottled(genome, storedData, housing);
        } else {
            storedData.setInteger(0, count + 1);
        }
        return storedData;
    }

    protected abstract IEffectData doEffectThrottled(IBeeGenome var1, IEffectData var2, IBeeHousing var3);

    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        return Allele.forestryBaseEffect.doFX(genome, storedData, housing);
    }

    protected <T extends Entity> List<T> getEntitiesWithinRange(IBeeGenome genome, IBeeHousing housing, Class<T> entityClass) {
        int[] area = genome.getTerritory();
        ChunkCoordinates coords = housing.getCoordinates();
        int[] min = new int[3];
        int[] max = new int[3];
        min[0] = coords.field_71574_a - area[0] / 2;
        max[0] = coords.field_71574_a + area[0] / 2;
        min[1] = coords.field_71572_b - area[1] / 2;
        max[1] = coords.field_71572_b + area[1] / 2;
        min[2] = coords.field_71573_c - area[2] / 2;
        max[2] = coords.field_71573_c + area[2] / 2;
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)min[0], (double)min[1], (double)min[2], (double)max[0], (double)max[1], (double)max[2]);
        return housing.getWorld().func_72872_a(entityClass, bounds);
    }
}

