/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.lwjgl;

import com.gtnewhorizons.angelica.compat.lwjgl.CompatMemoryUtil;
import com.gtnewhorizons.angelica.compat.lwjgl.Pointer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.MemoryUtil;

public class MemoryStack
extends Pointer.Default
implements AutoCloseable {
    private static final int DEFAULT_STACK_SIZE = 65536;
    private static final int DEFAULT_STACK_FRAMES = 8;
    private static final ThreadLocal<MemoryStack> TLS = ThreadLocal.withInitial(MemoryStack::create);
    @Nullable
    private final ByteBuffer container;
    private final int size;
    private int pointer;
    private int[] frames;
    protected int frameIndex;

    protected MemoryStack(@Nullable ByteBuffer container, long address, int size) {
        super(address);
        this.container = container;
        this.size = size;
        this.pointer = size;
        this.frames = new int[8];
    }

    public static MemoryStack create() {
        return MemoryStack.create(65536);
    }

    public static MemoryStack create(int capacity) {
        return MemoryStack.create(BufferUtils.createByteBuffer((int)capacity));
    }

    public static MemoryStack create(ByteBuffer buffer) {
        long address = MemoryUtil.getAddress((ByteBuffer)buffer);
        int size = buffer.remaining();
        return new MemoryStack(buffer, address, size);
    }

    public static MemoryStack ncreate(long address, int size) {
        return new MemoryStack(null, address, size);
    }

    public MemoryStack push() {
        if (this.frameIndex == this.frames.length) {
            this.frameOverflow();
        }
        this.frames[this.frameIndex++] = this.pointer;
        return this;
    }

    private void frameOverflow() {
        this.frames = Arrays.copyOf(this.frames, this.frames.length * 3 / 2);
    }

    public MemoryStack pop() {
        this.pointer = this.frames[--this.frameIndex];
        return this;
    }

    @Override
    public void close() {
        this.pop();
    }

    public long getAddress() {
        return this.address;
    }

    public int getSize() {
        return this.size;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public long getPointerAddress() {
        return this.address + ((long)this.pointer & 0xFFFFFFFFL);
    }

    public int getPointer() {
        return this.pointer;
    }

    public void setPointer(int pointer) {
        this.pointer = pointer;
    }

    private void checkPointer(int pointer) {
        if (pointer < 0 || this.size < pointer) {
            throw new IndexOutOfBoundsException("Invalid stack pointer");
        }
    }

    private static void checkAlignment(int alignment) {
        if (Integer.bitCount(alignment) != 1) {
            throw new IllegalArgumentException("Alignment must be a power-of-two value.");
        }
    }

    public long nmalloc(int size) {
        return this.nmalloc(POINTER_SIZE, size);
    }

    public long nmalloc(int alignment, int size) {
        long address = this.address + (long)this.pointer - (long)size & (Integer.toUnsignedLong(alignment - 1) ^ 0xFFFFFFFFFFFFFFFFL);
        this.pointer = (int)(address - this.address);
        return address;
    }

    public long ncalloc(int alignment, int num, int size) {
        int bytes = num * size;
        long address = this.nmalloc(alignment, bytes);
        CompatMemoryUtil.memSet(address, 0, bytes);
        return address;
    }

    public long nshort(short value) {
        long a = this.nmalloc(2, 2);
        CompatMemoryUtil.memPutShort(a, value);
        return a;
    }

    public IntBuffer mallocInt(int size) {
        return CompatMemoryUtil.wrapBufferInt(this.nmalloc(4, size << 2), size);
    }

    public long nint(int value) {
        long a = this.nmalloc(4, 4);
        CompatMemoryUtil.memPutInt(a, value);
        return a;
    }

    public long nlong(long value) {
        long a = this.nmalloc(8, 8);
        CompatMemoryUtil.memPutLong(a, value);
        return a;
    }

    public FloatBuffer mallocFloat(int size) {
        return CompatMemoryUtil.wrapBufferFloat(this.nmalloc(4, size << 2), size);
    }

    public long nfloat(float value) {
        long a = this.nmalloc(4, 4);
        CompatMemoryUtil.memPutFloat(a, value);
        return a;
    }

    public long ndouble(double value) {
        long a = this.nmalloc(8, 8);
        CompatMemoryUtil.memPutDouble(a, value);
        return a;
    }

    public static MemoryStack stackGet() {
        return TLS.get();
    }

    public static MemoryStack stackPush() {
        return MemoryStack.stackGet().push();
    }

    public static MemoryStack stackPop() {
        return MemoryStack.stackGet().pop();
    }

    public static long nstackMalloc(int size) {
        return MemoryStack.stackGet().nmalloc(size);
    }

    public static long nstackMalloc(int alignment, int size) {
        return MemoryStack.stackGet().nmalloc(alignment, size);
    }

    public static long nstackCalloc(int alignment, int num, int size) {
        return MemoryStack.stackGet().ncalloc(alignment, num, size);
    }
}

