/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.block;

import appeng.api.storage.data.IAEFluidStack;
import appeng.util.Platform;
import com.glodblock.github.client.render.RenderBlockFluidBuffer;
import com.glodblock.github.common.block.FCBaseBlock;
import com.glodblock.github.common.item.FCBaseItemBlock;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.common.tile.TileFluidBuffer;
import com.glodblock.github.crossmod.waila.Tooltip;
import com.glodblock.github.util.NameConst;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidBuffer
extends FCBaseBlock {
    public BlockFluidBuffer() {
        super(Material.field_151573_f, "fluid_buffer");
        this.setTileEntity(TileFluidBuffer.class);
        this.setFullBlock(false);
        this.setOpaque(false);
        this.field_149786_r = 3;
    }

    public boolean onActivated(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        FluidStack fs = Util.getFluidFromItem(itemStack);
        if (Platform.isServer()) {
            TileFluidBuffer tile = (TileFluidBuffer)this.getTileEntity((IBlockAccess)world, x, y, z);
            if (tile == null) {
                return false;
            }
            if (player.func_70093_af() && itemStack == null) {
                return !tile.setFluid(null);
            }
            IAEFluidStack ias = tile.getAEStoreFluidStack();
            if (fs == null && ias != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(Tooltip.fluidFormat(ias.getFluid().getLocalizedName(), ias.getStackSize())));
                return false;
            }
            tile.setFluid(fs);
            return true;
        }
        return fs != null || player.func_70093_af() && itemStack == null;
    }

    @Override
    public BlockFluidBuffer register() {
        GameRegistry.registerBlock((Block)this, FCBaseItemBlock.class, (String)"fluid_buffer");
        GameRegistry.registerTileEntity(TileFluidBuffer.class, (String)"fluid_buffer");
        this.func_149647_a(FluidCraftingTabs.INSTANCE);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlockFluidBuffer getRenderer() {
        return new RenderBlockFluidBuffer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> toolTip, boolean advancedToolTips) {
        if (GuiScreen.func_146272_n()) {
            toolTip.add(NameConst.i18n("ae2fc.tooltip.fluid_buffer.desc"));
        } else {
            toolTip.add(NameConst.i18n("ae2fc.tooltip.shift_for_more"));
        }
    }
}

