/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools.baseclasses;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.items.ItemDE;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IHudDisplayItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class RFItemBase
extends ItemDE
implements IEnergyContainerItem,
IConfigurableItem,
IHudDisplayItem {
    protected int capacity = 0;
    protected int maxReceive = 0;
    protected int maxExtract = 0;

    public RFItemBase() {
        this.func_77625_d(1);
        this.func_77637_a(DraconicEvolution.tabToolsWeapons);
    }

    @Override
    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int getCapacity(ItemStack stack) {
        return this.capacity;
    }

    public int getMaxExtract(ItemStack stack) {
        return this.maxExtract;
    }

    public int getMaxReceive(ItemStack stack) {
        return this.maxReceive;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int energy = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        int energyReceived = Math.min(this.getCapacity(container) - energy, Math.min(this.getMaxReceive(container), maxReceive));
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)(energy += energyReceived));
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        int energy = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        int energyExtracted = Math.min(energy, Math.min(this.getMaxExtract(container), maxExtract));
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)(energy -= energyExtracted));
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getCapacity(container);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item, 1, 0), (String)"Energy", (int)0));
        if (this.capacity > 0) {
            list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item, 1, 0), (String)"Energy", (int)this.capacity));
        }
    }

    public boolean func_77614_k() {
        return this.capacity > 0;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        return new ArrayList<ItemConfigField>();
    }

    @Override
    public List<String> getDisplayData(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.hasProfiles()) {
            int preset = ItemNBTHelper.getInteger((ItemStack)stack, (String)"ConfigProfile", (int)0);
            list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"info.de.capacitorMode.txt") + ": " + ItemNBTHelper.getString((ItemStack)stack, (String)("ProfileName" + preset), (String)("Profile " + preset)));
        }
        for (ItemConfigField field : this.getFields(stack, 0)) {
            list.add(field.getTooltipInfo());
        }
        if (this.getCapacity(stack) > 0) {
            list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"info.de.charge.txt") + ": " + InfoHelper.HITC() + Utills.formatNumber((long)this.getEnergyStored(stack)) + " / " + Utills.formatNumber((long)this.capacity));
        }
        return list;
    }

    @Override
    public boolean hasProfiles() {
        return true;
    }
}

