/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.recipes;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.scripts.IScriptLoader;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeRemover {
    private static HashMap<GTUtility.ItemId, List<Function<IRecipe, Boolean>>> bufferMap;
    private static Field recipeWidthField;

    private static void addToBuffer(HashSet<GTUtility.ItemId> outputs, Function<IRecipe, Boolean> whenToRemove) {
        for (GTUtility.ItemId output : outputs) {
            bufferMap.computeIfAbsent(output, o -> new ArrayList()).add(whenToRemove);
        }
    }

    private static void flushBuffer() {
        ArrayList list = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        int i = list.size();
        list.removeIf(r -> {
            ItemStack rCopy = r.func_77571_b();
            if (rCopy == null) {
                return false;
            }
            if (rCopy.func_77973_b() == null) {
                MainRegistry.Logger.warn((Object)"Someone is adding recipes with null items!");
                return true;
            }
            if (rCopy.field_77990_d != null) {
                rCopy = rCopy.func_77946_l();
                rCopy.field_77990_d = null;
            }
            GTUtility.ItemId key = GTUtility.ItemId.createNoCopy((ItemStack)rCopy);
            rCopy = rCopy.func_77946_l();
            Items.field_151008_G.setDamage(rCopy, Short.MAX_VALUE);
            GTUtility.ItemId keyWildcard = GTUtility.ItemId.createNoCopy((ItemStack)rCopy);
            List<Function<IRecipe, Boolean>> listWhenToRemove = bufferMap.get(key);
            if (listWhenToRemove == null) {
                listWhenToRemove = bufferMap.get(keyWildcard);
            }
            if (listWhenToRemove == null) {
                return false;
            }
            for (Function<IRecipe, Boolean> whenToRemove : listWhenToRemove) {
                if (!whenToRemove.apply((IRecipe)r).booleanValue()) continue;
                return true;
            }
            return false;
        });
        MainRegistry.Logger.info((Object)("Removed " + (i - list.size()) + " recipes!"));
    }

    private static HashSet<GTUtility.ItemId> getItemsHashed(Object item, boolean includeWildcardVariants) {
        HashSet<GTUtility.ItemId> hashedItems = new HashSet<GTUtility.ItemId>();
        if (item instanceof ItemStack) {
            ItemStack iCopy = ((ItemStack)item).func_77946_l();
            iCopy.field_77990_d = null;
            hashedItems.add(GTUtility.ItemId.createNoCopy((ItemStack)iCopy));
            if (includeWildcardVariants) {
                iCopy = iCopy.func_77946_l();
                Items.field_151008_G.setDamage(iCopy, Short.MAX_VALUE);
                hashedItems.add(GTUtility.ItemId.createNoCopy((ItemStack)iCopy));
            }
        } else if (item instanceof String) {
            for (ItemStack stack : OreDictionary.getOres((String)((String)item))) {
                hashedItems.add(GTUtility.ItemId.createNoCopy((ItemStack)stack));
                if (!includeWildcardVariants) continue;
                stack = stack.func_77946_l();
                Items.field_151008_G.setDamage(stack, Short.MAX_VALUE);
                hashedItems.add(GTUtility.ItemId.createNoCopy((ItemStack)stack));
            }
        } else if (item instanceof ArrayList) {
            for (ItemStack stack : (ArrayList)item) {
                ItemStack iCopy = stack.func_77946_l();
                iCopy.field_77990_d = null;
                hashedItems.add(GTUtility.ItemId.createNoCopy((ItemStack)iCopy));
                if (!includeWildcardVariants) continue;
                iCopy = iCopy.func_77946_l();
                Items.field_151008_G.setDamage(iCopy, Short.MAX_VALUE);
                hashedItems.add(GTUtility.ItemId.createNoCopy((ItemStack)iCopy));
            }
        } else {
            throw new IllegalArgumentException("Invalid input");
        }
        return hashedItems;
    }

    private static void removeRecipeShapelessDelayed(Object aOutput, Object ... aRecipe) {
        ArrayList<Object> aRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
        RecipeRemover.addToBuffer(RecipeRemover.getItemsHashed(aOutput, false), r -> {
            if (!(r instanceof ShapelessOreRecipe) && !(r instanceof ShapelessRecipes)) {
                return false;
            }
            if (aRecipeList.isEmpty()) {
                return true;
            }
            ArrayList recipe = (ArrayList)aRecipeList.clone();
            List rInputs = r instanceof ShapelessOreRecipe ? ((ShapelessOreRecipe)r).getInput() : ((ShapelessRecipes)r).field_77579_b;
            for (Object rInput : rInputs) {
                HashSet<GTUtility.ItemId> rInputHashedNoWildcard;
                HashSet<GTUtility.ItemId> rInputHashed;
                try {
                    rInputHashed = RecipeRemover.getItemsHashed(rInput, true);
                    rInputHashedNoWildcard = RecipeRemover.getItemsHashed(rInput, false);
                }
                catch (Exception ex) {
                    return false;
                }
                boolean found = false;
                Iterator iterator = recipe.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    for (GTUtility.ItemId id : RecipeRemover.getItemsHashed(o, false)) {
                        if (!rInputHashed.contains(id)) continue;
                        found = true;
                        iterator.remove();
                        break;
                    }
                    if (!found) {
                        for (GTUtility.ItemId id : RecipeRemover.getItemsHashed(o, true)) {
                            if (!rInputHashedNoWildcard.contains(id)) continue;
                            found = true;
                            iterator.remove();
                            break;
                        }
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                return false;
            }
            return recipe.isEmpty();
        });
    }

    private static void removeRecipeShapedDelayed(Object aOutput, Object[] row1, Object[] row2, Object[] row3) {
        if (recipeWidthField == null) {
            try {
                recipeWidthField = ShapedOreRecipe.class.getDeclaredField("width");
                recipeWidthField.setAccessible(true);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        Object[][] recipe = new Object[][]{row1, row2, row3};
        RecipeRemover.addToBuffer(RecipeRemover.getItemsHashed(aOutput, false), r -> {
            int width;
            if (!(r instanceof ShapedOreRecipe) && !(r instanceof ShapedRecipes)) {
                return false;
            }
            Object[] inputs = r instanceof ShapedOreRecipe ? ((ShapedOreRecipe)r).getInput() : ((ShapedRecipes)r).field_77574_d;
            try {
                width = r instanceof ShapedOreRecipe ? (Integer)recipeWidthField.get(r) : ((ShapedRecipes)r).field_77576_b;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            int height = r instanceof ShapedOreRecipe ? r.func_77570_a() / width : ((ShapedRecipes)r).field_77577_c;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    HashSet<GTUtility.ItemId> rInputHashed;
                    Object rRecipe;
                    Object rStack = y >= height || x >= width ? null : inputs[x + y * width];
                    if (rStack == null ^ (rRecipe = x >= recipe[y].length ? null : recipe[y][x]) == null) {
                        return false;
                    }
                    if (rStack == null) continue;
                    try {
                        rInputHashed = RecipeRemover.getItemsHashed(rStack, true);
                    }
                    catch (Exception ex) {
                        return false;
                    }
                    boolean found = false;
                    for (GTUtility.ItemId id : RecipeRemover.getItemsHashed(rRecipe, false)) {
                        if (!rInputHashed.contains(id)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        rInputHashed = RecipeRemover.getItemsHashed(rStack, false);
                        for (GTUtility.ItemId id : RecipeRemover.getItemsHashed(rRecipe, true)) {
                            if (!rInputHashed.contains(id)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    return false;
                }
            }
            return true;
        });
    }

    private static void removeRecipeShapedDelayed(Object aOutput) {
        RecipeRemover.addToBuffer(RecipeRemover.getItemsHashed(aOutput, false), r -> r instanceof ShapedOreRecipe || r instanceof ShapedRecipes);
    }

    private static void removeRecipeByOutputDelayed(Object aOutput) {
        RecipeRemover.addToBuffer(RecipeRemover.getItemsHashed(aOutput, false), r -> true);
    }

    /*
     * Opcode count of 23319 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void run() {
        bufferMap = new HashMap();
        long timeStart = System.currentTimeMillis();
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Sunnarium, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.Sunnarium, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadShovel, (Object)Materials.Sunnarium, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadUniversalSpade, (Object)Materials.Sunnarium, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.spring, (Object)Materials.Sunnarium, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.Sunnarium, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Backpack.ID, (String)"boundLeather", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"gravel", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"quartz_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"rawFilament", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.GalacticraftMars.ID, (String)"item.itemBasicAsteroids", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.GalacticraftMars.ID, (String)"tile.asteroidsBlock", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.GalacticraftCore.ID, (String)"item.meteoricIronRaw", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.GalacticraftMars.ID, (String)"item.null", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"chainmail_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockRubWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"slime_ball", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemMugCoffee", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemOreIridium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"obsidian", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"clay_ball", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"netherrack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)ItemList.Food_Raw_Bread.get(1L, new Object[0]));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"oreBerries", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"oreBerries", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"oreBerries", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"oreBerries", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"oreBerries", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"sand", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"soul_sand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Natura.ID, (String)"heatsand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Natura.ID, (String)"redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Natura.ID, (String)"redwood", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Natura.ID, (String)"redwood", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)57, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)58, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.ore", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)46, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)48, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCustomOre", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"gemOre", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreBasalt, (Object)Materials.Amber, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreRedgranite, (Object)Materials.Amber, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreEndstone, (Object)Materials.Amber, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)new ItemStack(GregTechAPI.sBlockOres1, 1, 514));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreMarble, (Object)Materials.Amber, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreBlackgranite, (Object)Materials.Amber, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.oreNetherrack, (Object)Materials.Amber, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemShard", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Obsidian, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Obsidian, (long)1L));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemDust", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemPlates", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"dust", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.GiantObsidian", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.beta", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemDensePlates", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)ItemList.Conveyor_Module_LV.get(1L, new Object[0]));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)36, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)ItemList.Automation_ItemDistributor_ULV.get(1L, new Object[0]));
        GTModHandler.removeFurnaceSmelting((ItemStack)ItemList.Automation_ItemDistributor_LV.get(1L, new Object[0]));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftedSoil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftedSoil", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)39, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)38, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedBrick", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GravelOre", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftedSoil", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftedSoil", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        GTModHandler.removeFurnaceSmelting((ItemStack)GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"item.ironwoodRaw", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AE2Stuff.ID, (String)"Encoder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AE2Stuff.ID, (String)"Grower", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AE2Stuff.ID, (String)"Inscriber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AE2Stuff.ID, (String)"Wireless", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AE2Stuff.ID, (String)"WirelessKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AE2Stuff.ID, (String)"Visualiser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"BlockMolecularTransformer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"advanced_solar_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"hybrid_solar_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"ultimate_solar_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AkashicTome.ID, (String)"tome", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Automagy.ID, (String)"blockHourglass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Double_Craft", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Triple_Craft", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Resource", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Dire_Crafting", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Crystal_Matrix", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Resource_Block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Resource_Block", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Resource", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Resource", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Resource", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Resource", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Avaritia.ID, (String)"Resource", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EternalSingularity.ID, (String)"combined_singularity", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Backpack.ID, (String)"backpack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Backpack.ID, (String)"workbenchbackpack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Backpack.ID, (String)"boundLeather", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BetterBuildersWands.ID, (String)"wandStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BetterBuildersWands.ID, (String)"wandIron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BetterBuildersWands.ID, (String)"wandDiamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BetterBuildersWands.ID, (String)"wandUnbreakable", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.QuestBook.ID, (String)"ItemQuestBook", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BinnieCore.ID, (String)"fieldKit", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"gemOre", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"gems", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"jarEmpty", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"dartBlower", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"dart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"scytheDiamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"ash", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"coal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"gems", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"gemOre", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"gemOre", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"gemOre", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_iron_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_planks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_stick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_stained_glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_stained_ice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_stained_ice_packed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_glowstone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_diamond_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_lamp", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"life_infuser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"lp_materializer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"compacter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_pickaxe_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_axe_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_shovel_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_sword_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_pickaxe_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_axe_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_shovel_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_sword_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_pickaxe_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_axe_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_shovel_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_infused_sword_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_burned_string", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_money", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_money", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_money", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"life_imbued_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"life_imbued_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"life_imbued_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"life_imbued_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"amorphic_catalyst", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"transparent_orb", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"sigil_of_augmented_holding", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"sigil_of_lightning", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"sigil_of_swimming", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"sigil_of_ender", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"sigil_of_divinity", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"self_sacrifice_amulet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"sacrifice_amulet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"empowered_sacrifice_amulet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"empowered_self_sacrifice_amulet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"glass_sacrificial_dagger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"glass_dagger_of_sacrifice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"vampire_ring", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"Altar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sacrificialKnife", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_stone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blankSlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrybloodRune", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockWritingTable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"waterSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"lavaSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"reinforcedSlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_stone", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"imbuedSlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_stone", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"demonicSlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_stone", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodArsenal.ID, (String)"blood_stone", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"divinationSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"speedRune", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"ritualStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"masterStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"largeBloodStoneBrick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockHomHeart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"lavaCrystal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"runeOfSacrifice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"runeOfSelfSacrifice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"airSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sigilOfTheFastMiner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"growthSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"voidSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemBloodPack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"emptySocket", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"armourForge", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrybloodRune", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrybloodRune", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sigilOfElementalAffinity", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sigilOfHolding", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sigilOfTheBridge", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sigilOfMagnetism", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemBloodLightSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"seerSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"imperfectRitualStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemRitualDiviner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemRitualDiviner", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemRitualDiviner", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"ritualDismantler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrybloodRune", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrybloodRune", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrybloodRune", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrybloodRune", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockTeleposer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"reinforcedTelepositionFocus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"demonicTelepositionFocus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"energyBazooka", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockPedestal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockPlinth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockAlchemicCalcinator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemAttunedCrystal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemDestinationClearer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemTankSegmenter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockCrystalBelljar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockReagentConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockCrystal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockStabilityGlyph", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockEnchantmentGlyph", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockEnchantmentGlyph", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)19, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)23, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicBaseItems", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemKeyOfDiablo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"armourInhibitor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"inputRoutingFocus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"outputRoutingFocus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"outputRoutingFocus", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"outputRoutingFocus", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"outputRoutingFocus", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"inputRoutingFocus", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sigilOfHaste", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sigilOfWind", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sigilOfSupression", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"sigilOfEnderSeverance", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemHarvestSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"itemCompressionSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockCrucible", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"blockConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"bloodMagicIncenseItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellParadigm", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellParadigm", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellParadigm", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellParadigm", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellModifier", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellModifier", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellModifier", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellModifier", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellEffect", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellEffect", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellEffect", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.BloodMagic.ID, (String)"AlchemicalWizardrytile.blockSpellEffect", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Botany.ID, (String)"trowelWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Botany.ID, (String)"trowelStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Botany.ID, (String)"trowelIron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Botany.ID, (String)"trowelGold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Botany.ID, (String)"trowelDiamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Botany.ID, (String)"insulatedTube", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Botany.ID, (String)"soilMeter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersCollapsibleBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"itemCarpentersChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"itemCarpentersHammer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersSafe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersDaylightSensor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"itemCarpentersBed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersTorch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersGarageDoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersLadder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersBarrier", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersPressurePlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersButton", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersFlowerPot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersHatch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersLever", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersSlope", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"blockCarpentersStairs", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"itemCarpentersTile", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CarpentersBlocks.ID, (String)"itemCarpentersDoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"support_column", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"sturdy_rail_powered", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"cagedLadder_north_unlit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"scaffold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"sturdy_rail_detector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"catwalk_unlit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"sturdy_rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"sturdy_rail_activator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"ropeLight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"steelgrate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CatWalks.ID, (String)"blowtorch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"chisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"obsidianChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"diamondChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"netherStarChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"cloudinabottle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"ballomoss", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"smashingrock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"autoChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"upgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"upgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"upgrade", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"upgrade", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Chisel.ID, (String)"voidstone2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"BlockCkg", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"IridiumBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.CompactKineticGenerators.ID, (String)"IridiumRotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.DraconicEvolution.ID, (String)"dissEnchanter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCosmeticSolid", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"DiamondChainsaw", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"FeatherWing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"EMTItems", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ElectroMagicTools.ID, (String)"Omnitool", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockStirlingGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockCombustionGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockZombieGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockFrankenzombieGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockEnderGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockSolarPanel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockSolarPanel", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockSolarPanel", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockSagMill", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockAlloySmelter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockCapBank", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockPainter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockCrafter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemBasicCapacitor", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMachinePart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockVat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockPowerMonitor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockFarmStation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockWirelessCharger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockTank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockTank", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockReservoir", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockVacuumChest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockTransceiver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockBuffer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockBuffer", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockBuffer", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockInventoryPanel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMachinePart", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBall", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBall", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBall", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBall", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBall", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBall", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBall", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBall", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBall", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBallEndergy", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBallEndergy", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBallEndergy", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBallEndergy", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBallEndergy", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBallEndergy", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGrindingBallEndergy", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.endSteel_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.endSteel_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.endSteel_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.endSteel_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.endSteel_pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.endSteel_axe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.endSteel_sword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockEnderIo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockTravelAnchor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockTelePad", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockSliceAndSplice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockSoulBinder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockPoweredSpawner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockKillerJoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockAttractor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockSpawnGuard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockExperienceObelisk", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockWeatherObelisk", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockEnchanter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockDarkSteelPressurePlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockDarkSteelPressurePlate", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockDarkSteelAnvil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockDarkIronBars", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockSoulariumBars", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockEndSteelBars", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockDarkSteelLadder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockElectricLight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockElectricLight", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockElectricLight", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockElectricLight", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockElectricLight", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockElectricLight", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"blockReinforcedObsidian", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemCoordSelector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemFusedQuartzFrame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemConduitFacade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemConduitFacade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemRedstoneConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemRedstoneConduit", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemRedstoneConduit", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduit", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduit", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerConduitEndergy", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemLiquidConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemLiquidConduit", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemLiquidConduit", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemLiquidConduit", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemLiquidConduit", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemLiquidConduit", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemLiquidConduit", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemItemConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemBasicFilterUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemBasicFilterUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemLimitedItemFilter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemExistingItemFilter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemModItemFilter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemBigFilterUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemBigFilterUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowerItemFilter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemExtractSpeedUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemExtractSpeedUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemFunctionUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemYetaWrench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemConduitProbe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemTravelStaff", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemXpTransfer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemSoulVessel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGliderWing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemGliderWing", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMagnet", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemOCConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMachinePart", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMachinePart", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)17, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.darkSteel_shears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.stellar_pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.stellar_axe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.stellar_sword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.stellar_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.stellar_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.stellar_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"item.stellar_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"alveary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"alveary", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"alveary", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"alveary", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"alveary", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"alveary", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"alveary", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"hiveFrame.cage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"hiveFrame.clay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"hiveFrame.cocoa", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"hiveFrame.soul", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"hiveFrame.clay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"hiveFrame.cocoa", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"hiveFrame.cage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraBees.ID, (String)"hiveFrame.soul", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"machine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"machine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"machine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"machine", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"machine", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"machine", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"machine", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"machine", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"misc", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"hammer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"durableHammer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"misc", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"misc", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"misc", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"misc", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"misc", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"misc", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"misc", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"misc", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"door", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"gate", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"fence", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraTrees.ID, (String)"multifence", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"angelRing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"angelRing", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"angelRing", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"angelRing", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"angelRing", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarry", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderThermicPump", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"endMarker", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"curtains", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"timer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderQuarryUpgrade", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"paintbrush", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"drum", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"drum", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"bedrockiumIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"block_bedrockium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"angelBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"conveyor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"filing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"filing", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"watering_can", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"magnumTorch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"sound_muffler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"sound_muffler", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"pipes", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"pipes", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"pipes", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"pipes", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"pipes.1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"pipes", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"pipes", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"pipes", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"pipes", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"extractor_base_remote", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"extractor_base_remote", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"extractor_base", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"extractor_base", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"extractor_base", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"extractor_base", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"cobblestone_compressed", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"trashcan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"trashcan", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"trashcan", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock2", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"dark_portal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"dark_portal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"chestFull", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"chestMini", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"enderCollector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"endConstructor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"endConstructor", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"budoff", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"budoff", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"chandelier", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"decorativeBlock1", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"trading_post", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"spike_base_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"spike_base", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"spike_base_gold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"spike_base_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"generator", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"generator.8", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"generator.64", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"heatingElement", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"nodeUpgrade", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"golden_lasso", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"scanner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"builderswand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"creativebuilderswand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"shears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"ethericsword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"lawSword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"erosionShovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"destructionpickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"defoliageAxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"temporalHoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"electricFloodlight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"carbonFloodlight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"smallElectricFloodlightMetaBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"smallElectricFloodlightMetaBlock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"uvFloodlight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"rawFilament", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"electricIncandescentLightBulb", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"carbonDissolver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"carbonLantern", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"mantle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.FloodLights.ID, (String)"growLight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"RidingCrop", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"WandCaps", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"sturdyMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"core", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"factory2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"mail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"mail", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"mulch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"engine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"ffarm", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"ffarm", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"ffarm", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"ffarm", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"ffarm", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"bronzePickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"kitPickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"bronzeShovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"kitShovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"infuser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"canEmpty", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"waxCapsule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"refractoryEmpty", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"gearBronze", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"gearCopper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"gearTin", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"stamps", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"stamps", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"stamps", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"stamps", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"stamps", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"stamps", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"stamps", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"wrench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"pipette", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"naturalistHelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"soil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"soil", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"craftingMaterial", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"fertilizerBio", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"fertilizerCompound", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"bituminousPeat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"habitatLocator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"scoop", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"frameUntreated", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"frameImpregnated", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"waxCast", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"apiaristHelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"apiaristChest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"apiaristLegs", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"apiaristBoots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"candle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"honeyedSlice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"ambrosia", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"honeyPot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"letters", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"fencesFireproof", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"catalogue", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"apiaristBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"lepidopteristBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"minerBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"diggerBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"foresterBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"hunterBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"adventurerBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"builderBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"coinBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"apiculture", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"apiculture", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"apicultureChest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"alveary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"alveary", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"alveary", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"alveary", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"alveary", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"alveary", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"alveary", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"arboriculture", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"lepidopterology", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"fences", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Forestry.ID, (String)"cart.beehouse", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GregtechItemList.GT4_Thermal_Boiler.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(new ItemStack(ModItems.itemPersonalCloakingDevice));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Electric_Motor_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Electric_Pump_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Conveyor_Module_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Electric_Piston_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Robot_Arm_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Emitter_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Sensor_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Field_Generator_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(GregtechItemList.Industrial_WireFactory.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(GregtechItemList.Boiler_Advanced_LV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(new ItemStack(ModItems.itemBoilerChassis, 1, 0));
        RecipeRemover.removeRecipeByOutputDelayed(GregtechItemList.Boiler_Advanced_MV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(new ItemStack(ModItems.itemBoilerChassis, 1, 1));
        RecipeRemover.removeRecipeByOutputDelayed(GregtechItemList.Boiler_Advanced_HV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(new ItemStack(ModItems.itemBoilerChassis, 1, 2));
        RecipeRemover.removeRecipeByOutputDelayed(GregtechItemList.GTFluidTank_HV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(new ItemStack(ModBlocks.blockCompressedObsidian, 1, 5));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"IndustrialApiary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"MutagenProducer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"Mutatron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"Imprinter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"Sampler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"MutatronAdv", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"Liquifier", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"Extractor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"Transposer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"Replicator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"UpgradeFrame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"Labware", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"MutagenTank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"BeeReceptacle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"PowerModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"GeneticsProcessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"EnvProcessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"ApiaryUpgrade", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"IndustrialGrafter", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"IndustrialScoop", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"MutagenTank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"BeeReceptacle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"PowerModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"ClimateModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"GeneticsProcessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"EnvProcessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"EjectCover", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"ImportCover", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"ErrorSensorCover", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"machine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"machine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"machine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"machine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"labMachine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"labMachine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"labMachine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"labMachine", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"labMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"advMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"misc", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"analyst", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Genetics.ID, (String)"registry", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"itemSimpleItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"itemSimpleItem", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"itemSimpleItem", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"itemSimpleItem", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"itemSimpleItem", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"vajra", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"itemSimpleItem", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"advChainsaw", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"advDDrill", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"graviTool", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuite.ID, (String)"ultimateLappack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.GraviSuiteNEO.ID, (String)"epicLappack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSword, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadPickaxe, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadShovel, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadAxe, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadHoe, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRTGPellet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemOreIridium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Teleporter.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"altar_nexus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"essence_altar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"void_chest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"endium_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"biome_compass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"endium_ingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"obsidian_rod", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"ravaged_brick_slab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"decomposition_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"experience_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"energy_extraction_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"accumulation_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"spectral_tear", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"living_matter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"energy_wand_core", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"energy_wand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"spooky_log", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"spooky_leaves", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"blank_gem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"spatial_dash_gem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"transference_gem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"schorching_pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"charm_pouch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)256, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)257, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)258, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)259, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)260, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)261, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)262, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)263, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)264, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)265, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.HardcoreEnderExpansion.ID, (String)"curse", (long)1L, (int)266, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"sink", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"market", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"spamcompressedsaltBlockalt", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"oven", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"mixingbowlItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"cuttingboardItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"mortarandpestleItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"bakewareItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"juicerItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"apiary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"mortarandpestleItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"potItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"presser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"skilletItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"saucepanItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"hardenedleatherItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"hardenedleatherhelmItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"hardenedleatherchestItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"hardenedleatherleggingsItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"hardenedleatherbootsItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"waxItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco3", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco4", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco5", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco6", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco7", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco8", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco9", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco10", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco11", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco12", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco13", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco14", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco15", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco16", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcandleDeco16", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"churn", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"quern", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"freshwaterItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"freshmilkItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"boiledeggItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"onionsoupItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"honeycombchocolatebarItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"netherPlanks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"netherbedItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"Quartz Sword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"Quartz Shovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"Quartz Pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"Quartz Axe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"Quartz Hoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"quartzhelmItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"quartzchestItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"quartzleggingsItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"quartzbootsItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockGenerator", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockHeatGenerator", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockGenerator", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockKineticGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockKineticGenerator", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockKineticGenerator", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockReactorChamber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockHeatGenerator", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockGenerator", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockElectric", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockElectric", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockElectric", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockElectric", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockElectric", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockElectric", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockElectric", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockElectric", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockScaffold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockIronScaffold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMetal", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolMiningLaser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockITNT", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorPlating", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorPlatingHeat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorPlatingExplosive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolCutter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemCable", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemCable", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemCable", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemCable", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemPartCoalChunk", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemPartCarbonMesh", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockAlloyGlass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolIridiumDrill", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolWrenchElectric", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"windmeter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemwoodrotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemironrotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemsteelrotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemwcarbonrotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolWrench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemupgradekit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemFluidCell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorReflector", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorReflectorThick", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorVent", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorVentCore", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorVentGold", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorVentDiamond", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorVentSpread", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorHeatSwitch", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorHeatSwitchCore", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorHeatSwitchSpread", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorHeatSwitchDiamond", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorCondensator", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorCondensatorLap", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTreetap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockRubber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemSteamTurbineBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemSteamTurbine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemIronBlockCuttingBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemAdvIronBlockCuttingBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemDiamondBlockCuttingBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemBarrel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemMugEmpty", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemMugCoffee", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemMugCoffee", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemMugCoffee", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemBoat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemBoat", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemBoat", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemDynamiteSticky", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemDynamite", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemWeedingTrowel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemCropnalyzer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolMEter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemFuelPlantBall", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemScrapbox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemPartCoalBall", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemPartCFPowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemDoorAlloy", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterBlack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterRed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterGreen", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterBrown", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterBlue", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterPurple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterCyan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterLightGrey", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterDarkGrey", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterPink", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterLime", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterYellow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterCloud", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterMagenta", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterOrange", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolPainterWhite", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemBatSU", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRemote", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemFreq", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"upgradeModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"upgradeModule", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"upgradeModule", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"upgradeModule", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"upgradeModule", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"upgradeModule", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"upgradeModule", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTFBP", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTFBPCultivation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTFBPIrrigation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTFBPChilling", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTFBPDesertification", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTFBPFlatification", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTFBPMushroom", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemArmorHazmatHelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemArmorHazmatChestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemArmorHazmatLeggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemArmorHazmatLeggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorCoolantSimple", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorCoolantTriple", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"reactorCoolantSix", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemArmorRubBoots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemStaticBoots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockGenerator", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockKineticGenerator", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockKineticGenerator", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockKineticGenerator", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockGenerator", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockHeatGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockHeatGenerator", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockGenerator", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockPersonal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockCrop", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemFoamSprayer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemArmorCFPack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemArmorAlloyChestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemNanoSaber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"obscurator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemScanner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemScannerAdv", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemOreIridium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemPlutonium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemUran235small", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemUran235", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemLathingTool", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTurningBlanksWood", (long)1L, (int)209715, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemTurningBlanks", (long)1L, (int)349525, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemContainmentbox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemToolbox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemPlutoniumSmall", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemMOX", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemUran", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemRecipePart", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockNuke", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockLuminatorDark", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockLuminator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine3", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockPersonal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockPersonal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine3", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine3", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine3", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine3", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine3", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMachine", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockChargepad", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockChargepad", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockChargepad", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockChargepad", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockreactorvessel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockReactorFluidPort", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockReactorAccessHatch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockReactorRedstonePort", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockMiningPipe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockGenerator", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadAxe, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadHoe, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSense, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadPickaxe, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadPlow, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSword, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSaw, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadShovel, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemBatLamaCrystal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemDust2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemPartCFPowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"backpack.thaumaturgeT1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"capsule.magic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"capsule.void", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)17, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"effectJar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"magicApiary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"frameMagic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"frameResilient", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"frameGentle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"frameMetabolic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"frameNecrotic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"frameTemporal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"frameOblivion", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"miscResources", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"moonDial", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"magnet", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"magicbees.enchantedEarth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"iron_trapdoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"sliding_trapdoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"player_sensor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"vanishing_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"vanishing_block", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"vanishing_block", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"vanishing_block", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"block_mixer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"door_factory", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"rustyHatch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"garage_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.rustyHandle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"rustyLadder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.door_acacia", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.door_birch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.door_dark_oak", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.door_jungle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.door_spruce", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.wood_sliding_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.iron_sliding_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.jail_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.laboratory_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.factory_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.shoji_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_purple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_yellow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_magenta", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_pink", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_white", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_blue", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_gray", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_cyan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_red", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_brown", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_lime", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_orange", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_silver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_green", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_light_blue", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.curtain_black", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.saloon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"item.forcefieldItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"acaciaFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"birchFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"darkOakFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"jungleFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"spruceFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"trapdoor_acacia", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"trapdoor_birch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"trapdoor_dark_oak", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"trapdoor_jungle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MalisisDoors.ID, (String)"trapdoor_spruce", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersMechworks.ID, (String)"RedstoneMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersMechworks.ID, (String)"RedstoneMachine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersMechworks.ID, (String)"RedstoneMachine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersMechworks.ID, (String)"RedstoneMachine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersMechworks.ID, (String)"SignalBus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersMechworks.ID, (String)"SignalTerminal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersMechworks.ID, (String)"LengthWire", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersMechworks.ID, (String)"SpoolWire", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"chest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"trapped_chest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"crafting_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"furnace", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"bedrock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dispenser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dropper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"piston", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"sticky_piston", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"golden_rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"detector_rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"activator_rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"noteblock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"jukebox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"bookshelf", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"mossy_cobblestone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stonebrick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"lit_pumpkin", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"trapdoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_pressure_plate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"torch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"lever", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_button", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"glass_pane", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"redstone_torch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"ladder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"fence", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"fence_gate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"enchanting_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"redstone_lamp", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"ender_chest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"tripwire_hook", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"beacon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"anvil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"daylight_detector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"hopper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"book", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"bow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"brick_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wooden_pressure_plate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"saddle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wool", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_glass_pane", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"carpet", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stained_hardened_clay", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"sandstone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"sandstone", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"sandstone", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"tnt", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"snow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"clay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"nether_brick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"quartz_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"quartz_block", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"bookshelf", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"brewing_stand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"clock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"compass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond_sword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond_shovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond_pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond_axe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond_hoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"ender_eye", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"golden_apple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"golden_apple", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"golden_carrot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"cake", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"pumpkin_seeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"melon_seeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"fermented_spider_eye", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"magma_cream", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"fire_charge", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"melon_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"soul_sand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"nether_brick_fence", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"name_tag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"lead", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"pumpkin_pie", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"comparator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"repeater", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"skull", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"skull", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"skull", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"flower_pot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"hay_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wheat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"slime_ball", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"item_frame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"bed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"fishing_rod", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"poisonous_potato", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"sign", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"boat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"painting", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"flint_and_steel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dragon_egg", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"map", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wooden_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"iron_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"skull", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"shears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"nether_star", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wooden_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"iron_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"planks", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"natura.stick", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"Natura.workbench", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"natura.flintandblaze", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"Natura.bookshelf", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"Natura.fence", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"plankSlab1", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"plankSlab2", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.eucalyptus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.sakura", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.hopseed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.maple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.amaranth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.silverbell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.tiger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.willow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"pressureplate.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"NetherPressurePlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.eucalyptus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.sakura", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.hopseed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.maple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.amaranth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.silverbell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.tiger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.willow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"trapdoor.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.eucalyptus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.sakura", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.hopseed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.maple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.amaranth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.silverbell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.tiger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.willow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"button.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.eucalyptus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.sakura", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.hopseed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.maple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.amaranth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.silverbell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.tiger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.willow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"fenceGate.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"natura.emptybowl", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"redwoodDoorItem", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"blackberryItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"blueberryItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"raspberryItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"Blazerail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"BrailPowered", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"BrailDetector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"BrailActivator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"NetherFurnace", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"Obelisk", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"NetherButton", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"NetherLever", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"natura.bow.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"natura.bow.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"natura.bow.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"natura.bow.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlMain", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlLight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"blockNuclearControlLight", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemToolThermometer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemToolDigitalThermometer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemRemoteSensorKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemEnergySensorKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemMultipleSensorKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemMultipleSensorKit", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemMultipleSensorKit", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"KitAppeng", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemTimeCard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemTextCard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"networkLink", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"remoteMonitor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.IC2NuclearControl.ID, (String)"ItemVanilliaKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"hangglider", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"luggage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"autoenchantmenttable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"autoanvil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"xpdrain", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"path", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"fan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"elevator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"elevator_rotating", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"vacuumhopper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"sprinkler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"guide", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"builder_guide", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"blockPlacer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"blockbreaker", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"itemDropper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"sleepingBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"ropeladder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"ladder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"beartrap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"cannon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"sponge", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"goldenegg", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"village_highlighter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"sky", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"sky", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"projector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"paintmixer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"canvas", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"xpbottler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"drawingtable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"imaginary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"imaginary", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"xpshower", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"scaffolding", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"craneControl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"craneBackpack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"emptyMap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"generic", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"cartographer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"slimalyzer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"sonicglasses", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"devnull", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"pedometer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"tastyClay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"cursor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenGlasses.ID, (String)"openglassesterminal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenGlasses.ID, (String)"openglasses", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"baseTierWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"baseTierOneBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"baseTierTwoBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"baseTierThreeBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"baseTierFourBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"sensorTierOneItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"sensorTierTwoItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"sensorTierThreeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"sensorTierFiveItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"sensorTierFourItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"chamberTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"chamberTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"chamberTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"chamberTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"chamberTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"barrelTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"barrelTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"barrelTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"barrelTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"barrelTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"disposeItemTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"potatoCannonTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"machineGunTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"incendiaryTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"grenadeTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"relativisticTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"rocketTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"teleporterTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"railGunTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"laserTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"hardWallTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"hardWallTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"hardWallTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"hardWallTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"hardWallTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"fenceTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"fenceTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"fenceTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"fenceTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"fenceTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"ioBus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderPowerTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderPowerTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderPowerTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderPowerTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderPowerTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderInvTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderInvTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderInvTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderInvTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"expanderInvTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"leverBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"bulletCraftable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"blazingClayCraftable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"grenadeCraftable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"rocketCraftable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"ferroSlug", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"accuraccyUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"fireRateUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"rangeUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"scattershotUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"efficiencyUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"damageAmpAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"solarPanelAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"serialPortAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"concealerAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"recyclerAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"potentiaAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.OpenModularTurrets.ID, (String)"redstoneReactorAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine1", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.solar_panel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.battery", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)56, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.stone", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.backpack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.barrel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransmission.ID, (String)"projectred.transmission.wire", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.sawgold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.sawruby", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.sawsapphire", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.sawperidot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.rubyboots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.rubychestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.rubyhelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.rubyleggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.sapphireboots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.sapphirechestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.sapphirehelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.sapphireleggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.peridotboots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.peridotchestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.peridothelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExploration.ID, (String)"projectred.exploration.peridotleggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)57, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)58, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.jetpack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)19, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)23, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)28, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)29, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)30, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)33, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)34, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.part", (long)1L, (int)44, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.screwdriver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.wiredebugger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedCore.ID, (String)"projectred.core.datacard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.electric_screwdriver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.pipe", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routingchip", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routingchip", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routingchip", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routingchip", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routingchip", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routingchip", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routingchip", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routingchip", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routingchip", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedTransportation.ID, (String)"projectred.transportation.routerutil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedFabrication.ID, (String)"projectred.integration.icblock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedFabrication.ID, (String)"projectred.integration.icblock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedFabrication.ID, (String)"projectred.fabrication.icblueprint", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedFabrication.ID, (String)"projectred.fabrication.icchip", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.MCFrames.ID, (String)"mcframes.frame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.machine2", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ProjectRedExpansion.ID, (String)"projectred.expansion.plan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"stair", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"stair", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"stair", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"stair", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"stair", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"stair", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"stair", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.stone", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.metal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.metal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.metal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.metal", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.metal", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"lantern.metal", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cube", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"fuel.coke", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cube", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"slab", (long)1L, (int)38, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cube", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"slab", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"anvil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"track", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"track.elevator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"signal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"part.railbed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"part.railbed", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"part.rail", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"part.tie", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"detector", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.epsilon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.epsilon", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.epsilon", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.epsilon", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"post", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"post", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"post", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"post", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"post", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"part.signal.lamp", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"part.gear", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"part.gear", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"part.gear", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"part.gear", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.alpha", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"brick.sandy", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"backpack.trackman.t1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"backpack.iceman.t1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"backpack.apothecary.t1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"frame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"tool.steel.shears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"brick.infernal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"upgrade.lapotron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.cargo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.track.relayer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.undercutter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.track.layer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.track.remover", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"firestone.cut", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"firestone.refined", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.redstone.flux", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"machine.gamma", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"brick.bloodstained", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"onlineDetector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"moonSensor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"bloodMoonSensor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"lapisLamp", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"imbuingStation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"energyDistributor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"enderEnergyDistributor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"itemCollector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"advancedItemCollector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"dyeingMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"playerinterface", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"filter", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"ingredient", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"fertilizedDirt", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"fluidDisplay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"advancedFluidDisplay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"wirelessLever", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"voidStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"dropFilter", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RandomThings.ID, (String)"spectreKey", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"tile.remote_interface", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"tile.machine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"tile.machine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"skylight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"intelligentWorkbench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"item.wireless_transmitter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"item.chip.location", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"item.io_tool", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"item.blank_plate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"item.chip.transfer", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"item.chip.upgrade", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"item.pda", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"item.remoteAccessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.RemoteIO.ID, (String)"item.linker", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"stargateRing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"stargateRing", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"stargateBase", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"stargateController", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"naquadahBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"naquadahOre", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"ic2PowerUnit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"rfPowerUnit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"ocInterface", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"naquadahIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"naquadah", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"sgChevronUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"sgIrisUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"sgIrisBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.SGCraft.ID, (String)"ic2Capacitor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockCartAssembler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockCargoManager", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockDistributor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockDetector", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockActivator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockDetector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockDetector", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockDetector", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockDetector", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockAdvDetector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockJunction", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockMetalStorage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockMetalStorage", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockMetalStorage", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)47, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)49, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)23, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)82, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)37, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)38, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)39, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)81, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)80, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)81, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)83, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)84, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)44, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)45, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)56, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)69, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)70, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)44, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)58, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)30, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)34, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)35, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)36, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)37, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)38, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)39, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)84, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)79, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)80, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)61, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)62, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)63, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)28, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)23, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)51, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)52, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)53, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)58, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)88, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"BlockLiquidManager", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)29, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)48, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)33, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)59, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)17, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"upgrade", (long)1L, (int)19, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)101, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)65, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)64, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)30, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)71, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)87, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)92, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)91, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)93, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)28, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)29, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)33, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)34, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)59, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)36, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)60, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)57, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)49, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)85, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)68, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)95, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)19, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)75, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)77, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)78, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)82, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)83, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)86, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)89, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)94, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"CartModule", (long)1L, (int)99, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesCarts2.ID, (String)"ModuleComponents", (long)1L, (int)17, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesAddons.ID, (String)"cable_rf", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesAddons.ID, (String)"cable_ae", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesAddons.ID, (String)"duplicator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.StevesAddons.ID, (String)"labeler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TaintedMagic.ID, (String)"ItemShadowmetalHoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TaintedMagic.ID, (String)"ItemShadowmetalPick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TaintedMagic.ID, (String)"ItemShadowmetalAxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TaintedMagic.ID, (String)"ItemShadowmetalSpade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TaintedMagic.ID, (String)"ItemShadowmetalSword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCrystal", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCosmeticOpaque", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCosmeticOpaque", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"WandCap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"WandCasting", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemResource", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCosmeticSolid", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCandle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemNugget", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemResource", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemThaumometer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockTable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemBaubleBlanks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemBaubleBlanks", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemBaubleBlanks", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCosmeticSolid", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockMetalDevice", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCosmeticSlabStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockTaint", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemResource", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemNugget", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemAxeVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemSwordVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemPickVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemShovelVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemHoeVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemHelmetVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemChestplateVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemLeggingsVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemBootsVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"voidFAS", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"voidShears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"quicksilverBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"wireless.essentia.terminal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"part.base", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"part.base", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.casing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"storage.essentia", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicEnergistics.ID, (String)"thaumicenergistics.block.essentia.cell.workbench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicExploration.ID, (String)"blankSeal", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicTinkerer.ID, (String)"shareBook", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicTinkerer.ID, (String)"darkQuartzItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicTinkerer.ID, (String)"darkQuartz", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicTinkerer.ID, (String)"darkQuartz", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicTinkerer.ID, (String)"darkQuartz", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicTinkerer.ID, (String)"darkQuartzSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.ThaumicTinkerer.ID, (String)"kamiResource", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MetalBlock", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"slime.gel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"slime.gel", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"LavaTank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"LavaTankNether", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Smeltery", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SmelteryNether", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPane", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"helmetWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"chestplateWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"leggingsWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"bootsWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Smeltery", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SmelteryNether", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Smeltery", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SmelteryNether", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Smeltery", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SmelteryNether", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Smeltery", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SmelteryNether", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedBlock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedBlock", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedBlock", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedBlock", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedBlock", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickfancy", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickmetal", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickmetal", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickmetal", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.multibrickmetal", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"heartCanister", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftedSoil", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftedSoil", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"toolRod", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"blankPattern", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"decoration.stoneladder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"trap.punji", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"MeatBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"WoolSlab1", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"WoolSlab2", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftedSoil", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedSlab", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedSlab", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedSlab", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedSlab", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedSlab", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedSlab", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedSlab", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Smeltery", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SmelteryNether", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Smeltery", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SmelteryNether", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedBlockNether", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedBlock", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedBlockNether", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CastingChannel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CastingChannel", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedBlock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SearedBlockNether", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"LavaTank", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"LavaTankNether", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"LavaTank", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"LavaTankNether", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassBlock.StainedClear", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)28, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)29, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)30, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"GlassPaneClearStained", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"knapsack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"travelGoggles", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"travelVest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"travelGlove", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"travelWings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"travelBelt", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"travelBoots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"trap.barricade.oak", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"trap.barricade.spruce", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"trap.barricade.birch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"trap.barricade.jungle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"explosive.slime", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"slime.channel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"blood.channel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"slime.pad", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"rail.wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftingStation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftingSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"ToolStationBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftingSlab", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"ToolStationBlock", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftingSlab", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftingSlab", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftingSlab", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"ToolForgeBlock", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftingSlab", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"FurnaceSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftedSoil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"CraftedSoil", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedSlab", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedSlab", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedSlab", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedSlab", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedSlab", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedSlab", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"SpeedSlab", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"strangeFood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"goldHead", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Armor.DryingRack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"diamondApple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"heartCanister", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"heartCanister", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"heartCanister", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Redstone.Landmine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Redstone.Landmine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Redstone.Landmine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"Redstone.Landmine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersDefence.ID, (String)"AeonSteelIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersDefence.ID, (String)"AeonSteelBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersDefence.ID, (String)"QueensGoldIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersDefence.ID, (String)"QueensGoldBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersDefence.ID, (String)"DogbeariumIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TinkersDefence.ID, (String)"DogbeariumBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"item.carminite", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFTowerDevice", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"item.emptyMagicMap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"item.ironwoodRaw", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFUncraftingTable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        String[] materials = new String[]{"Twilight", "Canopy", "Mangrove", "Darkwood", "Time", "Trans", "Mine", "Sort"};
        for (int i = 0; i < materials.length; ++i) {
            RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)("tile.TFTrapDoor" + materials[i]), (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
            RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)("item.door" + materials[i]), (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        }
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBECore.ID, (String)"obsidianStick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBECore.ID, (String)"stoneBowl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBECore.ID, (String)"retherPearl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBECore.ID, (String)"wirelessTransceiver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBECore.ID, (String)"blazeTransceiver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBECore.ID, (String)"recieverDish", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBECore.ID, (String)"blazeRecieverDish", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBELogic.ID, (String)"wirelessLogic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBELogic.ID, (String)"wirelessLogic", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBELogic.ID, (String)"wirelessLogic", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBEAddons.ID, (String)"triangulator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBEAddons.ID, (String)"remote", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBEAddons.ID, (String)"sniffer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBEAddons.ID, (String)"map", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBEAddons.ID, (String)"tracker", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBEAddons.ID, (String)"rep", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.WirelessRedstoneCBEAddons.ID, (String)"psniffer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchesovenidle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"fumefunnel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"filteredfumefunnel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)73, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"altar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"kettle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"arthana", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)153, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"spinningwheel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"distilleryidle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)140, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)81, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)106, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)127, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)46, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)107, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"cauldronbook", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)47, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)48, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)49, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"chalkritual", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"circletalisman", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"earmuffs", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)92, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"rubyslippers", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"snowpressureplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed("nuggetLead");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetSilver");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetTin");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetCopper");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetSteel");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetPulsatingIron");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetVibrantAlloy");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetDraconium");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetDraconiumAwakened");
        RecipeRemover.removeRecipeByOutputDelayed("blockObsidian");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetGold");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetIron");
        RecipeRemover.removeRecipeByOutputDelayed("torchStone");
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Ruby, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Sapphire, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dye", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dye", (long)3L, (int)15, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"bones", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dye", (long)6L, (int)15, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"bones", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dye", (long)12L, (int)15, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"bones", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"misc", (long)1L, (int)9, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"flowers", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"misc", (long)1L, (int)8, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"flowers", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"misc", (long)1L, (int)8, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"flowers2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"misc", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"flowers2", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"misc", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"mushrooms", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"misc", (long)1L, (int)7, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"moss", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"misc", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"mushrooms", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"misc", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"plants", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Ruby, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Sapphire, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dye", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Apatite, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Apatite, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Diamond, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Sapphire, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Wheat, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.NetherStar, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Iridium, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Saltpeter, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustEnderPearl", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemEnderPearl", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustEnderEye", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemEnderEye", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustRuby", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemRuby", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustSapphire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemSapphire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustGreenSapphire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemGreenSapphire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustOlivine", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemOlivine", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustTopaz", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemTopaz", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustTanzanite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemTanzanite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustAmethyst", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemAmethyst", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustJasper", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemJasper", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustGarnetYellow", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemGarnetYellow", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustGarnetRed", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemGarnetRed", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustForce", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemForce", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustForcillium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemForcillium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustForcicium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemForcicium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustDilithium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemDilithium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustAmber", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemAmber", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustFoolsRuby", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemFoolsRuby", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustBlueTopaz", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemBlueTopaz", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustMonazite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemMonazite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustQuartzite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemQuartzite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustLazurite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemLazurite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustSodalite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemSodalite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustNiter", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemNiter", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustTricalciumPhosphate", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemTricalciumPhosphate", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustLignite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemLignite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedEntropy", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedEntropy", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedOrder", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedOrder", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustVinteum", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemVinteum", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedAir", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedAir", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedFire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedFire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedEarth", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedEarth", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedWater", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedWater", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustCoal", "blockCoal");
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"coal", (long)9L, (int)1, (ItemStack)IScriptLoader.missing), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.block, (Object)Materials.Charcoal, (long)1L));
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Charcoal, (long)9L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.block, (Object)Materials.Charcoal, (long)1L));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"cottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemCofeePowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemCofeeBeans", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemShard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemShard", (long)1L, (int)1, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemShard", (long)1L, (int)2, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemShard", (long)1L, (int)3, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemShard", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemShard", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"string", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Lapis, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Emerald, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"gunpowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"coal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"coal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"coal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"glowstone_dust", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dye", (long)3L, (int)15, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"bone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"nether_star", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"sand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"glowstone_dust", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)8, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Natura.ID, (String)"Bluebells", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemResource", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemInkwell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"glass_bottle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"feather", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), "dyeBlack");
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"item.fieryIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)130, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)130, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"magma_cream", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"blaze_powder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed("ingotThauminite", GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.BinnieCore.ID, (String)"storage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.BinnieCore.ID, (String)"storage", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.BinnieCore.ID, (String)"storage", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.BinnieCore.ID, (String)"storage", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.BinnieCore.ID, (String)"storage", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.BinnieCore.ID, (String)"storage", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wheat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"plants", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"plants", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"plants", (long)1L, (int)6, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemAlloy", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), new Object[]{"nuggetDarkSteel", "nuggetDarkSteel", "nuggetDarkSteel"}, new Object[]{"nuggetDarkSteel", "nuggetDarkSteel", "nuggetDarkSteel"}, new Object[]{"nuggetDarkSteel", "nuggetDarkSteel", "nuggetDarkSteel"});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemAlloy", (long)1L, (int)8, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"ender_pearl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderIO.ID, (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"ender_pearl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{null, GTModHandler.getModItem((String)Mods.EnderZoo.ID, (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null}, new Object[]{GTModHandler.getModItem((String)Mods.EnderZoo.ID, (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderZoo.ID, (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.EnderZoo.ID, (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{null, GTModHandler.getModItem((String)Mods.EnderZoo.ID, (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"unstableingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"iron_ingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.ExtraUtilities.ID, (String)"divisionSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)9L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"emerald", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)2L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"GeneSampleBlank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Gendustry.ID, (String)"GeneTemplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Apatite, (long)1L), new Object[]{GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)7), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)7), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)7)}, new Object[]{GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)7), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)7), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)7)}, new Object[]{GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)7), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)7), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)7)});
        RecipeRemover.removeRecipeShapedDelayed("ingotSilver", new Object[]{"nuggetSilver", "nuggetSilver", "nuggetSilver"}, new Object[]{"nuggetSilver", "nuggetSilver", "nuggetSilver"}, new Object[]{"nuggetSilver", "nuggetSilver", "nuggetSilver"});
        RecipeRemover.removeRecipeShapedDelayed("ingotLead", new Object[]{"nuggetLead", "nuggetLead", "nuggetLead"}, new Object[]{"nuggetLead", "nuggetLead", "nuggetLead"}, new Object[]{"nuggetLead", "nuggetLead", "nuggetLead"});
        RecipeRemover.removeRecipeShapedDelayed("ingotDraconium", new Object[]{"nuggetDraconium", "nuggetDraconium", "nuggetDraconium"}, new Object[]{"nuggetDraconium", "nuggetDraconium", "nuggetDraconium"}, new Object[]{"nuggetDraconium", "nuggetDraconium", "nuggetDraconium"});
        RecipeRemover.removeRecipeShapedDelayed("ingotDraconiumAwakened", new Object[]{"nuggetDraconiumAwakened", "nuggetDraconiumAwakened", "nuggetDraconiumAwakened"}, new Object[]{"nuggetDraconiumAwakened", "nuggetDraconiumAwakened", "nuggetDraconiumAwakened"}, new Object[]{"nuggetDraconiumAwakened", "nuggetDraconiumAwakened", "nuggetDraconiumAwakened"});
        RecipeRemover.removeRecipeShapedDelayed("ingotVibrantAlloy", new Object[]{"nuggetVibrantAlloy", "nuggetVibrantAlloy", "nuggetVibrantAlloy"}, new Object[]{"nuggetVibrantAlloy", "nuggetVibrantAlloy", "nuggetVibrantAlloy"}, new Object[]{"nuggetVibrantAlloy", "nuggetVibrantAlloy", "nuggetVibrantAlloy"});
        RecipeRemover.removeRecipeShapedDelayed("ingotPulsatingIron", new Object[]{"nuggetPulsatingIron", "nuggetPulsatingIron", "nuggetPulsatingIron"}, new Object[]{"nuggetPulsatingIron", "nuggetPulsatingIron", "nuggetPulsatingIron"}, new Object[]{"nuggetPulsatingIron", "nuggetPulsatingIron", "nuggetPulsatingIron"});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_button", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"string", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{"cropCotton", "cropCotton", "cropCotton"}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"speckled_melon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_slab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_slab", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_slab", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_slab", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_slab", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_slab", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"stone_slab", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"bookshelf", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"packed_ice", (long)4L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"gunpowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), null}, new Object[]{GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), null}, new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"chest_minecart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"furnace_minecart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"hopper_minecart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"tnt_minecart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"iron_ingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{"nuggetIron", "nuggetIron", "nuggetIron"}, new Object[]{"nuggetIron", "nuggetIron", "nuggetIron"}, new Object[]{"nuggetIron", "nuggetIron", "nuggetIron"});
        RecipeRemover.removeRecipeShapedDelayed("nuggetIron");
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"gold_ingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{"nuggetGold", "nuggetGold", "nuggetGold"}, new Object[]{"nuggetGold", "nuggetGold", "nuggetGold"}, new Object[]{"nuggetGold", "nuggetGold", "nuggetGold"});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"wooden_slab", (long)6L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"planks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"planks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"planks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"blaze_powder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCustomPlant", (long)1L, (int)3, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"leather_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"leather_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"leather_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"leather_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"emerald", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.MagicBees.ID, (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"paper", (long)2L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"reeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"reeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"reeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"sand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"leather", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)6, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.Natura.ID, (String)"barleyFood", (long)1L, (int)6, (ItemStack)IScriptLoader.missing)}, new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"paintBrush", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.OpenBlocks.ID, (String)"goldenEye", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.energy.batbox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.energy.cesu", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.energy.mfe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.tank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.anchor.personal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.anchor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"cart.work", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"tool.electric.meter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"armor.goggles", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"tool.magnifying.glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"tool.signal.tuner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Railcraft.ID, (String)"tool.surveyor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemResource", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCosmeticOpaque", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"ItemResource", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), new Object[]{GTModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCosmeticOpaque", (long)1L, (int)1, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed("ingotThaumium", new Object[]{"nuggetThaumium", "nuggetThaumium", "nuggetThaumium"}, new Object[]{"nuggetThaumium", "nuggetThaumium", "nuggetThaumium"}, new Object[]{"nuggetThaumium", "nuggetThaumium", "nuggetThaumium"});
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"crystalSlab", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GTModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genericSlab", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed("ingotTin", new Object[]{"nuggetTin", "nuggetTin", "nuggetTin"}, new Object[]{"nuggetTin", "nuggetTin", "nuggetTin"}, new Object[]{"nuggetTin", "nuggetTin", "nuggetTin"});
        RecipeRemover.removeRecipeShapedDelayed("ingotCopper", new Object[]{"nuggetCopper", "nuggetCopper", "nuggetCopper"}, new Object[]{"nuggetCopper", "nuggetCopper", "nuggetCopper"}, new Object[]{"nuggetCopper", "nuggetCopper", "nuggetCopper"});
        RecipeRemover.removeRecipeShapedDelayed("ingotSteel", new Object[]{"nuggetSteel", "nuggetSteel", "nuggetSteel"}, new Object[]{"nuggetSteel", "nuggetSteel", "nuggetSteel"}, new Object[]{"nuggetSteel", "nuggetSteel", "nuggetSteel"});
        RecipeRemover.removeRecipeShapedDelayed("ingotBronze", new Object[]{"nuggetBronze", "nuggetBronze", "nuggetBronze"}, new Object[]{"nuggetBronze", "nuggetBronze", "nuggetBronze"}, new Object[]{"nuggetBronze", "nuggetBronze", "nuggetBronze"});
        RecipeRemover.removeRecipeShapedDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Aluminium, (long)1L), new Object[]{GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing)}, new Object[]{GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Aluminium, (long)1L), new Object[]{GTModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)12, (ItemStack)IScriptLoader.missing), null, null}, new Object[0], new Object[0]);
        RecipeRemover.flushBuffer();
        bufferMap = null;
        long timeToLoad = System.currentTimeMillis() - timeStart;
        MainRegistry.Logger.info((Object)("Recipes removal took " + timeToLoad + " ms."));
    }

    static {
        recipeWidthField = null;
    }
}

