/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.sinthoras.visualprospecting.VPMod;
import com.sinthoras.visualprospecting.hooks.HooksClient;
import cpw.mods.fml.common.Loader;
import gregtech.common.GTWorldgenerator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static boolean isNEIInstalled() {
        return Loader.isModLoaded((String)"NotEnoughItems");
    }

    public static boolean isNavigatorInstalled() {
        return Loader.isModLoaded((String)"navigator");
    }

    public static int coordBlockToChunk(int blockCoord) {
        return blockCoord < 0 ? -(-blockCoord - 1 >> 4) - 1 : blockCoord >> 4;
    }

    public static int coordChunkToBlock(int chunkCoord) {
        return chunkCoord < 0 ? -(-chunkCoord << 4) : chunkCoord << 4;
    }

    public static long chunkCoordsToKey(int chunkX, int chunkZ) {
        return CoordinatePacker.pack((int)chunkX, (int)0, (int)chunkZ);
    }

    public static int mapToCenterOreChunkCoord(int chunkCoord) {
        if (GTWorldgenerator.oregenPattern == GTWorldgenerator.OregenPattern.EQUAL_SPACING) {
            return chunkCoord - Math.floorMod(chunkCoord, 3) + 1;
        }
        if (chunkCoord >= 0) {
            return chunkCoord - chunkCoord % 3 + 1;
        }
        return chunkCoord - chunkCoord % 3 - 1;
    }

    public static int mapToCornerUndergroundFluidChunkCoord(int chunkCoord) {
        return chunkCoord & 0xFFFFFFF8;
    }

    public static boolean isSmallOreId(short metaData) {
        return metaData >= 16000;
    }

    public static short oreIdToMaterialId(short metaData) {
        return (short)(metaData % 1000);
    }

    public static boolean isLogicalClient() {
        return VPMod.proxy instanceof HooksClient;
    }

    public static File getMinecraftDirectory() {
        if (Utils.isLogicalClient()) {
            return Minecraft.func_71410_x().field_71412_D;
        }
        return new File(".");
    }

    public static File getSubDirectory(String subdirectory) {
        return new File(Utils.getMinecraftDirectory(), subdirectory);
    }

    public static void deleteDirectoryRecursively(File targetDirectory) {
        try (Stream<Path> files = Files.walk(targetDirectory.toPath(), new FileVisitOption[0]);){
            files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Short> readFileToMap(File file) {
        if (!file.exists()) {
            return new HashMap<String, Short>();
        }
        try {
            Gson gson = new Gson();
            BufferedReader reader = Files.newBufferedReader(file.toPath());
            Map map = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Short>>(){}.getType());
            ((Reader)reader).close();
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new HashMap<String, Short>();
        }
    }

    public static void writeMapToFile(File file, Map<String, Short> map) {
        try {
            if (file.exists()) {
                file.delete();
            }
            Gson gson = new Gson();
            BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardOpenOption.CREATE_NEW);
            gson.toJson(map, new TypeToken<Map<String, Short>>(){}.getType(), (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeNBT(File file, NBTTagCompound tag) {
        try (FileOutputStream stream = new FileOutputStream(Utils.newFile(file));){
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)stream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static File newFile(File file) {
        if (!file.exists()) {
            try {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    @Nullable
    public static NBTTagCompound readNBT(@NotNull File file) {
        NBTTagCompound nBTTagCompound;
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                try {
                    return CompressedStreamTools.func_74797_a((File)file);
                }
                catch (Exception ex1) {
                    return null;
                }
            }
        }
        ((InputStream)stream).close();
        return nBTTagCompound;
    }

    public static Map<Integer, ByteBuffer> getLegacyDimFiles(File directory) {
        if (!directory.exists()) {
            return new HashMap<Integer, ByteBuffer>();
        }
        try {
            List dimensionIds = Files.walk(directory.toPath(), 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith("DIM")).map(dimensionFolder -> Integer.parseInt(dimensionFolder.getFileName().toString().substring(3))).collect(Collectors.toList());
            HashMap<Integer, ByteBuffer> dimensionFiles = new HashMap<Integer, ByteBuffer>();
            Iterator iterator = dimensionIds.iterator();
            while (iterator.hasNext()) {
                int dimensionId = (Integer)iterator.next();
                ByteBuffer buffer = Utils.readFileToBuffer(new File(directory.toPath() + "/DIM" + dimensionId));
                if (buffer == null) continue;
                dimensionFiles.put(dimensionId, buffer);
            }
            return dimensionFiles;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new HashMap<Integer, ByteBuffer>();
        }
    }

    private static ByteBuffer readFileToBuffer(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            FileChannel inputChannel = inputStream.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)inputChannel.size());
            inputChannel.read(buffer);
            buffer.flip();
            inputChannel.close();
            inputStream.close();
            return buffer;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

