/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.guis.screens;

import gcewing.sg.SGAddressing;
import gcewing.sg.SGCraft;
import gcewing.sg.SGState;
import gcewing.sg.guis.DHDTE;
import gcewing.sg.guis.SGScreen;
import gcewing.sg.packets.SGChannel;
import gcewing.sg.tileentities.SGBaseTE;
import gcewing.sg.utils.BaseBlockUtils;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.joml.Vector3i;
import org.lwjgl.opengl.GL11;

public class DHDScreen
extends SGScreen {
    static final int dhdWidth = 320;
    static final int dhdHeight = 120;
    static final double dhdRadius1 = 32.0;
    static final double dhdRadius2 = 88.0;
    static final double dhdRadius3 = 144.0;
    World world;
    Vector3i pos;
    int dhdTop;
    int dhdCentreX;
    int dhdCentreY;
    int closingDelay = 0;
    int addressLength;
    DHDTE cte;

    public DHDScreen(EntityPlayer player, World world, Vector3i pos) {
        this.world = world;
        this.pos = pos;
        this.cte = this.getControllerTE();
        SGBaseTE te = this.getStargateTE();
        if (te != null) {
            this.addressLength = te.getNumChevrons();
        }
    }

    SGBaseTE getStargateTE() {
        if (this.cte != null) {
            return this.cte.getLinkedStargateTE();
        }
        return null;
    }

    DHDTE getControllerTE() {
        TileEntity te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.world, this.pos);
        if (te instanceof DHDTE) {
            return (DHDTE)te;
        }
        return null;
    }

    String getEnteredAddress() {
        return this.cte.enteredAddress;
    }

    void setEnteredAddress(String address) {
        this.cte.enteredAddress = address;
        SGChannel.sendEnteredAddressToServer(this.cte, address);
    }

    @Override
    public void func_73866_w_() {
        this.dhdTop = this.field_146295_m - 120;
        this.dhdCentreX = this.field_146294_l / 2;
        this.dhdCentreY = this.dhdTop + 60;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.closingDelay > 0 && --this.closingDelay == 0) {
            this.setEnteredAddress("");
            this.close();
        }
    }

    @Override
    protected void mousePressed(int x, int y, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        int i = this.findDHDButton(x, y);
        if (i >= 0) {
            this.dhdButtonPressed(i);
        }
    }

    void closeAfterDelay(int ticks) {
        this.closingDelay = ticks;
    }

    int findDHDButton(int mx, int my) {
        int nb;
        int i0;
        int x = -(mx - this.dhdCentreX);
        int y = -(my - this.dhdCentreY);
        if (y > 0 && Math.hypot(x, y) <= 32.0) {
            return 0;
        }
        double r = Math.hypot(x, y = y * 320 / 120);
        if (r > 144.0) {
            return -1;
        }
        if (r <= 32.0) {
            return 0;
        }
        double a = Math.toDegrees(Math.atan2(y, x));
        if (a < 0.0) {
            a += 360.0;
        }
        if (r > 88.0) {
            i0 = 1;
            nb = 26;
        } else {
            i0 = 27;
            nb = 11;
        }
        return i0 + (int)Math.floor(a * (double)nb / 360.0);
    }

    void dhdButtonPressed(int i) {
        this.buttonSound();
        if (i == 0) {
            this.orangeButtonPressed(false);
        } else if (i >= 37) {
            this.backspace();
        } else {
            this.enterCharacter(SGBaseTE.symbolToChar(i - 1));
        }
    }

    void buttonSound() {
        EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
        PositionedSoundRecord sound = new PositionedSoundRecord(new ResourceLocation("random.click"), 1.0f, 1.0f, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)sound);
    }

    @Override
    public void func_73869_a(char c, int key) {
        if (key == 1) {
            this.close();
        } else if (key == 14 || key == 211) {
            this.backspace();
        } else if (key == 28 || key == 156) {
            this.orangeButtonPressed(true);
        } else {
            String C = String.valueOf(c).toUpperCase();
            if (SGAddressing.isValidSymbolChar(C)) {
                this.enterCharacter(C.charAt(0));
            }
        }
    }

    void orangeButtonPressed(boolean connectOnly) {
        SGBaseTE te = this.getStargateTE();
        if (te != null) {
            if (te.state == SGState.Idle) {
                this.sendConnectOrDisconnect(te, this.getEnteredAddress());
            } else if (!connectOnly) {
                this.sendConnectOrDisconnect(te, "");
            }
        }
    }

    void sendConnectOrDisconnect(SGBaseTE te, String address) {
        SGChannel.sendConnectOrDisconnectToServer(te, address);
        this.closeAfterDelay(10);
    }

    void backspace() {
        if (this.stargateIsIdle()) {
            this.buttonSound();
            String a = this.getEnteredAddress();
            int n = a.length();
            if (n > 0) {
                this.setEnteredAddress(a.substring(0, n - 1));
            }
        }
    }

    void enterCharacter(char c) {
        if (this.stargateIsIdle()) {
            this.buttonSound();
            String a = this.getEnteredAddress();
            int n = a.length();
            if (n < this.addressLength) {
                this.setEnteredAddress(a + c);
            }
        }
    }

    boolean stargateIsIdle() {
        SGBaseTE te = this.getStargateTE();
        return te != null && te.state == SGState.Idle;
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        SGBaseTE te = this.getStargateTE();
        GL11.glPushAttrib((int)24576);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        this.drawBackgroundImage();
        this.drawOrangeButton();
        if (te != null && te.state == SGState.Idle) {
            this.drawEnteredSymbols();
            this.drawEnteredString();
        }
        GL11.glPopAttrib();
    }

    void drawBackgroundImage() {
        this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/dhd_gui.png"));
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        this.drawTexturedRect((this.field_146294_l - 320) / 2, this.field_146295_m - 120, 320.0, 120.0);
    }

    void drawOrangeButton() {
        boolean connected;
        this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/dhd_centre.png"), 128, 64);
        SGBaseTE te = this.getStargateTE();
        boolean bl = connected = te != null && te.isActive();
        if (te == null || !te.isMerged) {
            this.setColor(0.2, 0.2, 0.2);
        } else if (connected) {
            this.setColor(1.0, 0.5, 0.0);
        } else {
            this.setColor(0.5, 0.25, 0.0);
        }
        double rx = 30.0;
        double ry = 22.5;
        this.drawTexturedRect((double)this.dhdCentreX - rx, (double)this.dhdCentreY - ry - 6.0, 2.0 * rx, 1.5 * ry, 64.0, 0.0, 64.0, 48.0);
        this.resetColor();
        if (connected) {
            GL11.glBlendFunc((int)1, (int)1);
            double d = 5.0;
            this.drawTexturedRect((double)this.dhdCentreX - rx - d, (double)this.dhdCentreY - ry - d - 6.0, 2.0 * (rx + d), ry + d, 0.0, 0.0, 64.0, 32.0);
            this.drawTexturedRect((double)this.dhdCentreX - rx - d, this.dhdCentreY - 6, 2.0 * (rx + d), 0.5 * ry + d, 0.0, 32.0, 64.0, 32.0);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    void drawEnteredSymbols() {
        this.drawAddressSymbols(this.field_146294_l / 2, this.dhdTop - 80, this.getEnteredAddress());
    }

    void drawEnteredString() {
        String address = SGAddressing.padAddress(this.getEnteredAddress(), "|", this.addressLength);
        this.drawAddressString(this.field_146294_l / 2, this.dhdTop - 20, address);
    }
}

