/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.recipes.IStillManager;
import forestry.api.recipes.IStillRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.forestry.ForestryListAddition;
import modtweaker2.mods.forestry.ForestryListRemoval;
import modtweaker2.mods.forestry.recipes.StillRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Still")
public class Still {
    public static final String name = "Forestry Still";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, ILiquidStack fluidInput, int timePerUnit) {
        fluidOutput.amount(fluidOutput.getAmount() / 100);
        fluidInput.amount(fluidInput.getAmount() / 100);
        MineTweakerAPI.apply((IUndoableAction)new Add(new StillRecipe(timePerUnit, InputHelper.toFluid(fluidInput), InputHelper.toFluid(fluidOutput))));
    }

    @Deprecated
    @ZenMethod
    public static void addRecipe(int timePerUnit, ILiquidStack input, ILiquidStack output) {
        output.amount(output.getAmount() / 100);
        input.amount(input.getAmount() / 100);
        MineTweakerAPI.apply((IUndoableAction)new Add(new StillRecipe(timePerUnit, InputHelper.toFluid(input), InputHelper.toFluid(output))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output, @Optional ILiquidStack input) {
        LinkedList<IStillRecipe> recipes = new LinkedList<IStillRecipe>();
        for (IStillRecipe r : RecipeManagers.stillManager.recipes()) {
            if (r == null || r.getOutput() == null || !StackHelper.matches(output, InputHelper.toILiquidStack(r.getOutput()))) continue;
            if (input != null) {
                if (!StackHelper.matches((IIngredient)input, InputHelper.toILiquidStack(r.getInput()))) continue;
                recipes.add(r);
                continue;
            }
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(output)));
        }
    }

    private static class Remove
    extends ForestryListRemoval<IStillRecipe, IStillManager> {
        public Remove(List<IStillRecipe> recipes) {
            super(Still.name, RecipeManagers.stillManager, recipes);
        }

        @Override
        public String getRecipeInfo(IStillRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends ForestryListAddition<IStillRecipe, IStillManager> {
        public Add(IStillRecipe recipe) {
            super(Still.name, RecipeManagers.stillManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IStillRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }
}

