/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler;

import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.chunk.SchematicContainer;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class QueueTickHandler {
    public static final QueueTickHandler INSTANCE = new QueueTickHandler();
    private final Queue<SchematicContainer> queue = new ArrayDeque<SchematicContainer>();

    private QueueTickHandler() {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        try {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.field_71174_a != null && !player.field_71174_a.func_147298_b().func_150731_c()) {
                this.processQueue();
            }
        }
        catch (Exception e) {
            Reference.logger.error("Something went wrong...", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        this.processQueue();
    }

    private void processQueue() {
        if (this.queue.isEmpty()) {
            return;
        }
        SchematicContainer container = this.queue.poll();
        if (container == null) {
            return;
        }
        if (container.hasNext()) {
            if (container.isFirst()) {
                ChatComponentTranslation chatComponent = new ChatComponentTranslation("schematica.command.save.started", new Object[]{container.chunkCount, container.file.getName()});
                container.player.func_145747_a((IChatComponent)chatComponent);
            }
            container.next();
        }
        if (container.hasNext()) {
            this.queue.offer(container);
        } else {
            boolean success;
            if (container.world != null) {
                for (TileEntity entity : container.schematic.getTileEntities()) {
                    if (entity.func_145830_o()) continue;
                    entity.func_145834_a(container.world);
                }
            }
            String message = (success = SchematicFormat.writeToFile(container.file, container.schematic, container.world)) ? "schematica.command.save.saveSucceeded" : "schematica.command.save.saveFailed";
            container.player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, new Object[]{container.file.getName()}));
        }
    }

    public void queueSchematic(SchematicContainer container) {
        this.queue.offer(container);
    }
}

