/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.nei;

import blockrenderer6343.BlockRenderer6343;
import blockrenderer6343.api.utils.CreativeItemSource;
import blockrenderer6343.client.renderer.ImmediateWorldSceneRenderer;
import blockrenderer6343.client.renderer.WorldSceneRenderer;
import blockrenderer6343.client.utils.ClearGuiButton;
import blockrenderer6343.client.utils.GuiText;
import blockrenderer6343.client.utils.TieredConstructable;
import blockrenderer6343.client.utils.TooltipButton;
import blockrenderer6343.client.world.ClientFakePlayer;
import blockrenderer6343.client.world.TrackedDummyWorld;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.math.MathHelper;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiRecipe;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketNEIPatternRecipe;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizon.structurelib.StructureEvent;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.constructable.ConstructableUtility;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.item.ItemConstructableTrigger;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

@EventBusSubscriber(side={Side.CLIENT})
public abstract class GuiMultiblockHandler {
    protected static ImmediateWorldSceneRenderer renderer;
    private final RenderBlocks renderBlocks = new RenderBlocks();
    public static final int SLOT_SIZE = 18;
    public static final int ICON_SIZE_X = 20;
    public static final int ICON_SIZE_Y = 12;
    public static final long NO_SELECTED_BLOCK;
    protected static final int RECIPE_LAYOUT_X = 8;
    protected static final int RECIPE_LAYOUT_Y = 50;
    protected static final int RECIPE_WIDTH = 160;
    protected static final int sceneHeight = 150;
    protected static final int MOUSE_OFFSET_X = 5;
    protected static final int MOUSE_OFFSET_Y = 37;
    protected static final int BUTTON_LEFT = -5;
    protected static final int UNDER_PREVIEW_Y = 153;
    protected static final int BUTTON_RIGHT = 145;
    protected static final int BETWEEN_BUTTON_X = 23;
    protected static final float DEFAULT_RANGE_MULTIPLIER = 3.5f;
    public static final int MAX_PLACE_ROUNDS = 2000;
    public static final BlockPos MB_PLACE_POS;
    protected static final BlockPos SELECTED_BLOCK;
    protected static int guiMouseX;
    protected static int guiMouseY;
    protected static int guiLeft;
    protected static int guiTop;
    protected static int lastGuiMouseX;
    protected static int lastGuiMouseY;
    protected static Vector3f center;
    protected static float rotationYaw;
    protected static float rotationPitch;
    protected static float zoom;
    protected static ItemStack tooltipBlockStack;
    protected static int layerIndex;
    protected static int guiColorBg;
    protected static int guiColorFont;
    protected static int buttonColorEnabled;
    protected static int buttonColorDisabled;
    protected static int buttonColorHovered;
    protected static String guiTextLayer;
    protected static String guiLayerButtonTitle;
    protected static String guiTextTier;
    protected static String guiTierButtonTitle;
    protected static int initialTierButtonTitleWidth;
    protected static int initialLayerButtonTitleWidth;
    protected static int initialChannelTierButtonTitleWidth;
    protected ClearGuiButton previousLayerButton;
    protected ClearGuiButton nextLayerButton;
    protected ClearGuiButton previousTierButton;
    protected ClearGuiButton nextTierButton;
    protected ClearGuiButton previousChannelButton;
    protected ClearGuiButton nextChannelButton;
    protected ClearGuiButton previousChannelTier;
    protected ClearGuiButton nextChannelTier;
    protected List<ItemStack> ingredients = new ArrayList<ItemStack>();
    protected Consumer<List<ItemStack>> onIngredientChanged;
    protected final Map<GuiButton, Runnable> buttons = new HashMap<GuiButton, Runnable>();
    protected IConstructable renderingController;
    protected IConstructable lastRenderingController;
    protected ItemStack stackForm;
    public static final Long2ObjectMap<IStructureElement<Object>> structureElementMap;
    protected Consumer<List<List<ItemStack>>> onCandidateChanged;
    protected static int tierIndex;
    protected static EntityPlayer fakeMultiblockBuilder;
    protected int scrolled = 0;
    protected int blocksBelowController;
    protected static int scaledSceneHeight;
    protected int channelIndex;
    protected ItemStack trigger;
    public static Set<String> channels;
    protected int[] channelTier;
    protected String[] channelArray;
    protected boolean useMasterChannel = true;
    protected String channelTitle;
    protected String channelTierTitle;
    protected int lastHeight;

    public GuiMultiblockHandler() {
        this.previousTierButton = new ClearGuiButton(1, -5, 153, "<");
        this.nextTierButton = new ClearGuiButton(1, 15, 153, ">");
        this.previousLayerButton = new ClearGuiButton(2, -5, 165, "<");
        this.nextLayerButton = new ClearGuiButton(2, 15, 165, ">");
        this.previousChannelButton = new ClearGuiButton(4, -5, 189, "<", this::hasChannels);
        this.nextChannelButton = new ClearGuiButton(4, 15, 189, ">", this::hasChannels);
        this.previousChannelTier = new ClearGuiButton(5, -5, 201, "<", this::hasChannels);
        this.nextChannelTier = new ClearGuiButton(5, 15, 201, ">", this::hasChannels);
        TooltipButton projectMultiblocksButton = new TooltipButton(1, 145, 153, 20, 12, "P", StatCollector.func_74838_a((String)"blockrenderer6343.multiblock.project"));
        TooltipButton overlayMultiblocksButton = new TooltipButton(1, 122, 153, 20, 12, "?", StatCollector.func_74838_a((String)"blockrenderer6343.multiblock.overlay"));
        TooltipButton copyChannelButton = new TooltipButton(1, 99, 153, 20, 12, "C", StatCollector.func_74838_a((String)"blockrenderer6343.multiblock.copy_channels"), this::hasChannels);
        this.buttons.put(this.previousLayerButton, this::togglePreviousLayer);
        this.buttons.put(this.nextLayerButton, this::toggleNextLayer);
        this.buttons.put(this.previousTierButton, this::togglePreviousTier);
        this.buttons.put(this.nextTierButton, this::toggleNextTier);
        this.buttons.put(this.previousChannelButton, this::togglePreviousChannel);
        this.buttons.put(this.nextChannelButton, this::toggleNextChannel);
        this.buttons.put(this.previousChannelTier, this::togglePreviousChannelTier);
        this.buttons.put(this.nextChannelTier, this::toggleNextChannelTier);
        this.buttons.put((GuiButton)projectMultiblocksButton, this::projectMultiblock);
        this.buttons.put((GuiButton)overlayMultiblocksButton, this::neiOverlay);
        this.buttons.put((GuiButton)copyChannelButton, this::copyToHologram);
    }

    protected abstract void placeMultiblock();

    protected void setupColors() {
        guiTextLayer = GuiText.Layer.getLocal();
        guiColorBg = GuiText.BgColor.getColor();
        guiColorFont = GuiText.FontColor.getColor();
        buttonColorEnabled = GuiText.ButtonEnabledColor.getColor();
        buttonColorDisabled = GuiText.ButtonDisabledColor.getColor();
        buttonColorHovered = GuiText.ButtonHoveredColor.getColor();
    }

    protected void setupButtonText() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        guiTextTier = GuiText.Tier.getLocal();
        this.refreshButtonText();
        initialLayerButtonTitleWidth = fontRenderer.func_78256_a(guiLayerButtonTitle);
        initialTierButtonTitleWidth = fontRenderer.func_78256_a(guiTierButtonTitle);
        if (this.hasChannels()) {
            initialChannelTierButtonTitleWidth = fontRenderer.func_78256_a(this.channelTierTitle);
        }
        for (GuiButton button : this.buttons.keySet()) {
            if (!(button instanceof ClearGuiButton)) continue;
            ClearGuiButton clearButton = (ClearGuiButton)button;
            clearButton.setColors(buttonColorEnabled, buttonColorDisabled, buttonColorHovered);
        }
        this.refreshButtonPos();
    }

    protected void refreshButtonPos() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.nextTierButton.field_146128_h = 15 + initialTierButtonTitleWidth - fontRenderer.func_78256_a("<") / 2;
        this.nextLayerButton.field_146128_h = 15 + initialLayerButtonTitleWidth - fontRenderer.func_78256_a("<") / 2;
        this.nextChannelButton.field_146128_h = 15 + fontRenderer.func_78256_a(StatCollector.func_74838_a((String)"blockrenderer6343.nei.channel"));
        this.nextChannelTier.field_146128_h = 15 + initialChannelTierButtonTitleWidth - fontRenderer.func_78256_a("<") / 2;
        for (GuiButton b : this.buttons.keySet()) {
            if (b instanceof TooltipButton) {
                TooltipButton tooltipButton = (TooltipButton)b;
                tooltipButton.field_146129_i = scaledSceneHeight + 12;
                continue;
            }
            b.field_146129_i = scaledSceneHeight + 12 * b.field_146127_k;
        }
    }

    public void refreshButtonText() {
        guiLayerButtonTitle = this.getLayerButtonTitle();
        guiTierButtonTitle = this.getTierButtonTitle();
        if (this.hasChannels()) {
            this.channelTitle = this.getChannelTitle();
            this.channelTierTitle = this.getChannelTierTitle();
        }
    }

    public void loadMultiblock(IConstructable multiblock, ItemStack stackForm) {
        this.setupColors();
        this.renderingController = multiblock;
        this.stackForm = stackForm;
        if (stackForm.field_77994_a == 0) {
            stackForm.field_77994_a = 1;
        }
        if (this.lastRenderingController != this.renderingController) {
            this.loadNewMultiblock();
        } else {
            this.loadPreviousMultiblockAgain();
        }
        this.setupButtonText();
    }

    protected void loadNewMultiblock() {
        this.trigger = GuiMultiblockHandler.getOriginalTriggerStack();
        channels.clear();
        layerIndex = -1;
        this.channelIndex = 0;
        IConstructable iConstructable = this.renderingController;
        if (iConstructable instanceof TieredConstructable) {
            TieredConstructable tiered = (TieredConstructable)iConstructable;
            tierIndex = tiered.getTier();
        } else {
            tierIndex = 1;
        }
        this.initializeSceneRenderer(true);
        this.lastRenderingController = this.renderingController;
        if (this.hasChannels()) {
            this.channelTier = new int[channels.size()];
            Arrays.fill(this.channelTier, 1);
            this.channelArray = channels.toArray(new String[0]);
        }
    }

    protected void loadPreviousMultiblockAgain() {
        this.initializeSceneRenderer(false);
    }

    public void setOnIngredientChanged(Consumer<List<ItemStack>> callback) {
        this.onIngredientChanged = callback;
    }

    private void toggleNextLayer() {
        int height = (int)GuiMultiblockHandler.renderer.world.getSize().getY() - 1;
        if (++layerIndex > height) {
            layerIndex = -1;
        }
        this.setNextLayer(layerIndex);
        this.refreshButtonText();
    }

    private void togglePreviousLayer() {
        int height = (int)GuiMultiblockHandler.renderer.world.getSize().getY() - 1;
        if (layerIndex == -1) {
            layerIndex = height;
        } else if (--layerIndex < 0) {
            layerIndex = -1;
        }
        this.setNextLayer(layerIndex);
        this.refreshButtonText();
    }

    private void toggleNextChannel() {
        if (!this.hasChannels()) {
            return;
        }
        if (++this.channelIndex >= channels.size()) {
            this.channelIndex = 0;
        }
        this.useMasterChannel = false;
        this.initializeSceneRenderer(false);
        this.refreshButtonText();
    }

    private void togglePreviousChannel() {
        if (!this.hasChannels()) {
            return;
        }
        if (--this.channelIndex < 0) {
            this.channelIndex = channels.size() - 1;
        }
        this.useMasterChannel = false;
        this.initializeSceneRenderer(false);
        this.refreshButtonText();
    }

    private void toggleNextChannelTier() {
        if (!this.hasChannels()) {
            return;
        }
        int n = this.channelIndex;
        this.channelTier[n] = this.channelTier[n] + 1;
        this.useMasterChannel = false;
        ChannelDataAccessor.setChannelData((ItemStack)this.trigger, (String)this.channelArray[this.channelIndex], (int)this.channelTier[this.channelIndex]);
        this.initializeSceneRenderer(false);
        this.refreshButtonText();
    }

    private void togglePreviousChannelTier() {
        if (!this.hasChannels()) {
            return;
        }
        int n = this.channelIndex;
        this.channelTier[n] = this.channelTier[n] - 1;
        if (this.channelTier[this.channelIndex] == 0) {
            this.channelTier[this.channelIndex] = 1;
            this.refreshButtonText();
            return;
        }
        this.useMasterChannel = false;
        ChannelDataAccessor.setChannelData((ItemStack)this.trigger, (String)this.channelArray[this.channelIndex], (int)this.channelTier[this.channelIndex]);
        this.initializeSceneRenderer(false);
        this.refreshButtonText();
    }

    protected void toggleNextTier() {
        ++tierIndex;
        this.useMasterChannel = true;
        this.initializeSceneRenderer(false);
        this.refreshButtonText();
    }

    protected void togglePreviousTier() {
        if (tierIndex > 1) {
            this.useMasterChannel = true;
            --tierIndex;
            this.initializeSceneRenderer(false);
            this.refreshButtonText();
        }
    }

    protected boolean hasChannels() {
        return !channels.isEmpty();
    }

    private void setNextLayer(int newLayer) {
        layerIndex = newLayer;
        if (renderer != null) {
            LongSet renderBlocks;
            TrackedDummyWorld world = GuiMultiblockHandler.renderer.world;
            this.resetCenter();
            GuiMultiblockHandler.renderer.renderedBlocks.clear();
            int minY = (int)world.getMinPos().getY();
            if (newLayer == -1) {
                renderBlocks = world.placedBlocks;
                renderer.setRenderAllFaces(false);
            } else {
                renderBlocks = new LongOpenHashSet();
                LongIterator longIterator = world.placedBlocks.iterator();
                while (longIterator.hasNext()) {
                    long pos = (Long)longIterator.next();
                    if (CoordinatePacker.unpackY((long)pos) - minY != newLayer) continue;
                    renderBlocks.add(pos);
                }
                renderer.setRenderAllFaces(true);
            }
            renderer.addRenderedBlocks(renderBlocks);
            this.scanIngredients();
        }
    }

    private void resetCenter() {
        TrackedDummyWorld world = GuiMultiblockHandler.renderer.world;
        Vector3f size = world.getSize();
        Vector3f minPos = world.getMinPos();
        center = new Vector3f(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        renderer.setCameraLookAt(center, zoom, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
    }

    public void drawMultiblock() {
        guiMouseX = GuiDraw.getMousePosition().x;
        guiMouseY = GuiDraw.getMousePosition().y;
        guiLeft = NEIClientUtils.getGuiContainer().field_147003_i;
        guiTop = NEIClientUtils.getGuiContainer().field_147009_r;
        int guiHeight = NEIClientUtils.getGuiContainer().field_146295_m;
        if (guiHeight != this.lastHeight) {
            scaledSceneHeight = Math.min(150, 150 * guiHeight / 500);
            this.refreshButtonPos();
        }
        renderer.render(8 + guiLeft, 50 + guiTop, 160, scaledSceneHeight, lastGuiMouseX, lastGuiMouseY);
        this.drawMultiblockName();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tooltipBlockStack = null;
        MovingObjectPosition rayTraceResult = renderer.getLastTraceResult();
        boolean leftClickHeld = Mouse.isButtonDown((int)0);
        boolean rightClickHeld = Mouse.isButtonDown((int)1);
        boolean middleClickHeld = Mouse.isButtonDown((int)2);
        if (this.isInsideView()) {
            int mouseDeltaY;
            if (leftClickHeld) {
                rotationPitch += (float)(guiMouseX - lastGuiMouseX + 360);
                rotationPitch %= 360.0f;
                rotationYaw = (float)MathHelper.clip((double)(rotationYaw + (float)(guiMouseY - lastGuiMouseY)), (double)-89.9, (double)89.9);
            } else if (rightClickHeld && Math.abs(mouseDeltaY = guiMouseY - lastGuiMouseY) > 1) {
                zoom = (float)MathHelper.clip((double)((double)zoom + (mouseDeltaY > 0 ? 0.15 : -0.15)), (double)3.0, (double)999.0);
            }
            if (middleClickHeld) {
                int mouseDeltaX = guiMouseX - lastGuiMouseX;
                int mouseDeltaY2 = guiMouseY - lastGuiMouseY;
                Vector3f lookAt = renderer.getLookAt();
                Vector3f eyePos = renderer.getEyePos();
                Vector3f worldUp = renderer.getWorldUp();
                Vector3f lookDir = Vector3f.sub((Vector3f)lookAt, (Vector3f)eyePos, null);
                Vector3f rightDir = Vector3f.cross((Vector3f)lookDir, (Vector3f)worldUp, null);
                rightDir.normalise();
                Vector3f upDir = Vector3f.cross((Vector3f)rightDir, (Vector3f)lookDir, null);
                upDir.normalise();
                Vector3f offset = new Vector3f((float)(-mouseDeltaX) * rightDir.x + (float)mouseDeltaY2 * upDir.x, (float)(-mouseDeltaX) * rightDir.y + (float)mouseDeltaY2 * upDir.y, (float)(-mouseDeltaX) * rightDir.z + (float)mouseDeltaY2 * upDir.z);
                offset.scale(0.15f);
                Vector3f.add((Vector3f)center, (Vector3f)offset, (Vector3f)center);
            }
            if (this.scrolled != 0) {
                zoom = (float)MathHelper.clip((double)(zoom - (float)(this.scrolled * 5)), (double)3.0, (double)999.0);
                this.scrolled = 0;
            }
            renderer.setCameraLookAt(center, zoom, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
        }
        int actualMouseX = guiMouseX - guiLeft - 5;
        int actualMouseY = guiMouseY - guiTop - 37;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (GuiButton button : this.buttons.keySet()) {
            button.func_146112_a(Minecraft.func_71410_x(), actualMouseX, actualMouseY);
        }
        this.drawButtonsTitle(fontRenderer);
        for (GuiButton button : this.buttons.keySet()) {
            TooltipButton tooltipButton;
            if (!(button instanceof TooltipButton) || !(tooltipButton = (TooltipButton)button).isMouseOver(actualMouseX, actualMouseY)) continue;
            int textWidth = fontRenderer.func_78256_a(tooltipButton.hoverString);
            tooltipButton.drawTooltipBox(fontRenderer, actualMouseX - 3, actualMouseY - 17, textWidth + 3, tooltipButton.field_146121_g);
        }
        if (!(leftClickHeld || rightClickHeld || rayTraceResult == null || GuiMultiblockHandler.renderer.world.func_147437_c(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d))) {
            Block block = GuiMultiblockHandler.renderer.world.func_147439_a(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d);
            tooltipBlockStack = block.getPickBlock(rayTraceResult, (World)GuiMultiblockHandler.renderer.world, rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
        this.lastHeight = guiHeight;
        lastGuiMouseX = guiMouseX;
        lastGuiMouseY = guiMouseY;
    }

    private boolean isInsideView() {
        return guiMouseX >= guiLeft + 8 && guiMouseX <= guiLeft + 8 + 160 && guiMouseY >= guiTop + 50 && guiMouseY <= guiTop + 50 + scaledSceneHeight;
    }

    protected String getMultiblockName() {
        return I18n.func_135052_a((String)this.stackForm.func_82833_r(), (Object[])new Object[0]);
    }

    private void drawMultiblockName() {
        String localizedName = this.getMultiblockName();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        List lines = fontRenderer.func_78271_c(localizedName, 150);
        for (int i = 0; i < lines.size(); ++i) {
            fontRenderer.func_78276_b((String)lines.get(i), (160 - fontRenderer.func_78256_a((String)lines.get(i))) / 2, fontRenderer.field_78288_b * i, guiColorFont);
        }
    }

    protected void drawButtonsTitle(FontRenderer fontRenderer) {
        fontRenderer.func_78276_b(guiTierButtonTitle, 15 + (initialTierButtonTitleWidth - fontRenderer.func_78256_a(guiTierButtonTitle)) / 2, scaledSceneHeight + 12 + 2, guiColorFont);
        fontRenderer.func_78276_b(guiLayerButtonTitle, 15 + (initialLayerButtonTitleWidth - fontRenderer.func_78256_a(guiLayerButtonTitle)) / 2, scaledSceneHeight + 24 + 2, guiColorFont);
        if (this.hasChannels()) {
            fontRenderer.func_78276_b(StatCollector.func_74838_a((String)"blockrenderer6343.nei.current_channel") + ": " + this.channelTitle, 1, scaledSceneHeight + 36 + 2, guiColorFont);
            fontRenderer.func_78276_b(StatCollector.func_74838_a((String)"blockrenderer6343.nei.channel"), 15, scaledSceneHeight + 48 + 2, guiColorFont);
            fontRenderer.func_78276_b(this.channelTierTitle, 15 + (initialChannelTierButtonTitleWidth - fontRenderer.func_78256_a(this.channelTierTitle)) / 2, scaledSceneHeight + 60 + 2, guiColorFont);
        }
    }

    protected void initializeSceneRenderer(boolean resetCamera) {
        Vector3f eyePos = new Vector3f();
        Vector3f lookAt = new Vector3f();
        Vector3f worldUp = new Vector3f();
        if (!resetCamera) {
            try {
                eyePos = renderer.getEyePos();
                lookAt = renderer.getLookAt();
                worldUp = renderer.getWorldUp();
            }
            catch (NullPointerException e) {
                BlockRenderer6343.error("please reset camera on your first renderer call!");
            }
        }
        renderer = new ImmediateWorldSceneRenderer(new TrackedDummyWorld());
        GuiMultiblockHandler.renderer.world.updateEntitiesForNEI();
        renderer.setClearColor(guiColorBg);
        fakeMultiblockBuilder = this.createFakeBuilder(GuiMultiblockHandler.renderer.world, "BlockRenderer6343");
        GuiMultiblockHandler.renderer.world.func_72828_b(Collections.singletonList(fakeMultiblockBuilder));
        if (!StructureLibAPI.isInstrumentEnabled()) {
            StructureLibAPI.enableInstrument((Object)"blockrenderer6343");
        }
        structureElementMap.clear();
        this.placeMultiblock();
        if (StructureLibAPI.isInstrumentEnabled()) {
            StructureLibAPI.disableInstrument();
        }
        Vector3f size = GuiMultiblockHandler.renderer.world.getSize();
        Vector3f minPos = GuiMultiblockHandler.renderer.world.getMinPos();
        center = new Vector3f(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        GuiMultiblockHandler.renderer.renderedBlocks.clear();
        renderer.addRenderedBlocks(GuiMultiblockHandler.renderer.world.placedBlocks);
        renderer.setOnLookingAt(ray -> {});
        renderer.setOnWorldRender(this::onRendererRender);
        this.blocksBelowController = MathHelper.floor_double((double)((float)GuiMultiblockHandler.MB_PLACE_POS.y - minPos.y));
        SELECTED_BLOCK.set(NO_SELECTED_BLOCK);
        this.scanCandidates();
        this.setNextLayer(layerIndex);
        if (resetCamera) {
            float max = Math.max(Math.max(size.x, size.y), size.z);
            float baseZoom = (float)(3.5 * Math.sqrt(max));
            float sizeFactor = (float)(1.0 + Math.log(max) / Math.log(10.0));
            zoom = baseZoom * sizeFactor / 1.5f;
            rotationYaw = 20.0f;
            rotationPitch = 50.0f;
            if (renderer != null) {
                this.resetCenter();
            }
        } else {
            renderer.setCameraLookAt(eyePos, lookAt, worldUp);
        }
    }

    public boolean handleMouseScrollUp(int scrolled) {
        if (this.isInsideView()) {
            this.scrolled = scrolled;
            return true;
        }
        return false;
    }

    protected String getTierButtonTitle() {
        return guiTextTier + ": " + tierIndex;
    }

    protected String getChannelTitle() {
        return this.useMasterChannel ? "All" : StringUtils.capitalize((String)this.channelArray[this.channelIndex]);
    }

    protected String getChannelTierTitle() {
        return StatCollector.func_74838_a((String)"blockrenderer6343.nei.channel_tier") + ": " + this.channelTier[this.channelIndex];
    }

    protected String getLayerButtonTitle() {
        return guiTextLayer + ": " + (layerIndex == -1 ? "A" : Integer.toString(layerIndex + 1));
    }

    public void onRendererRender(WorldSceneRenderer renderer) {
        MovingObjectPosition lookingPos = renderer.getLastTraceResult();
        long lookingBlock = lookingPos == null ? NO_SELECTED_BLOCK : CoordinatePacker.pack((int)lookingPos.field_72311_b, (int)lookingPos.field_72312_c, (int)lookingPos.field_72309_d);
        long selectedBlock = SELECTED_BLOCK.asLong();
        if (selectedBlock == lookingBlock) {
            this.renderBlockOverLay(selectedBlock, Blocks.field_150359_w.func_149691_a(0, 6));
            return;
        }
        this.renderBlockOverLay(lookingBlock, Blocks.field_150399_cn.func_149691_a(0, 7));
        this.renderBlockOverLay(selectedBlock, Blocks.field_150399_cn.func_149691_a(0, 14));
    }

    protected void projectMultiblock() {
        int blockY;
        int blockZ;
        int blockX;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient baseWorld = Minecraft.func_71410_x().field_71441_e;
        Vec3 lookVec = player.func_70040_Z();
        MovingObjectPosition lookingPos = player.func_70614_a(10.0, 1.0f);
        if (lookingPos == null || lookingPos.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            blockX = MathHelper.floor_double((double)(player.field_70165_t + lookVec.field_72450_a * 2.0));
            blockZ = MathHelper.floor_double((double)(player.field_70161_v + lookVec.field_72449_c * 2.0));
            blockY = baseWorld.func_72874_g(blockX, blockZ) + this.blocksBelowController;
        } else {
            blockX = lookingPos.field_72311_b;
            blockY = lookingPos.field_72312_c + this.blocksBelowController + 1;
            blockZ = lookingPos.field_72309_d;
        }
        ItemStack copy = this.stackForm.func_77946_l();
        if (!baseWorld.func_147437_c(blockX, blockY, blockZ)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"blockrenderer6343.no_space")));
            return;
        }
        if (!copy.func_77973_b().func_77648_a(copy, (EntityPlayer)player, (World)baseWorld, blockX, blockY, blockZ, 0, (float)blockX, (float)(blockY - 1), (float)blockZ)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"blockrenderer6343.no_block")));
            return;
        }
        ConstructableUtility.handle((ItemStack)this.getBuildTriggerStack(), (EntityPlayer)player, (World)baseWorld, (int)blockX, (int)blockY, (int)blockZ, (int)0);
        baseWorld.func_147468_f(blockX, blockY, blockZ);
        baseWorld.func_147475_p(blockX, blockY, blockZ);
    }

    protected void neiOverlay() {
        if (!BlockRenderer6343.isNEELoaded) {
            return;
        }
        NBTTagCompound recipeInputs = new NBTTagCompound();
        GuiRecipe currentScreen = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)currentScreen.firstGui);
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = this.ingredients.get(i);
            if (itemStack == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStack.func_77955_b(itemStackNBT);
            itemStackNBT.func_74768_a("Count", itemStack.field_77994_a);
            recipeInputs.func_74782_a("#" + i, (NBTBase)itemStackNBT);
        }
        NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketNEIPatternRecipe(recipeInputs, new NBTTagCompound()));
    }

    protected void copyToHologram() {
        if (!this.hasChannels()) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_70694_bm();
        if (stack == null || !(stack.func_77973_b() instanceof ItemConstructableTrigger)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"blockrenderer6343.no_projector")));
        } else {
            StructureLib.instance().proxy().uploadChannels(this.trigger);
        }
    }

    private void scanIngredients() {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        LongIterator longIterator = GuiMultiblockHandler.renderer.renderedBlocks.iterator();
        while (longIterator.hasNext()) {
            int z;
            int y;
            long renderedBlock = (Long)longIterator.next();
            int x = CoordinatePacker.unpackX((long)renderedBlock);
            Block block = GuiMultiblockHandler.renderer.world.func_147439_a(x, y = CoordinatePacker.unpackY((long)renderedBlock), z = CoordinatePacker.unpackZ((long)renderedBlock));
            if (block.equals(Blocks.field_150350_a)) continue;
            int meta = GuiMultiblockHandler.renderer.world.func_72805_g(x, y, z);
            int qty = block.func_149745_a(GuiMultiblockHandler.renderer.world.field_73012_v);
            ArrayList itemstacks = new ArrayList();
            if (qty != 1) {
                itemstacks.add(new ItemStack(block));
            } else {
                itemstacks = block.getDrops((World)GuiMultiblockHandler.renderer.world, x, y, z, meta, 0);
            }
            boolean added = false;
            for (ItemStack ingredient : ingredients) {
                if (!NEIClientUtils.areStacksSameTypeWithNBT((ItemStack)ingredient, (ItemStack)((ItemStack)itemstacks.get(0)))) continue;
                ++ingredient.field_77994_a;
                added = true;
                break;
            }
            if (added) continue;
            ingredients.add((ItemStack)itemstacks.get(0));
        }
        this.ingredients = ingredients;
        if (this.onIngredientChanged != null) {
            this.onIngredientChanged.accept(ingredients);
        }
    }

    private void renderBlockOverLay(long pos, IIcon icon) {
        if (pos == NO_SELECTED_BLOCK) {
            return;
        }
        this.renderBlocks.field_147845_a = GuiMultiblockHandler.renderer.world;
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.renderBlocks.field_147837_f = true;
        int x = CoordinatePacker.unpackX((long)pos);
        int y = CoordinatePacker.unpackY((long)pos);
        int z = CoordinatePacker.unpackZ((long)pos);
        Block block = GuiMultiblockHandler.renderer.world.func_147439_a(x, y, z);
        this.renderBlocks.func_147792_a(block, x, y, z, icon);
    }

    public boolean mouseClicked(int button) {
        for (Map.Entry<GuiButton, Runnable> buttons : this.buttons.entrySet()) {
            int guiLeft = NEIClientUtils.getGuiContainer().field_147003_i;
            int guiTop = NEIClientUtils.getGuiContainer().field_147009_r;
            if (!buttons.getKey().func_146116_c(Minecraft.func_71410_x(), guiMouseX - guiLeft - 5, guiMouseY - guiTop - 37)) continue;
            buttons.getValue().run();
            SELECTED_BLOCK.set(NO_SELECTED_BLOCK);
            this.scanCandidates();
            return true;
        }
        if (button == 1 && renderer != null) {
            MovingObjectPosition rayTrace = renderer.getLastTraceResult();
            if (rayTrace == null) {
                if (SELECTED_BLOCK.asLong() != NO_SELECTED_BLOCK) {
                    SELECTED_BLOCK.set(NO_SELECTED_BLOCK);
                    this.scanCandidates();
                    return true;
                }
                return false;
            }
            SELECTED_BLOCK.set(rayTrace.field_72311_b, rayTrace.field_72312_c, rayTrace.field_72309_d);
            this.scanCandidates();
        }
        return false;
    }

    @NotNull
    protected static ItemStack getOriginalTriggerStack() {
        return new ItemStack(StructureLibAPI.getDefaultHologramItem(), tierIndex);
    }

    protected EntityPlayer createFakeBuilder(World world, String name) {
        return new ClientFakePlayer(world, new GameProfile(UUID.nameUUIDFromBytes(name.getBytes()), name));
    }

    @NotNull
    protected ItemStack getBuildTriggerStack() {
        return this.useMasterChannel ? GuiMultiblockHandler.getOriginalTriggerStack() : this.trigger;
    }

    protected void scanCandidates() {
        if (SELECTED_BLOCK.asLong() == NO_SELECTED_BLOCK) {
            this.onCandidateChanged.accept(Collections.emptyList());
            return;
        }
        ArrayList candidates = new ArrayList();
        LongIterator longIterator = structureElementMap.keySet().iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            if (pos != SELECTED_BLOCK.asLong()) continue;
            IStructureElement.BlocksToPlace blocksToPlace = ((IStructureElement)structureElementMap.get(pos)).getBlocksToPlace(this.getContextObject(), (World)GuiMultiblockHandler.renderer.world, GuiMultiblockHandler.SELECTED_BLOCK.x, GuiMultiblockHandler.SELECTED_BLOCK.y, GuiMultiblockHandler.SELECTED_BLOCK.z, GuiMultiblockHandler.getOriginalTriggerStack(), AutoPlaceEnvironment.fromLegacy((IItemSource)CreativeItemSource.instance, (EntityPlayer)fakeMultiblockBuilder, iChatComponent -> {}));
            if (blocksToPlace == null) {
                return;
            }
            Set<ItemStack> rawCandidates = CreativeItemSource.instance.takeEverythingMatches(blocksToPlace.getPredicate(), false, 0).keySet();
            ArrayList stackedCandidates = new ArrayList();
            for (ItemStack rawCandidate : rawCandidates) {
                boolean added = false;
                for (List list : stackedCandidates) {
                    List firstCandidateTooltip = ((ItemStack)list.get(0)).func_82840_a(fakeMultiblockBuilder, false);
                    List rawCandidateTooltip = rawCandidate.func_82840_a(fakeMultiblockBuilder, false);
                    if (firstCandidateTooltip.size() <= 1 || rawCandidateTooltip.size() <= 1 || !((String)firstCandidateTooltip.get(1)).equals(rawCandidateTooltip.get(1))) continue;
                    list.add(rawCandidate);
                    added = true;
                    break;
                }
                if (added) continue;
                ArrayList<ItemStack> newStackedCandidate = new ArrayList<ItemStack>();
                newStackedCandidate.add(rawCandidate);
                stackedCandidates.add(newStackedCandidate);
            }
            candidates.addAll(stackedCandidates);
            this.onCandidateChanged.accept(candidates);
            return;
        }
    }

    protected Object getContextObject() {
        return this.renderingController;
    }

    public void setOnCandidateChanged(Consumer<List<List<ItemStack>>> callback) {
        this.onCandidateChanged = callback;
    }

    public List<String> handleTooltip() {
        if (tooltipBlockStack != null) {
            return tooltipBlockStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        return null;
    }

    @SubscribeEvent
    public static void OnStructureEvent(StructureEvent.StructureElementVisitedEvent event) {
        structureElementMap.put(CoordinatePacker.pack((int)event.getX(), (int)event.getY(), (int)event.getZ()), (Object)event.getElement());
    }

    static {
        NO_SELECTED_BLOCK = CoordinatePacker.pack((int)-100000, (int)0, (int)-100000);
        MB_PLACE_POS = new BlockPos(0, 64, 0);
        SELECTED_BLOCK = new BlockPos().set(NO_SELECTED_BLOCK);
        layerIndex = -1;
        structureElementMap = new Long2ObjectOpenHashMap();
        tierIndex = 1;
        scaledSceneHeight = 150;
        channels = new HashSet<String>();
    }
}

