/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component.page;

import net.minecraft.util.StatCollector;
import openmods.Log;

public class BookScaleConfig {
    private static float getValue(String name, float defaultValue) {
        String value = StatCollector.func_74838_a((String)name);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            Log.warn(e, "Failed to parse float value '%s'='%s', returning default %s", name, value, Float.valueOf(defaultValue));
            return defaultValue;
        }
    }

    private static int getValue(String name, int defaultValue) {
        String value = StatCollector.func_74838_a((String)name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Log.warn(e, "Failed to parse integer value '%s'='%s', returning default %s", name, value, defaultValue);
            return defaultValue;
        }
    }

    public static float getPageNumberScale() {
        return BookScaleConfig.getValue("openmodslib.locale.book.scale.pageNumber", 0.5f);
    }

    public static float getSectionTitleScale() {
        return BookScaleConfig.getValue("openmodslib.locale.book.scale.sectionTitle", 2.0f);
    }

    public static float getPageTitleScale() {
        return BookScaleConfig.getValue("openmodslib.locale.book.scale.pageTitle", 1.0f);
    }

    public static float getPageContentScale() {
        return BookScaleConfig.getValue("openmodslib.locale.book.scale.pageContent", 0.5f);
    }

    public static int getTitlePageSeparator() {
        return BookScaleConfig.getValue("openmodslib.locale.book.lineSpace.titledPage", 2);
    }

    public static int getRecipePageSeparator() {
        return BookScaleConfig.getValue("openmodslib.locale.book.lineSpace.recipePage", 4);
    }
}

