/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import java.util.List;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.SymbolGet;
import openmods.calc.UnaryOperator;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.SymbolCallNode;
import openmods.calc.types.multi.ArgUnpackCompilerHelper;
import openmods.calc.types.multi.TypedValue;

public class VarArgSymbolCallNode
extends SymbolCallNode<TypedValue> {
    private final UnaryOperator<TypedValue> unpackMarker;

    public VarArgSymbolCallNode(UnaryOperator<TypedValue> unpackMarker, String symbol, List<? extends IExprNode<TypedValue>> args) {
        super(symbol, args);
        this.unpackMarker = unpackMarker;
    }

    @Override
    public void flatten(final List<IExecutable<TypedValue>> output) {
        new ArgUnpackCompilerHelper(this.unpackMarker){

            @Override
            protected void compileWithVarArgs(int normalArgCount, List<IExecutable<TypedValue>> compiledArgs) {
                output.add(new SymbolGet(VarArgSymbolCallNode.this.symbol));
                output.addAll(compiledArgs);
                output.add(new SymbolCall("applyvar", normalArgCount + 2, 1));
            }

            @Override
            protected void compileWithoutVarArgs(int allArgs, List<IExecutable<TypedValue>> compiledArgs) {
                output.addAll(compiledArgs);
                output.add(new SymbolCall(VarArgSymbolCallNode.this.symbol, allArgs, 1));
            }
        }.compileArgUnpack(this.getChildren());
    }
}

