/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.calc.BinaryOperator;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.UnaryOperator;
import openmods.calc.Value;
import openmods.calc.parsing.BinaryOpNode;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.SymbolCallNode;
import openmods.calc.parsing.SymbolGetNode;
import openmods.calc.parsing.SymbolOpNode;
import openmods.calc.types.multi.ArgUnpackCompilerHelper;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.RawCodeExprNode;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;

public abstract class DotExprNode
extends BinaryOpNode<TypedValue> {
    protected final TypeDomain domain;

    public DotExprNode(IExprNode<TypedValue> left, IExprNode<TypedValue> right, BinaryOperator<TypedValue> operator, TypeDomain domain) {
        super(operator, left, right);
        this.domain = domain;
    }

    protected void flattenMemberGet(List<IExecutable<TypedValue>> output) {
        this.convertSymbolNodeToKey(output, (SymbolGetNode)this.right);
        output.add(this.operator);
    }

    protected void flattenNonTrivialMemberGetNode(List<IExecutable<TypedValue>> output) {
        this.right.flatten(output);
        output.add(this.operator);
    }

    protected void flattenWithNode(List<IExecutable<TypedValue>> output) {
        this.right.flatten(output);
        output.add(new SymbolCall("with", 2, 1));
    }

    protected void convertSymbolNodeToKey(List<IExecutable<TypedValue>> output, SymbolOpNode<TypedValue> target) {
        output.add(Value.create(this.domain.create(String.class, target.symbol())));
    }

    public static class NullAware
    extends DotExprNode {
        public NullAware(IExprNode<TypedValue> left, IExprNode<TypedValue> right, BinaryOperator<TypedValue> operator, TypeDomain domain) {
            super(left, right, operator, domain);
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            this.left.flatten(output);
            ArrayList nonNullOp = Lists.newArrayList();
            this.flattenKeyNode(nonNullOp);
            output.add(Value.create(Code.wrap(this.domain, nonNullOp)));
            output.add(new SymbolCall("nexecute", 2, 1));
        }

        private void flattenKeyNode(List<IExecutable<TypedValue>> output) {
            if (this.right instanceof SymbolCallNode) {
                throw new IllegalStateException("Can't call member with ?., use .?member?()");
            }
            if (this.right instanceof SymbolGetNode) {
                this.flattenMemberGet(output);
            } else if (this.right instanceof RawCodeExprNode) {
                this.flattenWithNode(output);
            } else {
                this.flattenNonTrivialMemberGetNode(output);
            }
        }
    }

    public static class Basic
    extends DotExprNode {
        private final UnaryOperator<TypedValue> unpackMarker;

        public Basic(UnaryOperator<TypedValue> unpackMarker, IExprNode<TypedValue> left, IExprNode<TypedValue> right, BinaryOperator<TypedValue> operator, TypeDomain domain) {
            super(left, right, operator, domain);
            this.unpackMarker = unpackMarker;
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            this.left.flatten(output);
            this.flattenKeyNode(output);
        }

        private void flattenKeyNode(List<IExecutable<TypedValue>> output) {
            if (this.right instanceof SymbolCallNode) {
                this.flattenMemberApplyNode(output);
            } else if (this.right instanceof SymbolGetNode) {
                this.flattenMemberGet(output);
            } else if (this.right instanceof RawCodeExprNode) {
                this.flattenWithNode(output);
            } else {
                this.flattenNonTrivialMemberGetNode(output);
            }
        }

        protected void flattenMemberApplyNode(List<IExecutable<TypedValue>> output) {
            SymbolCallNode call = (SymbolCallNode)this.right;
            this.convertSymbolNodeToKey(output, call);
            output.add(this.operator);
            this.appendSymbolApply(output, call.getChildren());
        }

        private void appendSymbolApply(final List<IExecutable<TypedValue>> output, Iterable<IExprNode<TypedValue>> children) {
            new ArgUnpackCompilerHelper(this.unpackMarker){

                @Override
                protected void compileWithVarArgs(int normalArgCount, List<IExecutable<TypedValue>> compiledArgs) {
                    output.addAll(compiledArgs);
                    output.add(new SymbolCall("applyvar", normalArgCount + 2, 1));
                }

                @Override
                protected void compileWithoutVarArgs(int allArgs, List<IExecutable<TypedValue>> compiledArgs) {
                    output.addAll(compiledArgs);
                    output.add(new SymbolCall("apply", allArgs + 1, 1));
                }
            }.compileArgUnpack(children);
        }
    }
}

