/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.common;

import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.EnderStorageRecipe;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.storage.item.TileEnderChest;
import codechicken.enderstorage.storage.liquid.TileEnderTank;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEnderStorage
extends BlockContainer {
    private RayTracer rayTracer = new RayTracer();

    public BlockEnderStorage() {
        super(Material.field_151576_e);
        this.func_149711_c(20.0f);
        this.func_149752_b(100.0f);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEnderChest();
            }
            case 1: {
                return new TileEnderTank();
            }
        }
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition mop, World world, int x, int y, int z) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_147438_o(x, y, z);
        return this.createItem(world.func_72805_g(x, y, z), tile.freq, tile.owner);
    }

    private ItemStack createItem(int meta, int freq, String owner) {
        ItemStack stack = new ItemStack((Block)this, 1, freq | meta << 12);
        if (!owner.equals("global")) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a("owner", owner);
        }
        return stack;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(world, player, x, y, z, false);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_147438_o(i, j, k);
        if (tile != null) {
            ret.add(this.createItem(meta, tile.freq, EnderStorage.anarchyMode ? "global" : tile.owner));
            if (EnderStorage.anarchyMode && !tile.owner.equals("global")) {
                ret.add(EnderStorage.getPersonalItem());
            }
        }
        return ret;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack item;
        int dye;
        if (world.field_72995_K) {
            return true;
        }
        MovingObjectPosition hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (int)x, (int)y, (int)z);
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_147438_o(x, y, z);
        if (hit == null) {
            return false;
        }
        if (hit.subHit == 4) {
            ItemStack item2 = player.field_71071_by.func_70448_g();
            if (player.func_70093_af() && !tile.owner.equals("global")) {
                if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(EnderStorage.getPersonalItem())) {
                    return false;
                }
                tile.setOwner("global");
                return true;
            }
            if (item2 != null && item2.func_77973_b() == EnderStorage.getPersonalItem().func_77973_b() && tile.owner.equals("global")) {
                tile.setOwner(player.func_70005_c_());
                if (!player.field_71075_bZ.field_75098_d) {
                    --item2.field_77994_a;
                }
                return true;
            }
        } else if (hit.subHit >= 1 && hit.subHit <= 3 && (dye = EnderStorageRecipe.getDyeType(item = player.field_71071_by.func_70448_g())) != -1) {
            int currentfreq = tile.freq;
            int[] colours = EnderStorageManager.getColoursFromFreq(currentfreq);
            if (colours[hit.subHit - 1] == (~dye & 0xF)) {
                return false;
            }
            colours[hit.subHit - 1] = ~dye & 0xF;
            tile.setFreq(EnderStorageManager.getFreqFromColours(colours));
            if (!player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
            }
            return true;
        }
        return tile.activate(player, hit.subHit);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entity, ItemStack item) {
        ((TileFrequencyOwner)world.func_147438_o(i, j, k)).onPlaced(entity);
    }

    public void func_149743_a(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, entity);
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_147438_o(x, y, z);
        return ForgeHooks.blockStrength((Block)(tile.invincible() ? Blocks.field_150357_h : this), (EntityPlayer)player, (World)world, (int)0, (int)0, (int)0);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_147438_o(x, y, z);
        if (tile == null) {
            return null;
        }
        ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>();
        tile.addTraceableCuboids(cuboids);
        return this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(x, y, z), (Block)this);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 4096));
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileFrequencyOwner) {
            return ((TileFrequencyOwner)tile).getLightValue();
        }
        return 0;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.func_149668_a(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && event.player.field_70170_p.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d) == this) {
            RayTracer.retraceBlock((World)event.player.field_70170_p, (EntityPlayer)event.player, (int)event.target.field_72311_b, (int)event.target.field_72312_c, (int)event.target.field_72309_d);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_147438_o(x, y, z);
        return tile.redstoneInteraction();
    }

    public IIcon func_149691_a(int par1, int par2) {
        return Blocks.field_150343_Z.func_149691_a(par1, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int par5) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_147438_o(x, y, z);
        return tile.comparatorInput();
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_147438_o(x, y, z);
        return tile.rotate();
    }
}

