/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.common.config;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.common.config.LGConfigs;
import ru.timeconqueror.timecore.api.common.config.Config;
import ru.timeconqueror.timecore.api.common.config.ConfigSection;

public class ConfigMS
extends Config {
    private static final String NO_CHANGE_FOR_GENERATED = "Won't be changed for already generated Minesweeper boards!";
    public int weight;
    public int detonationTime;
    public int attemptCount;
    public final StageConfig stage1 = new StageConfig(this.getKey(), "stage_1", "Regulates characteristics of stage 1.", new DefaultData(6, 20));
    public final StageConfig stage2 = new StageConfig(this.getKey(), "stage_2", "Regulates characteristics of stage 2.", new DefaultData(7, 30));
    public final StageConfig stage3 = new StageConfig(this.getKey(), "stage_3", "Regulates characteristics of stage 3.", new DefaultData(8, 42));
    public final StageConfig stage4 = new StageConfig(this.getKey(), "stage_4", "Regulates characteristics of stage 4.", new DefaultData(9, 68));

    public ConfigMS() {
        super("minesweeper");
    }

    @Override
    public void init() {
        this.weight = this.config.getInt("weight", this.getKey(), 1, 0, Integer.MAX_VALUE, "How likely this game is chosen compared to other games. The higher this value is, the more likely this game is chosen. Set to 0 to turn this off.");
        this.detonationTime = this.config.getInt("detonation_time", this.getKey(), 60, 0, 600, "The time until bombs start to explode. Represented in ticks.");
        this.attemptCount = this.config.getInt("attempt_count", this.getKey(), 3, 1, Integer.MAX_VALUE, "It represents the number of attempts the player has to beat the game successfully.");
        this.stage1.init(this.config);
        this.stage2.init(this.config);
        this.stage3.init(this.config);
        this.stage4.init(this.config);
        this.config.setCategoryComment(this.getKey(), "Regulates \"Minesweeper\" minigame.");
    }

    public StageConfig getStageByIndex(int index) {
        switch (index) {
            case 1: {
                return this.stage1;
            }
            case 2: {
                return this.stage2;
            }
            case 3: {
                return this.stage3;
            }
            case 4: {
                return this.stage4;
            }
        }
        throw new RuntimeException("Provided unknown stage config index " + index + ", please contact with mod author.");
    }

    @Override
    public String getRelativePath() {
        return LGConfigs.resolve("games/" + this.getKey());
    }

    public Snapshot snapshot() {
        return new Snapshot(this.stage1.snapshot(), this.stage2.snapshot(), this.stage3.snapshot(), this.stage4.snapshot());
    }

    public static class Snapshot {
        private final StageSnapshot stage1;
        private final StageSnapshot stage2;
        private final StageSnapshot stage3;
        private final StageSnapshot stage4;

        private Snapshot(StageSnapshot stage1, StageSnapshot stage2, StageSnapshot stage3, StageSnapshot stage4) {
            this.stage1 = stage1;
            this.stage2 = stage2;
            this.stage3 = stage3;
            this.stage4 = stage4;
        }

        public static NBTTagCompound serialize(Snapshot snapshot) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("stage_1", (NBTBase)StageSnapshot.serialize(snapshot.stage1));
            compound.func_74782_a("stage_2", (NBTBase)StageSnapshot.serialize(snapshot.stage2));
            compound.func_74782_a("stage_3", (NBTBase)StageSnapshot.serialize(snapshot.stage3));
            compound.func_74782_a("stage_4", (NBTBase)StageSnapshot.serialize(snapshot.stage4));
            return compound;
        }

        public static Snapshot deserialize(NBTTagCompound serialized) {
            return new Snapshot(StageSnapshot.deserialize(serialized.func_74775_l("stage_1")), StageSnapshot.deserialize(serialized.func_74775_l("stage_2")), StageSnapshot.deserialize(serialized.func_74775_l("stage_3")), StageSnapshot.deserialize(serialized.func_74775_l("stage_4")));
        }

        public static Snapshot stub() {
            return new Snapshot(StageSnapshot.stub(), StageSnapshot.stub(), StageSnapshot.stub(), StageSnapshot.stub());
        }

        public StageSnapshot getStage1() {
            return this.stage1;
        }

        public StageSnapshot getStage2() {
            return this.stage2;
        }

        public StageSnapshot getStage3() {
            return this.stage3;
        }

        public StageSnapshot getStage4() {
            return this.stage4;
        }

        public StageSnapshot getStageByIndex(int index) {
            switch (index) {
                case 1: {
                    return this.stage1;
                }
                case 2: {
                    return this.stage2;
                }
                case 3: {
                    return this.stage3;
                }
                case 4: {
                    return this.stage4;
                }
            }
            throw new RuntimeException("Provided unknown stage snapshot index " + index + ", please contact with mod author.");
        }

        public static class StageSnapshot {
            private final int bombCount;
            private final int boardSize;

            private StageSnapshot(int bombCount, int boardSize) {
                this.bombCount = bombCount;
                this.boardSize = boardSize;
            }

            public int getBoardSize() {
                return this.boardSize;
            }

            public int getBombCount() {
                return this.bombCount;
            }

            private static NBTTagCompound serialize(StageSnapshot snapshot) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("bomb_count", snapshot.bombCount);
                compound.func_74768_a("board_size", snapshot.boardSize);
                return compound;
            }

            private static StageSnapshot deserialize(NBTTagCompound nbt) {
                return new StageSnapshot(nbt.func_74762_e("bomb_count"), nbt.func_74762_e("board_size"));
            }

            private static StageSnapshot stub() {
                return new StageSnapshot(0, 0);
            }
        }
    }

    private static class DefaultData {
        private final int boardRadius;
        private final int bombCount;

        private DefaultData(int boardRadius, int bombCount) {
            this.boardRadius = boardRadius;
            this.bombCount = bombCount;
        }
    }

    public static class StageConfig
    extends ConfigSection {
        private int bombCount;
        private int boardRadius;
        private final DefaultData defData;

        public StageConfig(String parentKey, String key, String comment, DefaultData defData) {
            super(parentKey, key, comment);
            this.defData = defData;
        }

        public Snapshot.StageSnapshot snapshot() {
            return new Snapshot.StageSnapshot(this.bombCount, this.getBoardSize());
        }

        @Override
        public void init(Configuration config) {
            this.boardRadius = config.getInt("board_radius", this.getCategoryName(), this.defData.boardRadius, 2, 9, "The radius of Minesweeper board. Won't be changed for already generated Minesweeper boards!");
            this.bombCount = config.getInt("bomb_count", this.getCategoryName(), this.defData.bombCount, 1, Integer.MAX_VALUE, "The amount of bombs on the board. Bomb count must be strictly less than amount of game fields (board_radius ^ 2). ", ConfigMS.NO_CHANGE_FOR_GENERATED);
            int boardSize = this.getBoardSize();
            if (this.bombCount > boardSize * boardSize - 1) {
                LootGames.LOGGER.warn("Bomb count must be strictly less than amount of game fields. Current values: bomb count = {}, field count: {} (board size = {}, board radius = {})\n Bomb count was switched to {}.", new Object[]{this.bombCount, boardSize * boardSize, boardSize, boardSize * boardSize - 2, this.boardRadius});
                this.bombCount = boardSize * boardSize - 2;
            }
            config.setCategoryComment(this.getCategoryName(), this.getComment());
        }

        public int getBoardSize() {
            return this.boardRadius * 2 + 1;
        }
    }
}

