/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message.handlers;

import chylex.hee.api.message.MessageHandler;
import chylex.hee.api.message.MessageRunner;
import chylex.hee.api.message.element.IntValue;
import chylex.hee.api.message.element.ItemPatternValue;
import chylex.hee.api.message.element.ItemStackValue;
import chylex.hee.api.message.element.StringValue;
import chylex.hee.api.message.handlers.ImcHandler;
import chylex.hee.api.message.utils.MessageLogger;
import chylex.hee.api.message.utils.RunEvent;
import chylex.hee.mechanics.essence.handler.DragonEssenceHandler;
import chylex.hee.mechanics.essence.handler.dragon.AltarItemRecipe;
import chylex.hee.system.util.ItemPattern;
import java.util.Iterator;
import net.minecraft.item.ItemStack;

public final class ImcEssenceHandlers
extends ImcHandler {
    private static final MessageHandler dragonEssenceAdd = new MessageHandler(){

        @Override
        public void call(MessageRunner runner) {
            ItemStack input = (ItemStack)runner.getValue("input");
            for (AltarItemRecipe recipe : DragonEssenceHandler.recipes) {
                if (!ItemStack.func_77989_b((ItemStack)recipe.input, (ItemStack)input) || !ItemStack.func_77970_a((ItemStack)recipe.input, (ItemStack)input)) continue;
                MessageLogger.logFail("Duplicate input item, ignoring.", new Object[0]);
                return;
            }
            DragonEssenceHandler.recipes.add(new AltarItemRecipe(input, (ItemStack)runner.getValue("output"), runner.getInt("cost")));
            MessageLogger.logOk("Added 1 recipe.", new Object[0]);
        }
    };
    private static final MessageHandler dragonEssenceRemove = new MessageHandler(){

        @Override
        public void call(MessageRunner runner) {
            boolean input = runner.getString("type").equals("input");
            ItemPattern pattern = (ItemPattern)runner.getValue("search");
            int limit = runner.getInt("limit");
            int size = DragonEssenceHandler.recipes.size();
            Iterator<AltarItemRecipe> iter = DragonEssenceHandler.recipes.iterator();
            while (iter.hasNext()) {
                AltarItemRecipe recipe = iter.next();
                if (!pattern.matches(input ? recipe.input : recipe.output)) continue;
                iter.remove();
                if (limit <= 0 || --limit != 0) continue;
                break;
            }
            if ((size -= DragonEssenceHandler.recipes.size()) == 0) {
                MessageLogger.logWarn("Did not find any items to remove.", new Object[0]);
            } else {
                MessageLogger.logOk("Removed $0 item(s).", size);
            }
        }
    };

    @Override
    public void register() {
        this.register("HEE:DragonEssence:AddRecipe", dragonEssenceAdd, RunEvent.POSTINIT).addProp("input", ItemStackValue.any()).addProp("output", ItemStackValue.any()).addProp("cost", IntValue.positive());
        this.register("HEE:DragonEssence:RemoveRecipe", dragonEssenceRemove, RunEvent.POSTINIT).addProp("type", StringValue.one("input", "output")).addProp("search", ItemPatternValue.any()).addProp("limit", IntValue.positiveOrZero());
    }
}

