/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Potions;

import java.util.Arrays;
import lumien.randomthings.Configuration.RTConfiguration;
import lumien.randomthings.Library.PotionIds;
import lumien.randomthings.Mixins.Minecraft.PotionAccessor;
import lumien.randomthings.Potions.PotionImbue;
import lumien.randomthings.RandomThings;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class ModPotions {
    public static Potion imbuePoison;
    public static Potion imbueExperience;
    public static Potion imbueFire;
    public static Potion imbueWither;
    public static Potion imbueWeakness;
    public static Potion imbueSpectre;
    public static int[] imbueColors;

    public static void init() {
        PotionIds.IMBUE_POISON = ModPotions.checkPotionID(RTConfiguration.piImbuePoison).getInt();
        imbuePoison = ModPotions.getImbue("poison", PotionIds.IMBUE_POISON, imbueColors[0]);
        PotionIds.IMBUE_EXPERIENCE = ModPotions.checkPotionID(RTConfiguration.piImbueExperience).getInt();
        imbueExperience = ModPotions.getImbue("experience", PotionIds.IMBUE_EXPERIENCE, imbueColors[1]);
        PotionIds.IMBUE_FIRE = ModPotions.checkPotionID(RTConfiguration.piImbueFire).getInt();
        imbueFire = ModPotions.getImbue("fire", PotionIds.IMBUE_FIRE, imbueColors[2]);
        PotionIds.IMBUE_WITHER = ModPotions.checkPotionID(RTConfiguration.piImbueWither).getInt();
        imbueWither = ModPotions.getImbue("wither", PotionIds.IMBUE_WITHER, imbueColors[3]);
        PotionIds.IMBUE_WEAKNESS = ModPotions.checkPotionID(RTConfiguration.piImbueWeakness).getInt();
        imbueWeakness = ModPotions.getImbue("weakness", PotionIds.IMBUE_WEAKNESS, imbueColors[4]);
        PotionIds.IMBUE_SPECTRE = ModPotions.checkPotionID(RTConfiguration.piImbueSpectre).getInt();
        imbueSpectre = ModPotions.getImbue("spectre", PotionIds.IMBUE_SPECTRE, imbueColors[5]);
    }

    private static PotionImbue getImbue(String name, int id, int color) {
        return new PotionImbue("imbue." + name, id, color, new ResourceLocation("randomthings:textures/gui/imbueEffects/" + name + ".png"));
    }

    public static Property checkPotionID(Property p) {
        int id = p.getInt();
        int freeID = ModPotions.getFreePotionID();
        if (id == -1) {
            RandomThings.instance.logger.log(Level.INFO, "Auto Resolved " + p.getName() + " ID to " + freeID);
            p.set(freeID);
            RTConfiguration.syncConfig();
            return p;
        }
        if (Potion.field_76425_a.length - 1 < id) {
            ModPotions.resizePotionArray(id + 1);
        }
        if (Potion.field_76425_a[id] == null) {
            return p;
        }
        RandomThings.instance.logger.log(Level.INFO, "PotionID " + id + " is already occupied by " + Potion.field_76425_a[id].func_76393_a());
        p.set(freeID);
        RTConfiguration.syncConfig();
        RandomThings.instance.logger.log(Level.INFO, "Moved Potion from " + id + " to " + freeID);
        return p;
    }

    public static void resizePotionArray(int newSize) {
        PotionAccessor.setPotionTypes(Arrays.copyOf(Potion.field_76425_a, newSize));
    }

    public static int getFreePotionID() {
        for (int i = 1; i < Potion.field_76425_a.length; ++i) {
            if (Potion.field_76425_a[i] != null) continue;
            return i;
        }
        int oldLength = Potion.field_76425_a.length;
        ModPotions.resizePotionArray(Potion.field_76425_a.length + 1);
        return oldLength;
    }

    static {
        imbueColors = new int[]{10145074, 14214234, 16729344, 0x3B3B3B, 0xFFFFFF, 0xBFEFFF};
    }
}

