/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge.color;

import com.cleanroommc.modularui.utils.Color;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.Nullable;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.multi.godforge.color.StarColorSetting;

public class ForgeOfGodsStarColor {
    private static final int LATEST_VERSION = 1;
    private static final Map<String, ForgeOfGodsStarColor> PRESETS = new LinkedHashMap<String, ForgeOfGodsStarColor>(4);
    public static final int DEFAULT_RED = 179;
    public static final int DEFAULT_GREEN = 204;
    public static final int DEFAULT_BLUE = 255;
    public static final float DEFAULT_GAMMA = 3.0f;
    public static final ForgeOfGodsStarColor DEFAULT = new ForgeOfGodsStarColor("Default").addColor(179, 204, 255, 3.0f).registerPreset();
    public static final ForgeOfGodsStarColor RAINBOW = new ForgeOfGodsStarColor("Rainbow").addColor(255, 0, 0, 3.0f).addColor(255, 255, 0, 3.0f).addColor(0, 255, 0, 3.0f).addColor(0, 255, 255, 3.0f).addColor(255, 0, 255, 3.0f).setCycleSpeed(1).setCustomDrawable((IDrawable)TecTechUITextures.PICTURE_RAINBOW_SQUARE).registerPreset();
    public static final ForgeOfGodsStarColor CLOUD_PICK = new ForgeOfGodsStarColor("Cloud's Pick").addColor(179, 204, 255, 3.0f).registerPreset();
    public static final ForgeOfGodsStarColor MAYA_PICK = new ForgeOfGodsStarColor("Maya's Pick").addColor(91, 206, 250, 3.0f).addColor(245, 169, 184, 3.0f).addColor(255, 255, 255, 3.0f).setCycleSpeed(1).registerPreset();
    private String name;
    private final int version;
    private boolean isPreset;
    private IDrawable drawable;
    private final List<StarColorSetting> settings = new ArrayList<StarColorSetting>();
    private int cycleSpeed = 1;

    public static List<ForgeOfGodsStarColor> getDefaultColors() {
        return new ArrayList<ForgeOfGodsStarColor>(PRESETS.values());
    }

    protected ForgeOfGodsStarColor(String name) {
        this(name, 1);
    }

    private ForgeOfGodsStarColor(String name, int version) {
        this.name = name;
        this.version = version;
    }

    private ForgeOfGodsStarColor registerPreset() {
        this.isPreset = true;
        PRESETS.put(this.getName(), this);
        return this;
    }

    public boolean isPresetColor() {
        return this.isPreset;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ForgeOfGodsStarColor setCycleSpeed(int speed) {
        this.cycleSpeed = speed;
        return this;
    }

    public int getCycleSpeed() {
        return this.cycleSpeed;
    }

    public ForgeOfGodsStarColor addColor(int r, int g, int b, float gamma) {
        this.settings.add(new StarColorSetting(r, g, b, gamma));
        return this;
    }

    public ForgeOfGodsStarColor addColor(StarColorSetting color) {
        this.settings.add(color);
        return this;
    }

    private ForgeOfGodsStarColor addColors(List<StarColorSetting> colors) {
        this.settings.addAll(colors);
        return this;
    }

    public int numColors() {
        return this.settings.size();
    }

    public StarColorSetting getColor(int index) {
        return this.settings.get(index);
    }

    public void setColor(int index, StarColorSetting color) {
        this.settings.set(index, color);
    }

    public void removeColor(int index) {
        this.settings.remove(index);
    }

    public ForgeOfGodsStarColor setCustomDrawable(IDrawable drawable) {
        this.drawable = drawable;
        return this;
    }

    public IDrawable getDrawable() {
        if (this.drawable == null) {
            StarColorSetting setting = this.settings.get(0);
            this.drawable = new Rectangle().setColor(Color.rgb((int)setting.getColorR(), (int)setting.getColorG(), (int)setting.getColorB()));
        }
        return this.drawable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForgeOfGodsStarColor that = (ForgeOfGodsStarColor)o;
        if (this.cycleSpeed != that.cycleSpeed) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.settings.size() != that.settings.size()) {
            return false;
        }
        for (int i = 0; i < this.settings.size(); ++i) {
            StarColorSetting thatSetting;
            StarColorSetting thisSetting = this.settings.get(i);
            if (thisSetting.equals(thatSetting = that.settings.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.serializeToString();
    }

    public NBTTagCompound serializeToNBT() {
        NBTTagCompound NBT2 = new NBTTagCompound();
        if (this.isPresetColor()) {
            NBT2.func_74778_a("Preset", this.getName());
            return NBT2;
        }
        NBT2.func_74778_a("Name", this.getName());
        NBT2.func_74768_a("CycleSpeed", this.cycleSpeed);
        NBT2.func_74768_a("Version", this.version);
        if (!this.settings.isEmpty()) {
            NBTTagCompound settingsNBT = new NBTTagCompound();
            settingsNBT.func_74768_a("Size", this.settings.size());
            for (int i = 0; i < this.settings.size(); ++i) {
                StarColorSetting setting = this.settings.get(i);
                settingsNBT.func_74782_a(Integer.toString(i), (NBTBase)setting.serialize());
            }
            NBT2.func_74782_a("Settings", (NBTBase)settingsNBT);
        }
        return NBT2;
    }

    public static ForgeOfGodsStarColor deserialize(NBTTagCompound NBT2) {
        if (NBT2.func_74764_b("Preset")) {
            return PRESETS.get(NBT2.func_74779_i("Preset"));
        }
        ForgeOfGodsStarColor color = new ForgeOfGodsStarColor(NBT2.func_74779_i("Name"));
        color.setCycleSpeed(NBT2.func_74762_e("CycleSpeed"));
        if (NBT2.func_74764_b("Settings")) {
            NBTTagCompound settingsNBT = NBT2.func_74775_l("Settings");
            int size = settingsNBT.func_74762_e("Size");
            for (int i = 0; i < size; ++i) {
                NBTTagCompound colorNBT = settingsNBT.func_74775_l(Integer.toString(i));
                StarColorSetting setting = StarColorSetting.deserialize(colorNBT);
                color.settings.add(setting);
            }
        }
        return color;
    }

    public String serializeToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StarColorV1:{");
        sb.append("Name:");
        sb.append(this.getName());
        sb.append(",Cycle:");
        sb.append(this.getCycleSpeed());
        for (StarColorSetting setting : this.settings) {
            sb.append("|");
            sb.append("r:");
            sb.append(setting.getColorR());
            sb.append(",g:");
            sb.append(setting.getColorG());
            sb.append(",b:");
            sb.append(setting.getColorB());
            sb.append(",m:");
            sb.append(setting.getGamma());
        }
        sb.append("}");
        return sb.toString();
    }

    @Nullable
    public static ForgeOfGodsStarColor deserialize(String raw) {
        if (raw == null) {
            return null;
        }
        if (!raw.startsWith("StarColorV1:{") || !raw.endsWith("}")) {
            return null;
        }
        try {
            String[] data = raw.substring(13, raw.length() - 1).split("\\|");
            String header = data[0];
            String[] headerData = header.split(",");
            String name = null;
            if (headerData[0].startsWith("Name:")) {
                name = headerData[0].substring(5);
            }
            Integer cycleRate = null;
            if (headerData[1].startsWith("Cycle:")) {
                cycleRate = Integer.valueOf(headerData[1].substring(6));
            }
            ArrayList<StarColorSetting> colorSettings = new ArrayList<StarColorSetting>();
            for (int i = 1; i < data.length; ++i) {
                String[] colorData = data[i].split(",");
                int r = -1;
                int g = -1;
                int b = -1;
                float m = -1.0f;
                block15: for (String color : colorData) {
                    String[] singleData = color.split(":");
                    switch (singleData[0]) {
                        case "r": {
                            r = Integer.parseInt(singleData[1]);
                            continue block15;
                        }
                        case "g": {
                            g = Integer.parseInt(singleData[1]);
                            continue block15;
                        }
                        case "b": {
                            b = Integer.parseInt(singleData[1]);
                            continue block15;
                        }
                        case "m": {
                            m = Float.parseFloat(singleData[1]);
                        }
                    }
                }
                if (r == -1 || g == -1 || b == -1 || m == -1.0f) continue;
                colorSettings.add(new StarColorSetting(r, g, b, m));
            }
            if (name != null && cycleRate != null && !colorSettings.isEmpty()) {
                return new ForgeOfGodsStarColor(name).setCycleSpeed(cycleRate).addColors(colorSettings);
            }
            return null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static void writeToBuffer(PacketBuffer buf, ForgeOfGodsStarColor color) {
        buf.writeBoolean(color == null);
        if (color != null) {
            buf.writeBoolean(color.isPresetColor());
            try {
                buf.func_150785_a(color.name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!color.isPresetColor()) {
                buf.writeInt(color.cycleSpeed);
                buf.writeInt(color.settings.size());
                for (StarColorSetting setting : color.settings) {
                    StarColorSetting.writeToBuffer(buf, setting);
                }
            }
        }
    }

    public static ForgeOfGodsStarColor readFromBuffer(PacketBuffer buf) {
        String name;
        if (buf.readBoolean()) {
            return null;
        }
        boolean isPresetColor = buf.readBoolean();
        try {
            name = buf.func_150789_c(Short.MAX_VALUE);
        }
        catch (IOException ignored) {
            return null;
        }
        if (isPresetColor) {
            return PRESETS.get(name);
        }
        ForgeOfGodsStarColor color = new ForgeOfGodsStarColor(name);
        color.setCycleSpeed(buf.readInt());
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            color.addColor(StarColorSetting.readFromBuffer(buf));
        }
        return color;
    }
}

