/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;
import tectech.recipe.TecTechRecipeMaps;
import tectech.thing.metaTileEntity.multi.godforge.MTEBaseModule;

public class MTEMoltenModule
extends MTEBaseModule {
    private long EUt = 0L;
    private int currentParallel = 0;
    long wirelessEUt = 0L;

    public MTEMoltenModule(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMoltenModule(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMoltenModule(this.mName);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (recipe.mSpecialValue > MTEMoltenModule.this.getHeat()) {
                    return CheckRecipeResultRegistry.insufficientHeat(recipe.mSpecialValue);
                }
                if ((long)recipe.mEUt > MTEMoltenModule.this.getProcessingVoltage()) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                MTEMoltenModule.this.wirelessEUt = (long)recipe.mEUt * (long)MTEMoltenModule.this.getMaxParallel();
                if (WirelessNetworkManager.getUserEU(MTEMoltenModule.this.userUUID).compareTo(BigInteger.valueOf(MTEMoltenModule.this.wirelessEUt * (long)recipe.mDuration)) < 0) {
                    return CheckRecipeResultRegistry.insufficientPower(MTEMoltenModule.this.wirelessEUt * (long)recipe.mDuration);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(MTEMoltenModule.this.getProcessingVoltage()).setRecipeHeat(recipe.mSpecialValue).setHeatOC(true).setHeatDiscount(true).setMachineHeat(Math.max(recipe.mSpecialValue, MTEMoltenModule.this.getHeatForOC())).setHeatDiscountMultiplier(MTEMoltenModule.this.getHeatEnergyDiscount()).setDurationDecreasePerOC(MTEMoltenModule.this.getOverclockTimeFactor());
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@Nonnull GTRecipe recipe) {
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap(MTEMoltenModule.this.userUUID, -this.calculatedEut * (long)this.duration)) {
                    return CheckRecipeResultRegistry.insufficientPower(this.calculatedEut * (long)this.duration);
                }
                MTEMoltenModule.this.addToPowerTally(BigInteger.valueOf(this.calculatedEut).multiply(BigInteger.valueOf(this.duration)));
                MTEMoltenModule.this.addToRecipeTally(this.calculatedParallels);
                MTEMoltenModule.this.currentParallel = this.calculatedParallels;
                MTEMoltenModule.this.EUt = this.calculatedEut;
                this.setCalculatedEut(0L);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(Integer.MAX_VALUE);
        logic.setAmperageOC(false);
        logic.setMaxParallel(this.getMaxParallel());
        logic.setSpeedBonus(this.getSpeedBonus());
        logic.setEuModifier(this.getEnergyDiscount());
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return TecTechRecipeMaps.godforgeMoltenRecipes;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>();
        str.add("Progress: " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s");
        str.add("Currently using: " + EnumChatFormatting.RED + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.EUt) : "0") + EnumChatFormatting.RESET + " EU/t");
        str.add(EnumChatFormatting.YELLOW + "Max Parallel: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getMaxParallel()));
        str.add(EnumChatFormatting.YELLOW + "Current Parallel: " + EnumChatFormatting.RESET + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.currentParallel) : "0"));
        str.add(EnumChatFormatting.YELLOW + "Heat Capacity: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getHeat()));
        str.add(EnumChatFormatting.YELLOW + "Effective Heat Capacity: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getHeatForOC()));
        str.add(EnumChatFormatting.YELLOW + "Recipe time multiplier: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getSpeedBonus()));
        str.add(EnumChatFormatting.YELLOW + "Energy multiplier: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getEnergyDiscount()));
        str.add(EnumChatFormatting.YELLOW + "Recipe time divisor per non-perfect OC: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getOverclockTimeFactor()));
        return str.toArray(new String[0]);
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Blast Smelter").addInfo("This is a module of the Godforge.").addInfo("Must be part of a Godforge to function.").addInfo("Used for high temperature material liquefaction.").addSeparator(EnumChatFormatting.AQUA, 74).addInfo("The second module of the Godforge, this module melts materials directly into").addInfo("their liquid form. If an output material does not have a liquid form, it will be output").addInfo("as a regular solid instead.").addInfo("This module is specialized towards parallel processing.").beginStructureBlock(7, 7, 13, false).addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Singularity Reinforced Stellar Shielding Casing").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Boundless Gravitationally Severed Structure Casing").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Harmonic Phonon Transmission Conduit").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Celestial Matter Guidance Casing").addStructureInfo(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Stellar Energy Siphon Casing").toolTipFinisher(EnumChatFormatting.AQUA, 74, new String[0]);
        return tt;
    }
}

