/*
 * Decompiled with CFR 0.152.
 */
package kekztech.common.tileentities;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEFluidStack;
import appeng.util.item.FluidList;
import cpw.mods.fml.common.Optional;
import gregtech.api.enums.Textures;
import gregtech.api.fluid.GTFluidTank;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import java.util.HashMap;
import kekztech.common.tileentities.MTETankTFFT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

@Optional.Interface(iface="appeng.api.storage.IMEMonitor", modid="appliedenergistics2", striprefs=true)
public class MTEHatchTFFT
extends MTEHatch
implements IMEMonitor<IAEFluidStack> {
    private static final Textures.BlockIcons.CustomIcon TEXTURE_TFFT_HATCH = new Textures.BlockIcons.CustomIcon("iconsets/TFFT_HATCH");
    private HashMap<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> listeners = new HashMap();
    private MTETankTFFT controller;

    public MTEHatchTFFT(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 3, 0, "All-in-one access for the T.F.F.T", new ITexture[0]);
    }

    public MTEHatchTFFT(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        return super.getTexture(aBaseMetaTileEntity, side, facing, colorIndex, aActive, aRedstone);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.builder().addIcon(TEXTURE_TFFT_HATCH).extFacing().build()};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.builder().addIcon(TEXTURE_TFFT_HATCH).extFacing().build()};
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchTFFT(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.controller != null ? this.controller.pull(resource, doFill) : 0;
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.controller != null) {
            GTFluidTank sFluid = this.controller.getSelectedFluid();
            if (this.controller.getFluidSelector() == -1 || sFluid != null && sFluid.contains(resource)) {
                return this.controller.push(resource, doDrain);
            }
        }
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.controller != null) {
            GTFluidTank sFluid = this.controller.getSelectedFluid();
            if (this.controller.getFluidSelector() == -1) {
                return this.controller.push(maxDrain, doDrain);
            }
            if (sFluid != null) {
                return this.controller.push(sFluid.get(maxDrain), doDrain);
            }
        }
        return null;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.controller != null ? this.controller.getTankInfo() : null;
    }

    public void bind(MTETankTFFT controller) {
        this.controller = controller;
    }

    public void unbind() {
        this.controller = null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public static void registerAEIntegration() {
        AEApi.instance().registries().externalStorage().addExternalStorageInterface((IExternalStorageHandler)new AE2TFFTHatchHandler());
    }

    @Optional.Method(modid="appliedenergistics2")
    public IItemList<IAEFluidStack> getAvailableItems(IItemList out, int iteration) {
        if (this.controller != null) {
            for (int i = 0; i < 25; ++i) {
                if (this.controller.STORE[i].isEmpty()) continue;
                AEFluidStack s = AEFluidStack.create((Object)this.controller.STORE[i].get());
                s.setStackSize(this.controller.STORE[i].amount());
                out.add((IAEStack)s);
            }
        }
        return out;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IItemList<IAEFluidStack> getStorageList() {
        FluidList fluidList = new FluidList();
        if (this.controller != null) {
            for (int i = 0; i < 25; ++i) {
                if (this.controller.STORE[i].isEmpty()) continue;
                AEFluidStack s = AEFluidStack.create((Object)this.controller.STORE[i].get());
                s.setStackSize(this.controller.STORE[i].amount());
                fluidList.add((IAEStack)s);
            }
        }
        return fluidList;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void addListener(IMEMonitorHandlerReceiver<IAEFluidStack> l, Object verificationToken) {
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        this.listeners.put(l, verificationToken);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void removeListener(IMEMonitorHandlerReceiver<IAEFluidStack> l) {
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        this.listeners.remove(l);
    }

    @Optional.Method(modid="appliedenergistics2")
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isPrioritized(IAEFluidStack input) {
        if (this.controller == null || input == null) {
            return false;
        }
        return this.controller.contains(input.getFluidStack()) || this.controller.fluidCount() < 25;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean canAccept(IAEFluidStack input) {
        if (this.controller == null || input == null) {
            return false;
        }
        return this.controller.contains(input.getFluidStack()) || this.controller.fluidCount() < 25;
    }

    @Optional.Method(modid="appliedenergistics2")
    public int getPriority() {
        return 0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public int getSlot() {
        return 0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean validForPass(int i) {
        return true;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        long amount;
        FluidStack inputStack = input.getFluidStack();
        if (inputStack == null) {
            return null;
        }
        if (this.controller == null || this.getBaseMetaTileEntity() == null) {
            return input;
        }
        if (mode != Actionable.SIMULATE) {
            this.getBaseMetaTileEntity().func_70296_d();
        }
        if ((amount = this.controller.pull(input.getFluidStack(), input.getStackSize(), mode != Actionable.SIMULATE)) == 0L) {
            return input;
        }
        if (amount == input.getStackSize()) {
            return null;
        }
        AEFluidStack result = AEFluidStack.create((Object)input.getFluidStack());
        result.setStackSize(input.getStackSize() - amount);
        return result;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        long amount;
        if (this.controller == null || this.getBaseMetaTileEntity() == null) {
            return null;
        }
        if (mode != Actionable.SIMULATE) {
            this.getBaseMetaTileEntity().func_70296_d();
        }
        if ((amount = this.controller.push(request.getFluidStack(), request.getStackSize(), mode != Actionable.SIMULATE)) == 0L) {
            return null;
        }
        if (amount == request.getStackSize()) {
            return request.copy();
        }
        AEFluidStack result = AEFluidStack.create((Object)request.getFluidStack());
        result.setStackSize(amount);
        return result;
    }

    @Optional.Method(modid="appliedenergistics2")
    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    @Optional.Interface(iface="appeng.api.storage.IExternalStorageHandler", modid="appliedenergistics2", striprefs=true)
    private static class AE2TFFTHatchHandler
    implements IExternalStorageHandler {
        private AE2TFFTHatchHandler() {
        }

        @Optional.Method(modid="appliedenergistics2")
        public boolean canHandle(TileEntity te, ForgeDirection d, StorageChannel channel, BaseActionSource mySrc) {
            return channel == StorageChannel.FLUIDS && te instanceof BaseMetaTileEntity && ((BaseMetaTileEntity)te).getMetaTileEntity() instanceof MTEHatchTFFT;
        }

        @Optional.Method(modid="appliedenergistics2")
        public IMEInventory getInventory(TileEntity te, ForgeDirection d, StorageChannel channel, BaseActionSource src) {
            if (channel == StorageChannel.FLUIDS) {
                return (MTEHatchTFFT)((BaseMetaTileEntity)te).getMetaTileEntity();
            }
            return null;
        }
    }
}

