/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.mega;

import bartworks.API.BorosilicateGlass;
import bartworks.util.BWTooltipReference;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEMegaAlloyBlastSmelter
extends MTEExtendedPowerMultiBlockBase<MTEMegaAlloyBlastSmelter>
implements ISurvivalConstructable {
    private static final int MAX_PARALLELS = 256;
    private HeatingCoilLevel coilLevel;
    private byte glassTier = (byte)-1;
    private double speedBonus = 1.0;
    private double energyDiscount = 1.0;
    private boolean hasNormalCoils;
    private static final IStructureDefinition<MTEMegaAlloyBlastSmelter> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "   DDDDD   ", "   CCCCC   ", "   AEEEA   ", "   AE~EA   ", "   AEEEA   ", "   CCCCC   ", "   ZZZZZ   "}, {"   DDDDD   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   DDDDD   ", "  D     D  ", "  C     C  ", "  A     A  ", "  A     A  ", "  A     A  ", "  C     C  ", "  ZZZZZZZ  "}, {"  DDDDDDD  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  DBBBBBD  ", " D BBBBB D ", " C BBBBB C ", " A BBBBB A ", " A BBBBB A ", " A BBBBB A ", " C BBBBB C ", " ZZZZZZZZZ "}, {" DDDDDDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {" DDDDDDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {" DDDDFDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {" DDDDDDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {" DDDDDDDDD ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " AB     BA ", " DB     BD ", "D B     B D", "C B     B C", "A B     B A", "A B     B A", "A B     B A", "C B     B C", "ZZZZZZZZZZZ"}, {"  DDDDDDD  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  ABBBBBA  ", "  DBBBBBD  ", " D BBBBB D ", " C BBBBB C ", " A BBBBB A ", " A BBBBB A ", " A BBBBB A ", " C BBBBB C ", " ZZZZZZZZZ "}, {"   DDDDD   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   DDDDD   ", "  D     D  ", "  C     C  ", "  A     A  ", "  A     A  ", "  A     A  ", "  C     C  ", "  ZZZZZZZ  "}, {"           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "           ", "   DDDDD   ", "   CCCCC   ", "   AAAAA   ", "   AAAAA   ", "   AAAAA   ", "   CCCCC   ", "   ZZZZZ   "}}).addElement('B', StructureUtility.withChannel((String)"coil", (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(te -> {
        te.hasNormalCoils = false;
    }, GTStructureUtility.ofCoil(MTEMegaAlloyBlastSmelter::setCoilLevel, MTEMegaAlloyBlastSmelter::getCoilLevel)), StructureUtility.onElementPass(te -> {
        te.hasNormalCoils = true;
    }, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)14))}))).addElement('Z', GTStructureUtility.buildHatchAdder(MTEMegaAlloyBlastSmelter.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Energy, HatchElement.ExoticEnergy).casingIndex(TAE.GTPP_INDEX(15)).dot(1).buildAndChain(StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)15))).addElement('E', GTStructureUtility.buildHatchAdder(MTEMegaAlloyBlastSmelter.class).atLeast(HatchElement.Maintenance).casingIndex(TAE.GTPP_INDEX(15)).dot(2).buildAndChain(StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)15))).addElement('D', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)15)).addElement('C', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)14)).addElement('A', StructureUtility.withChannel((String)"glass", BorosilicateGlass.ofBoroGlass((byte)-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier))).addElement('F', HatchElement.Muffler.newAny(TAE.GTPP_INDEX(15), 3)).build();

    public MTEMegaAlloyBlastSmelter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMegaAlloyBlastSmelter(String aName) {
        super(aName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (MTEMegaAlloyBlastSmelter.this.glassTier < GTUtility.getTier(recipe.mEUt)) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(GTUtility.getTier(recipe.mEUt));
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                MTEMegaAlloyBlastSmelter.this.calculateEnergyDiscount(MTEMegaAlloyBlastSmelter.this.coilLevel, recipe);
                return super.createOverclockCalculator(recipe).setSpeedBoost(MTEMegaAlloyBlastSmelter.this.speedBonus).setEUtDiscount(MTEMegaAlloyBlastSmelter.this.energyDiscount);
            }
        }.setMaxParallel(256);
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getMaxInputEu());
        logic.setAvailableAmperage(1L);
    }

    @Override
    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        boolean exotic = this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || exotic;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.glassTier = (byte)-1;
        this.coilLevel = HeatingCoilLevel.None;
        if (!this.checkPiece("main", 5, 16, 0)) {
            return false;
        }
        if (this.hasNormalCoils) {
            this.coilLevel = HeatingCoilLevel.None;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (this.mMufflerHatches.size() != 1) {
            return false;
        }
        if (this.glassTier < 10 && !this.getExoticAndNormalEnergyHatchList().isEmpty()) {
            for (MTEHatch hatchEnergy : this.getExoticAndNormalEnergyHatchList()) {
                if (this.glassTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        if (this.glassTier < 8) {
            for (MTEHatch hatchEnergy : this.getExoticEnergyHatches()) {
                if (hatchEnergy.getConnectionType() != MTEHatch.ConnectionType.LASER) continue;
                return false;
            }
        }
        this.calculateSpeedBonus(this.coilLevel, this.glassTier);
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private void calculateSpeedBonus(HeatingCoilLevel lvl, int glassTier) {
        int bonusTier;
        int n = bonusTier = lvl != null ? Math.min(lvl.getTier() - 3, glassTier - 2) : 0;
        if (bonusTier < 0) {
            this.speedBonus = 1.0;
            return;
        }
        this.speedBonus = 1.0f - 0.05f * (float)bonusTier;
    }

    private void calculateEnergyDiscount(HeatingCoilLevel lvl, GTRecipe recipe) {
        int tierDifference;
        byte recipeTier = GTUtility.getTier(recipe.mEUt);
        int n = tierDifference = lvl != null ? lvl.getTier() + 1 - recipeTier : 0;
        if (tierDifference < 0) {
            this.energyDiscount = 1.0;
            return;
        }
        this.energyDiscount = Math.pow(0.95, tierDifference);
    }

    @Override
    public void explodeMultiblock() {
        super.explodeMultiblock();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 5, 16, 0);
    }

    @Override
    public IStructureDefinition<MTEMegaAlloyBlastSmelter> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fluid Alloy Cooker").addInfo("Runs the same recipes as the normal ABS, except with up to " + EnumChatFormatting.BOLD + EnumChatFormatting.UNDERLINE + 256 + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " parallels.").addInfo("Every coil tier above TPV grants a speed bonus if the equivalent or better glass tier is present.").addInfo(EnumChatFormatting.YELLOW + "Speed Bonus" + EnumChatFormatting.GRAY + ": 5% lower recipe time per tier (additive)").addInfo("Furthermore, an energy discount is granted for using coils above the recipe tier.").addInfo(EnumChatFormatting.YELLOW + "Energy Discount" + EnumChatFormatting.GRAY + ": 5% lower energy consumption per tier (multiplicative)").addInfo(EnumChatFormatting.ITALIC + "Can also use normal ABS coils in their place instead, if you don't like the bonuses :)" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY).addInfo("The glass limits the tier of the energy hatch. UEV glass unlocks all tiers.").addTecTechHatchInfo().addInfo("UV glass required for " + BWTooltipReference.TT + " laser hatches.").addInfo(EnumChatFormatting.ITALIC + "\"all it does is make metals hot\"" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY).beginStructureBlock(11, 20, 11, false).addMaintenanceHatch("Around the controller", 2).addOtherStructurePart("Input Bus, Output Bus, Input Hatch, Output Bus, Energy Hatch", "Bottom Casing", 1).addMufflerHatch("1 in the center of the top layer", 3).toolTipFinisher(EnumChatFormatting.AQUA + "MadMan310");
        return tt;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        int paras = this.getBaseMetaTileEntity().isActive() ? this.processingLogic.getCurrentParallels() : 0;
        int moreSpeed = (int)((1.0 - this.speedBonus) * 100.0);
        int lessEnergy = (int)((1.0 - this.energyDiscount) * 100.0);
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mExoticEnergyHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{EnumChatFormatting.STRIKETHROUGH + "------------" + EnumChatFormatting.RESET + " Critical Information " + EnumChatFormatting.STRIKETHROUGH + "------------", StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime) + EnumChatFormatting.RESET + "t / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime) + EnumChatFormatting.RESET + "t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(-this.lEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getAverageInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*" + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputAmps()) + EnumChatFormatting.RESET + "A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getAverageInputVoltage())] + EnumChatFormatting.RESET, "Parallels: " + EnumChatFormatting.BLUE + paras + EnumChatFormatting.RESET, "Speed Bonus: " + EnumChatFormatting.BLUE + moreSpeed + "%" + EnumChatFormatting.RESET, "Energy Discount: " + EnumChatFormatting.BLUE + lessEnergy + "%" + EnumChatFormatting.RESET, EnumChatFormatting.STRIKETHROUGH + "-----------------------------------------"};
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMegaAlloyBlastSmelter(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(15)), TextureFactory.builder().addIcon(TexturesGtBlock.oMCAMegaAlloyBlastSmelterActive).extFacing().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(15)), TextureFactory.builder().addIcon(TexturesGtBlock.oMCAMegaAlloyBlastSmelter).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(15))};
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.alloyBlastSmelterRecipes;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.coilLevel;
    }

    public void setCoilLevel(HeatingCoilLevel coilLevel) {
        this.coilLevel = coilLevel;
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        } else {
            this.inputSeparation = !this.inputSeparation;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        boolean bl = this.batchMode = !this.batchMode;
        if (this.batchMode) {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
        } else {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
        }
        return true;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 102400;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece("main", stackSize, 5, 16, 0, elementBudget, env, false, true);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.glassTier = aNBT.func_74771_c("glassTier");
        if (!aNBT.func_74764_b("inputSeparation")) {
            this.inputSeparation = aNBT.func_74767_n("separateBusses");
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("glassTier", this.glassTier);
        super.saveNBTData(aNBT);
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }
}

