/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class MTEHatchFluidGenerator
extends MTEHatchInput {
    protected static XSTR floatGen = new XSTR();
    public int mProgresstime = 0;
    public int mMaxProgresstime = 0;

    public MTEHatchFluidGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTEHatchFluidGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public abstract String[] getCustomTooltip();

    public abstract Fluid getFluidToGenerate();

    public abstract int getAmountOfFluidToGenerate();

    public abstract int getMaxTickTime();

    @Override
    public synchronized String[] getDescription() {
        this.mDescriptionArray[1] = "Capacity: " + GTUtility.formatNumbers(this.getCapacity()) + "L";
        String[] hatchTierString = new String[]{"Hatch Tier: " + GTUtility.getColoredTierNameFromTier(this.mTier)};
        String[] aCustomTips = this.getCustomTooltip();
        String[] desc = new String[this.mDescriptionArray.length + aCustomTips.length + 2];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        System.arraycopy(hatchTierString, 0, desc, this.mDescriptionArray.length, 1);
        System.arraycopy(aCustomTips, 0, desc, this.mDescriptionArray.length + 1, aCustomTips.length);
        desc[this.mDescriptionArray.length + aCustomTips.length + 1] = GTPPCore.GT_Tooltip.get();
        return desc;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public abstract MetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (!aBaseMetaTileEntity.isAllowedToWork()) {
            aBaseMetaTileEntity.setActive(false);
            this.mProgresstime = 0;
            this.mMaxProgresstime = 0;
        } else {
            aBaseMetaTileEntity.setActive(true);
            this.mMaxProgresstime = this.getMaxTickTime();
            if (++this.mProgresstime >= this.mMaxProgresstime) {
                if (this.canTankBeFilled()) {
                    this.addFluidToHatch(aTick);
                }
                this.mProgresstime = 0;
            }
        }
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        this.mProgresstime += aProgress;
        return this.mMaxProgresstime - this.mProgresstime;
    }

    public abstract void generateParticles(World var1, String var2);

    @Override
    public int getTankPressure() {
        return 100;
    }

    @Override
    public abstract int getCapacity();

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    public abstract boolean doesHatchMeetConditionsToGenerate();

    public boolean addFluidToHatch(long aTick) {
        if (!this.doesHatchMeetConditionsToGenerate()) {
            return false;
        }
        int aFillAmount = this.fill(FluidUtils.getFluidStack(this.getFluidToGenerate(), this.getAmountOfFluidToGenerate()), true);
        if (aFillAmount > 0 && this.getBaseMetaTileEntity().isClientSide()) {
            this.generateParticles(this.getBaseMetaTileEntity().getWorld(), "cloud");
        }
        return aFillAmount > 0;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || aFluid.getFluid() != this.getFluidToGenerate() || !this.canTankBeFilled()) {
            return 0;
        }
        if (this.getFillableStack() == null || this.getFillableStack().getFluid().getID() <= 0) {
            if (aFluid.amount <= this.getCapacity()) {
                if (doFill) {
                    this.setFillableStack(aFluid.copy());
                    this.getBaseMetaTileEntity().func_70296_d();
                }
                return aFluid.amount;
            }
            if (doFill) {
                this.setFillableStack(aFluid.copy());
                this.getFillableStack().amount = this.getCapacity();
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return this.getCapacity();
        }
        if (!this.getFillableStack().isFluidEqual(aFluid)) {
            return 0;
        }
        int space = this.getCapacity() - this.getFillableStack().amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                this.getFillableStack().amount += aFluid.amount;
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return aFluid.amount;
        }
        if (doFill) {
            this.getFillableStack().amount = this.getCapacity();
        }
        return space;
    }

    @Override
    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        return false;
    }

    @Override
    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return 0;
    }

    @Override
    public int fill_default(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        return 0;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        super.loadNBTData(aNBT);
    }
}

