/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.minecraft;

import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverInfo;
import gtPlusPlus.core.tileentities.base.TileEntityBase;
import gtPlusPlus.core.util.data.ArrayUtils;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class BTF_Inventory
implements ISidedInventory {
    public final ItemStack[] mInventory;
    public final TileEntityBase mTile;

    public BTF_Inventory(int aSlots, TileEntityBase tile) {
        this.mInventory = new ItemStack[aSlots];
        this.mTile = tile;
    }

    public ItemStack[] getRealInventory() {
        this.purgeNulls();
        return this.mInventory;
    }

    public int func_70302_i_() {
        return this.mInventory.length;
    }

    public ItemStack func_70301_a(int aIndex) {
        return aIndex >= 0 && aIndex < this.mInventory.length ? this.mInventory[aIndex] : null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        if (aIndex >= 0 && aIndex < this.mInventory.length) {
            this.mInventory[aIndex] = aStack;
        }
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean setStackToZeroInsteadOfNull(int aIndex) {
        return false;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.isValidSlot(aIndex);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        ItemStack tStack = this.func_70301_a(aIndex);
        ItemStack rStack = GTUtility.copy(new Object[]{tStack});
        if (tStack != null) {
            if (tStack.field_77994_a <= aAmount) {
                if (this.setStackToZeroInsteadOfNull(aIndex)) {
                    tStack.field_77994_a = 0;
                } else {
                    this.func_70299_a(aIndex, null);
                }
            } else {
                rStack = tStack.func_77979_a(aAmount);
                if (tStack.field_77994_a == 0 && !this.setStackToZeroInsteadOfNull(aIndex)) {
                    this.func_70299_a(aIndex, null);
                }
            }
        }
        return rStack;
    }

    public int[] func_94128_d(int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        ArrayList<Integer> tList = new ArrayList<Integer>();
        CoverInfo coverInfo = this.mTile.getCoverInfoAtSide(side);
        boolean tSkip = coverInfo.letsItemsIn(-2) || coverInfo.letsItemsIn(-2);
        for (int rArray = 0; rArray < this.func_70302_i_(); ++rArray) {
            if (!this.isValidSlot(rArray) || !tSkip && !coverInfo.letsItemsOut(rArray) && !coverInfo.letsItemsIn(rArray)) continue;
            tList.add(rArray);
        }
        int[] arg6 = new int[tList.size()];
        for (int i = 0; i < arg6.length; ++i) {
            arg6[i] = (Integer)tList.get(i);
        }
        return arg6;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GTUtility.areStacksEqual(aStack, this.mInventory[aIndex])) && this.allowPutStack(this.mTile, aIndex, ForgeDirection.getOrientation((int)ordinalSide), aStack);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && this.allowPullStack(this.mTile, aIndex, ForgeDirection.getOrientation((int)ordinalSide), aStack);
    }

    public boolean allowPullStack(TileEntityBase mTile2, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex >= 0 && aIndex < this.func_70302_i_();
    }

    public boolean allowPutStack(TileEntityBase aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex >= 0 && aIndex < this.func_70302_i_() && (this.mInventory[aIndex] == null || GTUtility.areStacksEqual(this.mInventory[aIndex], aStack));
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public final boolean func_145818_k_() {
        return this.mTile != null && this.mTile.func_145818_k_();
    }

    public void func_70296_d() {
        if (this.mTile != null) {
            this.purgeNulls();
            this.mTile.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public final String func_145825_b() {
        return this.mTile != null ? this.mTile.func_145825_b() : "";
    }

    public boolean isFull() {
        for (int s = 0; s < this.func_70302_i_(); ++s) {
            ItemStack slot = this.mInventory[s];
            if (slot != null && slot.field_77994_a == slot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (int s = 0; s < this.func_70302_i_(); ++s) {
            ItemStack slot = this.mInventory[s];
            if (slot == null) continue;
            return false;
        }
        return true;
    }

    public boolean addItemStack(ItemStack aInput) {
        if (aInput != null & (this.isEmpty() || !this.isFull())) {
            for (int s = 0; s < this.func_70302_i_(); ++s) {
                ItemStack slot;
                if (this.mInventory == null || this.mInventory[s] == null || (slot = this.mInventory[s]) != null && (slot == null || !GTUtility.areStacksEqual(aInput, slot) || slot.field_77994_a == slot.func_77973_b().getItemStackLimit(slot))) continue;
                if (slot == null) {
                    slot = aInput.func_77946_l();
                } else {
                    ++slot.field_77994_a;
                }
                this.func_70299_a(s, slot);
                return true;
            }
        }
        return false;
    }

    public final void purgeNulls() {
        ItemStack[] aTemp = ArrayUtils.removeNulls(this.mInventory);
        for (int g = 0; g < this.func_70302_i_(); ++g) {
            if (aTemp.length < this.func_70302_i_()) {
                if (g <= aTemp.length - 1) {
                    this.mInventory[g] = aTemp[g];
                    continue;
                }
                this.mInventory[g] = null;
                continue;
            }
            this.mInventory[g] = aTemp[g];
        }
    }
}

