/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class ProcessingDye
implements IOreRecipeRegistrator {
    public ProcessingDye() {
        OrePrefixes.dye.add(this);
    }

    @Override
    public void registerOre(OrePrefixes prefix, Materials material, String oreDictName, String modName, ItemStack stack) {
        Dyes aDye = Dyes.get(oreDictName);
        if (aDye.mIndex >= 0 && aDye.mIndex < 16 && GTUtility.getContainerItem(stack, true) == null) {
            this.registerAlloySmelter(stack, aDye);
            this.registerMixer(stack, aDye);
            this.registerChemicalReactor(stack, aDye);
        }
    }

    public void registerMixer(ItemStack stack, Dyes dye) {
        String fluidName = "dye.watermixed." + dye.name().toLowerCase(Locale.ENGLISH);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, stack), GTUtility.getIntegratedCircuit(1)).fluidInputs(Materials.Water.getFluid(216L)).fluidOutputs(FluidRegistry.getFluidStack((String)fluidName, (int)192)).duration(16).eut(4).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, stack), GTUtility.getIntegratedCircuit(1)).fluidInputs(GTModHandler.getDistilledWater(288L)).fluidOutputs(FluidRegistry.getFluidStack((String)fluidName, (int)216)).duration(16).eut(4).addTo(RecipeMaps.mixerRecipes);
    }

    public void registerAlloySmelter(ItemStack stack, Dyes dye) {
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Glass, 8L), GTUtility.copyAmount(1, stack)).itemOutputs(new ItemStack((Block)Blocks.field_150399_cn, 8, 15 - dye.mIndex)).duration(200).eut(8).addTo(RecipeMaps.alloySmelterRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(Blocks.field_150359_w, 8, Short.MAX_VALUE), GTUtility.copyAmount(1, stack)).itemOutputs(new ItemStack((Block)Blocks.field_150399_cn, 8, 15 - dye.mIndex)).duration(200).eut(8).addTo(RecipeMaps.alloySmelterRecipes);
    }

    public void registerChemicalReactor(ItemStack stack, Dyes dye) {
        String fluidName = "dye.chemical." + dye.name().toLowerCase(Locale.ENGLISH);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, stack), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Salt, 2L)).fluidInputs(Materials.SulfuricAcid.getFluid(432L)).fluidOutputs(FluidRegistry.getFluidStack((String)fluidName, (int)288)).duration(600).eut(48).addTo(GTRecipeConstants.UniversalChemical);
    }
}

