/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverConveyor
extends CoverBehavior {
    public final int mTickRate;
    private final int mMaxStacks;

    public CoverConveyor(int aTickRate, int maxStacks, ITexture coverTexture) {
        super(coverTexture);
        this.mTickRate = aTickRate;
        this.mMaxStacks = maxStacks;
    }

    @Override
    public boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable % 6 > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return aCoverVariable;
        }
        TileEntity tTileEntity = aTileEntity.getTileEntityAtSide(side);
        ICoverable fromEntity = aCoverVariable % 2 == 0 ? aTileEntity : tTileEntity;
        ICoverable toEntity = aCoverVariable % 2 != 0 ? aTileEntity : tTileEntity;
        ForgeDirection fromSide = aCoverVariable % 2 != 0 ? side.getOpposite() : side;
        ForgeDirection toSide = aCoverVariable % 2 == 0 ? side.getOpposite() : side;
        GTUtility.moveMultipleItemStacks(fromEntity, toEntity, fromSide, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1, this.mMaxStacks);
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 12) < 0) {
            aCoverVariable = 11;
        }
        switch (aCoverVariable) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("006", "Export"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("007", "Import"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("008", "Export (conditional)"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("009", "Import (conditional)"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("010", "Export (invert cond)"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("011", "Import (invert cond)"));
                break;
            }
            case 6: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("012", "Export allow Input"));
                break;
            }
            case 7: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("013", "Import allow Output"));
                break;
            }
            case 8: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("014", "Export allow Input (conditional)"));
                break;
            }
            case 9: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("015", "Import allow Output (conditional)"));
                break;
            }
            case 10: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("016", "Export allow Input (invert cond)"));
                break;
            }
            case 11: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("017", "Import allow Output (invert cond)"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return aCoverVariable >= 6 || aCoverVariable % 2 != 0;
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return aCoverVariable >= 6 || aCoverVariable % 2 == 0;
    }

    @Override
    public boolean alwaysLookConnected(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return this.mTickRate;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ConveyorUIFactory(buildContext).createWindow();
    }

    private class ConveyorUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private CoverDataFollowerToggleButtonWidget<ISerializableObject.LegacyCoverData> mBlockWidget;
        private CoverDataFollowerToggleButtonWidget<ISerializableObject.LegacyCoverData> mAllowWidget;

        public ConveyorUIFactory(CoverUIBuildContext buildContext) {
            super(CoverConveyor.this, buildContext);
            this.mBlockWidget = null;
            this.mAllowWidget = null;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, CoverConveyor.this, (id, coverData) -> !this.getClickable((int)id, CoverConveyor.convert(coverData)), (id, coverData) -> new ISerializableObject.LegacyCoverData(this.getNewCoverVariable((int)id, CoverConveyor.convert(coverData)))).addToggleButton(0, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_EXPORT).addTooltip(GTUtility.trans("006", "Export")).setPos(0, 0)).addToggleButton(1, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_IMPORT).addTooltip(GTUtility.trans("007", "Import")).setPos(18, 0)).addToggleButton(2, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CHECKMARK).addTooltip(GTUtility.trans("224", "Always On")).setPos(0, 18)).addToggleButton(3, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_USE_PROCESSING_STATE).addTooltip(GTUtility.trans("343", "Use Machine Processing State")).setPos(18, 18)).addToggleButton(4, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_USE_INVERTED_PROCESSING_STATE).addTooltip(GTUtility.trans("343.1", "Use Inverted Machine Processing State")).setPos(36, 18)).addToggleButton(5, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> {
                this.mAllowWidget = widget;
                widget.setTextureGetter(i -> {
                    ISerializableObject.LegacyCoverData coverData = (ISerializableObject.LegacyCoverData)this.getCoverData();
                    return coverData == null || coverData.get() % 2 == 0 ? GTUITextures.OVERLAY_BUTTON_ALLOW_INPUT : GTUITextures.OVERLAY_BUTTON_ALLOW_OUTPUT;
                }).dynamicTooltip(() -> {
                    ISerializableObject.LegacyCoverData coverData = (ISerializableObject.LegacyCoverData)this.getCoverData();
                    return Collections.singletonList(coverData == null || coverData.get() % 2 == 0 ? GTUtility.trans("314", "Allow Input") : GTUtility.trans("312", "Allow Output"));
                }).setPos(0, 36);
            }).addToggleButton(6, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> {
                this.mBlockWidget = widget;
                widget.setTextureGetter(i -> {
                    ISerializableObject.LegacyCoverData coverData = (ISerializableObject.LegacyCoverData)this.getCoverData();
                    return coverData == null || coverData.get() % 2 == 0 ? GTUITextures.OVERLAY_BUTTON_BLOCK_INPUT : GTUITextures.OVERLAY_BUTTON_BLOCK_OUTPUT;
                }).dynamicTooltip(() -> {
                    ISerializableObject.LegacyCoverData coverData = (ISerializableObject.LegacyCoverData)this.getCoverData();
                    return Collections.singletonList(coverData == null || coverData.get() % 2 == 0 ? GTUtility.trans("313", "Block Input") : GTUtility.trans("311", "Block Output"));
                }).setPos(18, 36);
            }).setPos(10, 25))).widget(new TextWidget(GTUtility.trans("229", "Export/Import")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(67, 29))).widget(new TextWidget(GTUtility.trans("230", "Conditional")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(67, 47))).widget(TextWidget.dynamicString(() -> {
                ISerializableObject.LegacyCoverData coverData = (ISerializableObject.LegacyCoverData)this.getCoverData();
                return coverData == null || coverData.get() % 2 == 0 ? GTUtility.trans("344", "Input Blocking") : GTUtility.trans("344.1", "Output Blocking");
            }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(67, 65));
        }

        private int getNewCoverVariable(int id, int coverVariable) {
            switch (id) {
                case 0: {
                    if (this.mBlockWidget != null) {
                        this.mBlockWidget.notifyTooltipChange();
                    }
                    if (this.mAllowWidget != null) {
                        this.mAllowWidget.notifyTooltipChange();
                    }
                    return coverVariable & 0xFFFFFFFE;
                }
                case 1: {
                    if (this.mBlockWidget != null) {
                        this.mBlockWidget.notifyTooltipChange();
                    }
                    if (this.mAllowWidget != null) {
                        this.mAllowWidget.notifyTooltipChange();
                    }
                    return coverVariable | 1;
                }
                case 2: {
                    if (coverVariable > 5) {
                        return 6 | coverVariable & 0xFFFFFFF1;
                    }
                    return coverVariable & 0xFFFFFFF1;
                }
                case 3: {
                    if (coverVariable > 5) {
                        return 8 | coverVariable & 0xFFFFFFF1;
                    }
                    return 2 | coverVariable & 0xFFFFFFF1;
                }
                case 4: {
                    if (coverVariable > 5) {
                        return 0xA | coverVariable & 0xFFFFFFF1;
                    }
                    return 4 | coverVariable & 0xFFFFFFF1;
                }
                case 5: {
                    if (coverVariable > 5) break;
                    return coverVariable + 6;
                }
                case 6: {
                    if (coverVariable <= 5) break;
                    return coverVariable - 6;
                }
            }
            return coverVariable;
        }

        private boolean getClickable(int id, int coverVariable) {
            boolean bl;
            if (coverVariable < 0 || 11 < coverVariable) {
                return false;
            }
            switch (id) {
                case 0: 
                case 1: {
                    if ((1 & coverVariable) != id) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (coverVariable % 6 >= 2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (coverVariable % 6 < 2 || 4 <= coverVariable % 6) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (coverVariable % 6 < 4) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 5: {
                    if (coverVariable < 6) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 6: {
                    if (coverVariable >= 6) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }
}

