/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import codechicken.nei.api.API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEFrame
extends MetaPipeEntity {
    private static final String localizedDescFormat = GTLanguageManager.addStringLocalization("gt.blockmachines.gt_frame.desc.format", "Just something you can put covers on.");
    public final Materials mMaterial;

    public MTEFrame(int aID, String aName, String aNameRegional, Materials aMaterial) {
        super(aID, aName, aNameRegional, 0);
        this.mMaterial = aMaterial;
        API.hideItem((ItemStack)this.getStackForm(1L));
    }

    public MTEFrame(String aName, Materials aMaterial) {
        super(aName, 0);
        this.mMaterial = aMaterial;
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)(this.mMaterial == null ? 4 : 4 + Math.max(0, Math.min(3, this.mMaterial.mToolQuality)));
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEFrame(this.mName, this.mMaterial);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, int connections, int colorIndex, boolean active, boolean redstoneLevel) {
        return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[OrePrefixes.frameGt.mTextureIndex], Dyes.getModulation(colorIndex, this.mMaterial.mRGBa))};
    }

    @Override
    public String[] getDescription() {
        return localizedDescFormat.split("\\R");
    }

    @Override
    public final boolean isSimpleMachine() {
        return true;
    }

    @Override
    public final boolean isFacingValid(ForgeDirection facing) {
        return false;
    }

    @Override
    public final boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public final boolean renderInside(ForgeDirection side) {
        return true;
    }

    @Override
    public final float getThickNess() {
        return 1.0f;
    }

    @Override
    public final void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public final void loadNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public final boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public final boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int connect(ForgeDirection side) {
        return 0;
    }

    @Override
    public void disconnect(ForgeDirection side) {
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return true;
    }
}

