/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregtechWailaProvider;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.net.GTPacketRequestCoverData;
import gregtech.api.net.GTPacketSendCoverData;
import gregtech.api.objects.GTItemStack;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.ISerializableObject;
import gregtech.common.GTClient;
import gregtech.common.covers.CoverFluidfilter;
import gregtech.common.covers.CoverInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class CoverableTileEntity
extends BaseTileEntity
implements ICoverable,
IGregtechWailaProvider {
    public static final String[] COVER_DATA_NBT_KEYS = (String[])Arrays.stream(ForgeDirection.VALID_DIRECTIONS).mapToInt(Enum::ordinal).mapToObj(i -> "mCoverData" + i).toArray(String[]::new);
    protected final CoverInfo[] coverInfos = new CoverInfo[]{null, null, null, null, null, null};
    private byte validCoversMask;
    protected byte[] mSidedRedstone = new byte[]{15, 15, 15, 15, 15, 15};
    protected boolean mRedstone = false;
    protected byte mStrongRedstone = 0;
    protected short mID = 0;
    public long mTickTimer = 0L;
    private Map<ForgeDirection, ISerializableObject> clientCoverData = new HashMap<ForgeDirection, ISerializableObject>();
    protected static final int COVER_WINDOW_ID_START = 1;

    protected void writeCoverNBT(NBTTagCompound aNBT, boolean isDrop) {
        NBTTagList tList = new NBTTagList();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(side);
            if (!coverInfo.isValid()) continue;
            tList.func_74742_a((NBTBase)coverInfo.writeToNBT(new NBTTagCompound()));
            aNBT.func_74782_a(COVER_DATA_NBT_KEYS[side.ordinal()], coverInfo.getCoverData().saveDataToNBT());
        }
        if (tList.func_74745_c() > 0) {
            aNBT.func_74782_a("gt.covers", (NBTBase)tList);
            int[] coverSides = new int[]{0, 0, 0, 0, 0, 0};
            aNBT.func_74783_a("mCoverSides", coverSides);
        }
        if (this.mStrongRedstone > 0) {
            aNBT.func_74774_a("mStrongRedstone", this.mStrongRedstone);
        }
        if (!isDrop) {
            aNBT.func_74773_a("mRedstoneSided", this.mSidedRedstone);
            aNBT.func_74757_a("mRedstone", this.mRedstone);
        }
    }

    protected void readCoverNBT(NBTTagCompound aNBT) {
        byte[] byArray;
        this.mRedstone = aNBT.func_74767_n("mRedstone");
        if (aNBT.func_74764_b("mRedstoneSided")) {
            byArray = aNBT.func_74770_j("mRedstoneSided");
        } else {
            byte[] byArray2 = new byte[6];
            byArray2[0] = 15;
            byArray2[1] = 15;
            byArray2[2] = 15;
            byArray2[3] = 15;
            byArray2[4] = 15;
            byArray = byArray2;
            byArray2[5] = 15;
        }
        this.mSidedRedstone = byArray;
        this.mStrongRedstone = aNBT.func_74771_c("mStrongRedstone");
        if (aNBT.func_74764_b("gt.covers")) {
            this.readCoverInfoNBT(aNBT);
        } else if (aNBT.func_74764_b("mCoverSides")) {
            this.readLegacyCoverInfoNBT(aNBT);
        }
    }

    public void readCoverInfoNBT(NBTTagCompound aNBT) {
        NBTTagList tList = aNBT.func_150295_c("gt.covers", 10);
        for (int i = 0; i < tList.func_74745_c(); i = (int)((byte)(i + 1))) {
            NBTTagCompound tNBT = tList.func_150305_b(i);
            CoverInfo coverInfo = new CoverInfo(this, tNBT);
            this.setCoverInfoAtSide(coverInfo.getSide(), coverInfo);
            if (!coverInfo.isDataNeededOnClient()) continue;
            this.issueCoverUpdate(ForgeDirection.getOrientation((int)i));
        }
    }

    public void readLegacyCoverInfoNBT(NBTTagCompound aNBT) {
        int[] nArray;
        if (aNBT.func_74764_b("mCoverSides")) {
            nArray = aNBT.func_74759_k("mCoverSides");
        } else {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray2[4] = 0;
            nArray = nArray2;
            nArray2[5] = 0;
        }
        int[] coverIDs = nArray;
        boolean hasOldCoverData = aNBT.func_150297_b("mCoverData", 11) && aNBT.func_74759_k("mCoverData").length == 6;
        int[] tOldData = hasOldCoverData ? aNBT.func_74759_k("mCoverData") : new int[]{};
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo;
            CoverBehaviorBase<?> coverBehavior;
            int ordinalSide = side.ordinal();
            if (coverIDs[ordinalSide] == 0 || (coverBehavior = (coverInfo = new CoverInfo(side, coverIDs[ordinalSide], this, null)).getCoverBehavior()) == GregTechAPI.sNoBehavior) continue;
            ISerializableObject coverData = null;
            if (hasOldCoverData) {
                if (coverBehavior instanceof CoverFluidfilter) {
                    String filterKey = String.format("fluidFilter%d", ordinalSide);
                    if (aNBT.func_74764_b(filterKey)) {
                        coverData = (ISerializableObject)coverInfo.getCoverBehavior().createDataObject(tOldData[ordinalSide] & 7 | FluidRegistry.getFluidID((String)aNBT.func_74779_i(filterKey)) << 3);
                    }
                } else {
                    coverData = (ISerializableObject)coverBehavior.createDataObject(tOldData[ordinalSide]);
                }
            } else if (aNBT.func_74764_b(COVER_DATA_NBT_KEYS[ordinalSide])) {
                coverData = (ISerializableObject)coverBehavior.createDataObject(aNBT.func_74781_a(COVER_DATA_NBT_KEYS[ordinalSide]));
            }
            if (coverData != null) {
                coverInfo.setCoverData(coverData);
            }
            this.setCoverInfoAtSide(side, coverInfo);
            if (!coverInfo.isDataNeededOnClient()) continue;
            this.issueCoverUpdate(side);
        }
    }

    public abstract boolean isStillValid();

    protected boolean doCoverThings() {
        byte validCoversMask = this.validCoversMask;
        if (validCoversMask == 0) {
            return true;
        }
        for (int i = Integer.numberOfTrailingZeros(validCoversMask); i < 6; ++i) {
            if ((validCoversMask >>> i & 1) == 0 || this.tickCoverAtSide(ForgeDirection.VALID_DIRECTIONS[i])) continue;
            return false;
        }
        return true;
    }

    protected void onCoverUnload() {
        byte validCoversMask = this.validCoversMask;
        if (validCoversMask == 0) {
            return;
        }
        for (int i = Integer.numberOfTrailingZeros(validCoversMask); i < 6; ++i) {
            if ((validCoversMask >>> i & 1) == 0) continue;
            this.onCoverUnloadAtSide(ForgeDirection.VALID_DIRECTIONS[i]);
        }
    }

    public void onCoverUnloadAtSide(ForgeDirection side) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (!coverInfo.isValid()) {
            return;
        }
        coverInfo.onCoverUnload();
    }

    public boolean tickCoverAtSide(ForgeDirection side) {
        return this.tickCoverAtSide(side, this.mTickTimer);
    }

    public boolean tickCoverAtSide(ForgeDirection side, long aTickTimer) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (!coverInfo.isValid()) {
            return true;
        }
        int tCoverTickRate = coverInfo.getTickRate();
        if (tCoverTickRate > 0 && aTickTimer % (long)tCoverTickRate == 0L) {
            byte tRedstone = coverInfo.isRedstoneSensitive(aTickTimer) ? this.getInputRedstoneSignal(side) : (byte)0;
            coverInfo.setCoverData(coverInfo.doCoverThings(aTickTimer, tRedstone));
            return this.isStillValid();
        }
        return true;
    }

    public abstract boolean allowCoverOnSide(ForgeDirection var1, GTItemStack var2);

    protected void checkDropCover() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            int coverId = this.getCoverIDAtSide(side);
            if (coverId == 0 || this.allowCoverOnSide(side, new GTItemStack(coverId))) continue;
            this.dropCover(side, side, true);
        }
    }

    protected void updateCoverBehavior() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(side);
            if (!coverInfo.isValid()) continue;
            coverInfo.updateCoverBehavior();
        }
    }

    @Override
    public void issueCoverUpdate(ForgeDirection side) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (this.field_145850_b == null || this.isServerSide() && coverInfo.isDataNeededOnClient()) {
            coverInfo.setNeedsUpdate(true);
        }
    }

    public final ITexture getCoverTexture(ForgeDirection side) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (!coverInfo.isValid()) {
            return null;
        }
        if (GTMod.instance.isClientSide() && (GTClient.hideValue & 1) != 0) {
            return Textures.BlockIcons.HIDDEN_TEXTURE[0];
        }
        ITexture coverTexture = !(this instanceof BaseMetaPipeEntity) ? coverInfo.getSpecialCoverFGTexture() : coverInfo.getSpecialCoverTexture();
        return coverTexture != null ? coverTexture : GregTechAPI.sCovers.get(new GTItemStack(this.getCoverIDAtSide(side)));
    }

    protected void requestCoverDataIfNeeded() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(side);
            if (!coverInfo.isDataNeededOnClient()) continue;
            GTValues.NW.sendToServer(new GTPacketRequestCoverData(coverInfo, this));
        }
    }

    @Override
    public void setCoverIdAndDataAtSide(ForgeDirection side, int aId, ISerializableObject aData) {
        if (this.setCoverIDAtSideNoUpdate(side, aId, aData)) {
            this.issueCoverUpdate(side);
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setCoverIDAtSide(ForgeDirection side, int aID) {
        this.setCoverIdAndDataAtSide(side, aID, null);
    }

    @Override
    public boolean setCoverIDAtSideNoUpdate(ForgeDirection side, int aID) {
        return this.setCoverIDAtSideNoUpdate(side, aID, null);
    }

    public boolean setCoverIDAtSideNoUpdate(ForgeDirection side, int aID, ISerializableObject aData) {
        CoverInfo oldCoverInfo = this.getCoverInfoAtSide(side);
        if (side != ForgeDirection.UNKNOWN && oldCoverInfo.getCoverID() != aID) {
            if (aID == 0 && this.isClientSide()) {
                oldCoverInfo.onDropped();
            }
            this.setCoverInfoAtSide(side, new CoverInfo(side, aID, this, aData));
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void setCoverDataAtSide(ForgeDirection side, int aData) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (coverInfo.isValid() && coverInfo.getCoverData() instanceof ISerializableObject.LegacyCoverData) {
            coverInfo.setCoverData(new ISerializableObject.LegacyCoverData(aData));
        }
    }

    @Override
    public void setCoverDataAtSide(ForgeDirection side, ISerializableObject aData) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (coverInfo.isValid() && coverInfo.getCoverBehavior().cast(aData) != null) {
            coverInfo.setCoverData(aData);
        }
    }

    @Override
    @Deprecated
    public CoverBehavior getCoverBehaviorAtSide(ForgeDirection side) {
        CoverBehaviorBase<?> behavior = this.getCoverInfoAtSide(side).getCoverBehavior();
        if (behavior instanceof CoverBehavior) {
            return (CoverBehavior)behavior;
        }
        return GregTechAPI.sNoBehavior;
    }

    @Override
    public void setCoverItemAtSide(ForgeDirection side, ItemStack aCover) {
        GregTechAPI.getCoverBehaviorNew(aCover).placeCover(side, aCover, this);
    }

    @Override
    public int getCoverIDAtSide(ForgeDirection side) {
        return this.getCoverInfoAtSide(side).getCoverID();
    }

    @Override
    public ItemStack getCoverItemAtSide(ForgeDirection side) {
        return this.getCoverInfoAtSide(side).getDisplayStack();
    }

    @Override
    public boolean canPlaceCoverIDAtSide(ForgeDirection side, int aID) {
        return this.getCoverIDAtSide(side) == 0;
    }

    @Override
    public boolean canPlaceCoverItemAtSide(ForgeDirection side, ItemStack aCover) {
        return this.getCoverIDAtSide(side) == 0;
    }

    @Override
    @Deprecated
    public int getCoverDataAtSide(ForgeDirection side) {
        ISerializableObject coverData = this.getCoverInfoAtSide(side).getCoverData();
        if (coverData instanceof ISerializableObject.LegacyCoverData) {
            return ((ISerializableObject.LegacyCoverData)coverData).get();
        }
        return 0;
    }

    @Override
    public ISerializableObject getComplexCoverDataAtSide(ForgeDirection side) {
        return this.getCoverInfoAtSide(side).getCoverData();
    }

    @Override
    public CoverBehaviorBase<?> getCoverBehaviorAtSideNew(ForgeDirection side) {
        return this.getCoverInfoAtSide(side).getCoverBehavior();
    }

    public final void setCoverInfoAtSide(ForgeDirection side, CoverInfo coverInfo) {
        if (side != ForgeDirection.UNKNOWN) {
            this.coverInfos[side.ordinal()] = coverInfo;
            this.validCoversMask = (byte)(this.validCoversMask & (byte)(~side.flag));
            if (coverInfo.isValid()) {
                this.validCoversMask = (byte)(this.validCoversMask | side.flag);
            }
        }
    }

    @Override
    public final CoverInfo getCoverInfoAtSide(ForgeDirection side) {
        int ordinalSide = side.ordinal();
        if (side != ForgeDirection.UNKNOWN) {
            CoverInfo coverInfo = this.coverInfos[ordinalSide];
            if (coverInfo == null) {
                coverInfo = this.coverInfos[ordinalSide] = new CoverInfo(side, this);
            }
            return coverInfo;
        }
        return CoverInfo.EMPTY_INFO;
    }

    public void clearCoverInfoAtSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            this.setCoverIDAtSide(side, 0);
        }
    }

    @Override
    public boolean dropCover(ForgeDirection side, ForgeDirection droppedSide, boolean aForced) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (!coverInfo.isValid()) {
            return false;
        }
        if (!coverInfo.onCoverRemoval(aForced) && !aForced) {
            return false;
        }
        ItemStack tStack = coverInfo.getDrop();
        if (tStack != null) {
            coverInfo.onDropped();
            EntityItem tEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(droppedSide, 1) + 0.5, (double)this.getOffsetY(droppedSide, 1) + 0.5, (double)this.getOffsetZ(droppedSide, 1) + 0.5, tStack);
            tEntity.field_70159_w = 0.0;
            tEntity.field_70181_x = 0.0;
            tEntity.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)tEntity);
        }
        this.clearCoverInfoAtSide(side);
        this.updateOutputRedstoneSignal(side);
        return true;
    }

    protected void onBaseTEDestroyed() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(side);
            if (!coverInfo.isValid()) continue;
            coverInfo.onBaseTEDestroyed();
        }
    }

    @Override
    public void setOutputRedstoneSignal(ForgeDirection side, byte strength) {
        byte cappedStrength = (byte)Math.min(Math.max(0, strength), 15);
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        int ordinalSide = side.ordinal();
        if (this.mSidedRedstone[ordinalSide] != cappedStrength || (this.mStrongRedstone & 1 << ordinalSide) > 0) {
            this.mSidedRedstone[ordinalSide] = cappedStrength;
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setStrongOutputRedstoneSignal(ForgeDirection side, byte strength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | (byte)side.flag);
        this.setOutputRedstoneSignal(side, strength);
    }

    @Override
    public void setInternalOutputRedstoneSignal(ForgeDirection side, byte aStrength) {
        if (!this.getCoverBehaviorAtSideNew(side).manipulatesSidedRedstoneOutput(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), this)) {
            this.setOutputRedstoneSignal(side, aStrength);
        }
    }

    @Override
    public boolean getRedstone() {
        return Arrays.stream(ForgeDirection.VALID_DIRECTIONS).anyMatch(this::getRedstone);
    }

    @Override
    public boolean getRedstone(ForgeDirection side) {
        return this.getInternalInputRedstoneSignal(side) > 0;
    }

    @Override
    public byte getStrongestRedstone() {
        return Arrays.stream(ForgeDirection.VALID_DIRECTIONS).map(this::getInternalInputRedstoneSignal).max(Comparator.comparing(Byte::valueOf)).orElse((byte)0);
    }

    @Override
    public byte getStrongOutputRedstoneSignal(ForgeDirection side) {
        int ordinalSide = side.ordinal();
        return side != ForgeDirection.UNKNOWN && (this.mStrongRedstone & 1 << ordinalSide) != 0 ? (byte)(this.mSidedRedstone[ordinalSide] & 0xF) : (byte)0;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
        this.mRedstone = aOnOff;
    }

    @Override
    public byte getInternalInputRedstoneSignal(ForgeDirection side) {
        return (byte)(this.getCoverBehaviorAtSideNew(side).getRedstoneInput(side, this.getInputRedstoneSignal(side), this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), this) & 0xF);
    }

    @Override
    public byte getInputRedstoneSignal(ForgeDirection side) {
        return (byte)(this.field_145850_b.func_72878_l(this.getOffsetX(side, 1), (int)this.getOffsetY(side, 1), this.getOffsetZ(side, 1), side.ordinal()) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(ForgeDirection side) {
        return this.getCoverBehaviorAtSideNew(side).manipulatesSidedRedstoneOutput(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), this) ? this.mSidedRedstone[side.ordinal()] : this.getGeneralRS(side);
    }

    protected void updateOutputRedstoneSignal(ForgeDirection side) {
        this.setOutputRedstoneSignal(side, (byte)0);
    }

    @Override
    public void receiveCoverData(ForgeDirection coverSide, int aCoverID, int aCoverData) {
        if (coverSide == ForgeDirection.UNKNOWN) {
            return;
        }
        CoverInfo oldCoverInfo = this.getCoverInfoAtSide(coverSide);
        if (!oldCoverInfo.isValid()) {
            return;
        }
        this.setCoverIDAtSideNoUpdate(coverSide, aCoverID);
        this.setCoverDataAtSide(coverSide, aCoverData);
    }

    @Override
    public void receiveCoverData(ForgeDirection coverSide, int aCoverID, ISerializableObject aCoverData, EntityPlayerMP aPlayer) {
        if (coverSide == ForgeDirection.UNKNOWN) {
            return;
        }
        CoverInfo oldCoverInfo = this.getCoverInfoAtSide(coverSide);
        if (!oldCoverInfo.isValid()) {
            return;
        }
        oldCoverInfo.preDataChanged(aCoverID, aCoverData);
        this.setCoverIDAtSideNoUpdate(coverSide, aCoverID, aCoverData);
        this.setCoverDataAtSide(coverSide, aCoverData);
        if (this.isClientSide()) {
            this.getCoverInfoAtSide(coverSide).onDataChanged();
        }
    }

    protected void sendCoverDataIfNeeded() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(side);
            if (!coverInfo.needsUpdate()) continue;
            GTValues.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GTPacketSendCoverData(coverInfo, this), this.field_145851_c, this.field_145849_e);
            coverInfo.setNeedsUpdate(false);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        ForgeDirection currentFacing = accessor.getSide();
        NBTTagList tList = tag.func_150295_c("gt.covers", 10);
        for (int i = 0; i < tList.func_74745_c(); i = (int)((byte)(i + 1))) {
            ItemStack coverStack;
            NBTTagCompound tNBT = tList.func_150305_b(i);
            CoverInfo coverInfo = new CoverInfo(this, tNBT);
            if (!coverInfo.isValid() || coverInfo.getCoverBehavior() == GregTechAPI.sNoBehavior || (coverStack = coverInfo.getDisplayStack()) == null) continue;
            currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.cover", (Object[])new Object[]{currentFacing == coverInfo.getSide() ? StatCollector.func_74838_a((String)"GT5U.waila.cover.current_facing") : StatCollector.func_74838_a((String)("GT5U.interface.coverTabs." + coverInfo.getSide().toString().toLowerCase())), coverStack.func_82833_r()}));
            String behaviorDesc = coverInfo.getBehaviorDescription();
            if (Objects.equals(behaviorDesc, "")) continue;
            currentTip.add(behaviorDesc);
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        this.writeCoverNBT(tag, false);
    }

    public static void addInstalledCoversInformation(NBTTagCompound aNBT, List<String> aList) {
        int[] mCoverSides;
        if (aNBT == null || aList == null) {
            return;
        }
        NBTTagList tList = aNBT.func_150295_c("gt.covers", 10);
        for (int i = 0; i < tList.func_74745_c(); i = (int)((byte)(i + 1))) {
            ItemStack coverStack;
            NBTTagCompound tNBT = tList.func_150305_b(i);
            CoverInfo coverInfo = new CoverInfo(null, tNBT);
            if (!coverInfo.isValid() || coverInfo.getCoverBehavior() == GregTechAPI.sNoBehavior || (coverStack = coverInfo.getDisplayStack()) == null) continue;
            aList.add(String.format("Cover on %s side: %s", GTLanguageManager.getTranslation(GTLanguageManager.FACES[coverInfo.getSide().ordinal()]), coverStack.func_82833_r()));
        }
        if (aNBT.func_74764_b("mCoverSides") && (mCoverSides = aNBT.func_74759_k("mCoverSides")) != null && mCoverSides.length == 6) {
            for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                Object dataObject;
                ItemStack coverStack;
                CoverBehaviorBase<?> behavior;
                int i = tSide.ordinal();
                int coverId = mCoverSides[i];
                if (coverId == 0 || (behavior = GregTechAPI.getCoverBehaviorNew(coverId)) == null || behavior == GregTechAPI.sNoBehavior || !aNBT.func_74764_b(COVER_DATA_NBT_KEYS[i]) || (coverStack = behavior.getDisplayStack(coverId, (ISerializableObject)(dataObject = behavior.createDataObject(aNBT.func_74781_a(COVER_DATA_NBT_KEYS[i]))))) == null) continue;
                aList.add(String.format("Cover on %s side: %s", GTLanguageManager.getTranslation(GTLanguageManager.FACES[i]), coverStack.func_82833_r()));
            }
        }
        byte strongRedstone = aNBT.func_74771_c("mStrongRedstone");
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            String string;
            if ((strongRedstone & dir.flag) == 0) continue;
            Object[] objectArray = new Object[1];
            switch (dir) {
                case DOWN: {
                    string = "bottom";
                    break;
                }
                case UP: {
                    string = "top";
                    break;
                }
                case NORTH: {
                    string = "north";
                    break;
                }
                case SOUTH: {
                    string = "south";
                    break;
                }
                case WEST: {
                    string = "west";
                    break;
                }
                case EAST: {
                    string = "east";
                    break;
                }
                default: {
                    string = "<unknown>";
                }
            }
            objectArray[0] = string;
            aList.add(String.format("Emits a strong redstone signal on the %s side", objectArray));
        }
    }

    protected ModularWindow createCoverWindow(EntityPlayer player, ForgeDirection side) {
        return this.getCoverInfoAtSide(side).createWindow(player);
    }

    @Override
    public void addCoverTabs(ModularWindow.Builder builder, UIBuildContext buildContext) {
        int xPos;
        int COVER_TAB_LEFT = -16;
        boolean COVER_TAB_TOP = true;
        int COVER_TAB_HEIGHT = 20;
        int COVER_TAB_WIDTH = 18;
        int COVER_TAB_SPACING = 2;
        int ICON_SIZE = 16;
        final boolean flipHorizontally = GTMod.gregtechproxy.mCoverTabsFlipped;
        Column columnWidget = new Column();
        builder.widget((Widget)columnWidget);
        int n = xPos = flipHorizontally ? this.getGUIWidth() - -16 - 18 : -16;
        if (GTMod.gregtechproxy.mCoverTabsVisible) {
            columnWidget.setPos(xPos, 1).setEnabled(widget -> ((Column)widget).getChildren().stream().anyMatch(Widget::isEnabled));
        } else {
            columnWidget.setEnabled(false);
        }
        columnWidget.setAlignment(MainAxisAlignment.SPACE_BETWEEN).setSpace(2);
        for (final ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            buildContext.addSyncedWindow(direction.ordinal() + 1, player -> this.createCoverWindow(player, direction));
            columnWidget.addChild(new MultiChildWidget().addChild(new ButtonWidget(){

                public IDrawable[] getBackground() {
                    ArrayList<UITexture> backgrounds = new ArrayList<UITexture>();
                    GUITextureSet tabIconSet = CoverableTileEntity.this.getGUITextureSet();
                    if (CoverableTileEntity.this.getCoverBehaviorAtSideNew(direction).hasCoverGUI()) {
                        if (this.isHovering()) {
                            backgrounds.add(flipHorizontally ? tabIconSet.getCoverTabHighlightFlipped() : tabIconSet.getCoverTabHighlight());
                        } else {
                            backgrounds.add(flipHorizontally ? tabIconSet.getCoverTabNormalFlipped() : tabIconSet.getCoverTabNormal());
                        }
                    } else {
                        backgrounds.add(flipHorizontally ? tabIconSet.getCoverTabDisabledFlipped() : tabIconSet.getCoverTabDisabled());
                    }
                    return backgrounds.toArray(new IDrawable[0]);
                }
            }.setOnClick((clickData, widget) -> this.onTabClicked((Widget.ClickData)clickData, (Widget)widget, direction)).dynamicTooltip(() -> this.getCoverTabTooltip(direction, this.clientCoverData.get(direction))).setSize(18, 20)).addChild(new ItemDrawable(() -> this.getCoverItemAtSide(direction)).asWidget().setPos(1 + (flipHorizontally ? -1 : 1), 2)).setEnabled(widget -> this.getCoverItemAtSide(direction) != null));
        }
        builder.widget((Widget)new FakeSyncWidget(this::collectCoverData, data -> {
            this.clientCoverData = data;
        }, this::writeClientCoverData, this::readClientCoverData));
    }

    @SideOnly(value=Side.CLIENT)
    protected List<String> getCoverTabTooltip(ForgeDirection side, ISerializableObject coverData) {
        String[] SIDE_TOOLTIPS = new String[]{"GT5U.interface.coverTabs.down", "GT5U.interface.coverTabs.up", "GT5U.interface.coverTabs.north", "GT5U.interface.coverTabs.south", "GT5U.interface.coverTabs.west", "GT5U.interface.coverTabs.east"};
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        ItemStack coverItem = coverInfo.getDisplayStack();
        if (coverItem == null) {
            return Collections.emptyList();
        }
        boolean coverHasGUI = coverInfo.hasCoverGUI();
        Minecraft mc = Minecraft.func_71410_x();
        List tooltip = coverItem.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)((coverHasGUI ? EnumChatFormatting.UNDERLINE : EnumChatFormatting.DARK_GRAY) + StatCollector.func_74838_a((String)SIDE_TOOLTIPS[side.ordinal()]) + (coverHasGUI ? EnumChatFormatting.RESET + ": " : ": " + EnumChatFormatting.RESET) + (String)tooltip.get(0)));
        builder.addAll(coverInfo.getAdditionalTooltip(coverData));
        builder.addAll(IntStream.range(1, tooltip.size()).mapToObj(index -> EnumChatFormatting.GRAY + (String)tooltip.get(index)).iterator());
        return builder.build();
    }

    protected void onTabClicked(Widget.ClickData ignoredClickData, Widget widget, ForgeDirection side) {
        if (this.isClientSide()) {
            return;
        }
        widget.getContext().openSyncedWindow(side.ordinal() + 1);
    }

    @NotNull
    private Map<ForgeDirection, ISerializableObject> collectCoverData() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(direction);
            if (!coverInfo.isValid()) continue;
            builder.put((Object)direction, (Object)coverInfo.getCoverData());
        }
        return builder.build();
    }

    private void writeClientCoverData(@NotNull PacketBuffer buffer, @NotNull Map<ForgeDirection, ISerializableObject> dataMap) {
        buffer.writeInt(dataMap.size());
        dataMap.forEach((direction, serializableObject) -> {
            ByteBuf individualBuffer = Unpooled.buffer();
            serializableObject.writeToByteBuf(individualBuffer);
            buffer.writeByte(direction.ordinal());
            buffer.writeInt(individualBuffer.array().length);
            buffer.writeBytes(individualBuffer.array());
        });
    }

    @NotNull
    private Map<ForgeDirection, ISerializableObject> readClientCoverData(@NotNull PacketBuffer buffer) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)buffer.readByte());
            int length = buffer.readInt();
            byte[] object = buffer.readBytes(length).array();
            builder.put((Object)direction, (Object)this.getCoverInfoAtSide(direction).getCoverBehavior().createDataObject().readFromPacket(ByteStreams.newDataInput((byte[])object), null));
        }
        return builder.build();
    }
}

