/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;

public interface IRecipeMap {
    public void addDownstream(IRecipeMap var1);

    @Nonnull
    public Collection<GTRecipe> doAdd(GTRecipeBuilder var1);

    default public IRecipeMap deepCopyInput() {
        return IRecipeMap.newRecipeMap(b -> this.doAdd(b.copy()));
    }

    public static IRecipeMap newRecipeMap(final Function<? super GTRecipeBuilder, Collection<GTRecipe>> func) {
        return new IRecipeMap(){
            private final Collection<IRecipeMap> downstreams = new ArrayList<IRecipeMap>();

            @Override
            public void addDownstream(IRecipeMap downstream) {
                this.downstreams.add(downstream);
            }

            @Override
            @Nonnull
            public Collection<GTRecipe> doAdd(GTRecipeBuilder builder) {
                ArrayList<Collection<Collection<GTRecipe>>> ret = new ArrayList<Collection<Collection<GTRecipe>>>();
                Collection out = (Collection)func.apply(builder);
                ret.add(out);
                builder.clearInvalid();
                if (!out.isEmpty()) {
                    for (IRecipeMap downstream : this.downstreams) {
                        ret.add(downstream.doAdd(builder));
                    }
                }
                return GTUtility.concat(ret);
            }
        };
    }
}

